/*      
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) plugins.c 1.18@(#)
 * pmg@alliance.centerclick.org|src/plugins.c|20011019215807|08982
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"

/* plugin interface for iroffer */


/* ------------------------------------------------------------------ */
/* ----------------------- What is This Stuff? ---------------------- */

/* What is This Stuff? */
/*   this file is an interface for you to add your own features to */
/*   iroffer.  There are plenty of useful functions you can use, see the */
/*   "important info" section. */
/*      ** Don't forget to clean up your memory allocations ** */


/* ------------------------------------------------------------------ */
/* ------------------------- important info ------------------------- */

/* useful functions: */

/*   void writeserver (char *str) */
/*      - send a text string in raw irc (no \n) to the irc server */
/*   int strcmppart (char *str, char *match) */
/*      - returns 1 if match is the same as the first part of str */
/*   char* caps(char *text) */
/*      - changes all lowercase letters in text to uppercase, returns text */
/*   void outerror (int type, const char *format, ...) */
/*      - output/log error err */
/*      - type: 0 = fatal, exits; 1 = serious, continues; 2 = minor, continues */
/*      - format ...: printf-like format and args */
/*   void ioutput(int beg, int dest, const char *color, const char *format, ...) */
/*      - use this for all output/logging! (don't use cout/printf) */
/*      - beg = always 0 */
/*      - dest: OUT_S = screen, OUT_L = log, OUT_D = dccchat, flags can be or'ed together to */
/*              send to more than one place */
/*      - color: ANSI string for color (i.e. "0;33"), NULL for no color */
/*      - format ...: printf-like format and args */

/*  void* mycalloc(int len, const char *comment) */
/*      - use this for all your malloc'ing */
/*      - len = length */
/*      - comment is a comment that shows up in admin: meminfo */
/*  void mydelete(void *ptr) */
/*      - use this for all your free'ing */


/* useful globals: */

/*   char* : */
/*   user_nick          the nick */
/*   caps_nick          the nick in all caps */

/*   long : */
/*   curtime            current time in UTC (seconds) */

/* ------------------------------------------------------------------ */
/* ------- put any #include's here to include your own files -------- */



/* ------------------------------------------------------------------ */
/* ----------- define any global variables you need here ------------ */



/* ------------------------------------------------------------------ */
/* --------- initialization - called once at program startup -------- */

void plugin_initialize (void) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   
   }

/* ------------------------------------------------------------------ */
/* --------- called every main loop (upto 40 times a second) -------- */
/* WARRNING: don't do excessive stuff here, it can use up lots of cpu time */

void plugin_everyloop (void) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   
   }

/* ------------------------------------------------------------------ */
/* --------------------- called every 1 second ---------------------- */

void plugin_every1sec (void) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   
   }

/* ------------------------------------------------------------------ */
/* -------------------- called every 20 seconds --------------------- */

void plugin_every20sec (void) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   
   }

/* ------------------------------------------------------------------ */
/* -------------------- privmsg from irc server --------------------- */
/* fullline: the entire line recieved from the ircserver */
/* nick: the nick of the user sending the PRIVMSG */
/* hostname: the hostname of the user sending the PRIVMSG */
/* dest: the destination of the PRIVMSG (i.e. the nick or a channel) */
/* msg1: 1st part of full line (space seperated) */
/* msg2: 2nd part of full line (space seperated) */
/* msg3: 3rd part of full line (space seperated) */
/* msg4: 4th part of full line (space seperated) */
/* msg5: 5th part of full line (space seperated) */
/* msg1,2,3,4,5 are NULL if the full line doesn't have that part */

void plugin_ircprivmsg (const char *fullline, const char *nick, const char *hostname,
			const char *dest, const char *msg1, const char *msg2, const char *msg3,
			const char *msg4, const char *msg5) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   
   }

/* ------------------------------------------------------------------ */
/* ----------------- raw input from the irc server ------------------ */
/* fullline: the entire line recieved from the ircserver */
/* part2: 2nd part of full line (space seperated) */
/* part3: 3rd part of full line (space seperated) */
/* part4: 4th part of full line (space seperated) */
/* part2,3,4 are NULL if the full line doesn't have that part */

void plugin_ircinput (const char *fullline, const char *part2, const char *part3, const char *part4) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   
   }

/* ------------------------------------------------------------------ */

/* End of File */

