/*
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) admin.c 1.50@(#)
 * pmg@alliance.centerclick.org|src/admin.c|20011110165238|65154
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"

/* local functions */
static void u_respond(const userinput *u, const char*);

static void u_help(const userinput * const u);
static void u_xdl(const userinput * const u);
static void u_xds(const userinput * const u);
static void u_dcl(const userinput * const u);
static void u_dcld(const userinput * const u);
static void u_qul(const userinput * const u);
static void u_close(const userinput * const u);
static void u_nomin(const userinput * const u);
static void u_nomax(const userinput * const u);
static void u_rmq_rpq(const userinput * const u);
static void u_raw(const userinput * const u);
static void u_redraw(const userinput * const u);
static void u_info(const userinput * const u);
static void u_remove(const userinput * const u);
static void u_send(const userinput * const u);
static void u_psend(const userinput * const u);
static void u_mesg(const userinput * const u);
static void u_mesq(const userinput * const u);
static void u_closedcc(const userinput * const u);
static void u_status(const userinput * const u);
static void u_chfile(const userinput * const u);
static void u_chdesc(const userinput * const u);
static void u_chnote(const userinput * const u);
static void u_chmins(const userinput * const u);
static void u_chmaxs(const userinput * const u);
static void u_add(const userinput * const u);
static void u_adddir(const userinput * const u);
static void u_chatme(const userinput * const u);
static void u_rehash(const userinput * const u);
static void u_botinfo(const userinput * const u);
static void u_ignl(const userinput * const u);
static void u_ignore(const userinput * const u);
static void u_nosave(const userinput * const u);
static void u_nosend(const userinput * const u);
static void u_nolist(const userinput * const u);
static void u_renumber(const userinput * const u);
static void u_msgread(const userinput * const u);
static void u_msgdel(const userinput * const u);
static void u_memstat(const userinput * const u);
static void u_qsend(const userinput * const u);
static void u_shutdown(const userinput * const u);
static void u_debug(const userinput * const u);
static void u_jump(const userinput * const u);
static void u_servers(const userinput * const u);
static void u_trinfo(const userinput * const u);
static void u_listul(const userinput * const u);
static void u_clearrecords(const userinput * const u);
static void u_rmul(const userinput * const u);
static void u_crash(const userinput * const u);
static void u_chanl(const userinput * const u);

static void u_public(const userinput * const u);
static void u_humiliate(const userinput * const u);
static void u_spdwrn(const userinput * const u);
static void u_adsend(const userinput * const u);
static void u_fullignore(const userinput * const u);
static void u_adverts(const userinput * const u);
static void u_say(const userinput * const u);
static void u_badpack(const userinput * const u);
static void u_bdpklmt(const userinput * const u);

/* local info */
static const userinput_parse_t userinput_parse[] = {
{1,method_allow_all,u_help,     "HELP","<section>","Shows Help on <section>"},
{1,method_allow_all,u_xdl,      "XDL",NULL,"Lists Offered Files"},
{1,method_allow_all,u_xds,      "XDS",NULL,"Save XDCC File"},
{1,method_allow_all,u_dcl,      "DCL",NULL,"Lists Current Transfers"},
{1,method_allow_all,u_dcld,     "DCLD",NULL,"Lists Current Transfers with Details"},
{1,method_allow_all,u_trinfo,   "TRINFO","n","Lists Information About Transfer n"},
{1,method_allow_all,u_qul,      "QUL",NULL,"Lists Current Queue"},
{1,method_allow_all,u_ignl,     "IGNL",NULL,"Show Ignored List"},
{1,method_allow_all,u_listul,   "LISTUL",NULL,"Shows contents of upload directory"},
{1,method_allow_all,u_chanl,    "CHANL",NULL,"Shows channel list with member list"},

{2,method_allow_all,u_close,    "CLOSE","n","Cancels Transfer with ID = n"},
{2,method_allow_all,u_rmq_rpq,  "RMQ","n","Removes Main Queue Number n"},
{2,method_allow_all,u_rmq_rpq,  "RPQ","n","Removes Pack Queue Number n"},
{2,method_allow_all,u_nomin,    "NOMIN","n","Disables Minspeed For Transfer ID n"},
{2,method_allow_all,u_nomax,    "NOMAX","n","Disables Maxspeed For Transfer ID n"},
{2,method_allow_all,u_send,     "SEND","nick n","Sends Pack n to nick"},
{2,method_allow_all,u_adsend,    "ADSEND", "[channel] send an advert to all the to a specific channel all channels"},
{2,method_allow_all,u_psend,    "PSEND","<channel>","Sends XDCC LIST to <channel>"},
{2,method_allow_all,u_qsend,    "QSEND",NULL,"Sends Out The First Queued Pack"},
{2,method_allow_all,u_spdwrn,      "SPDWRN","<+|->","Turn on (+) or off (-) the notices sent to users when bandwidth limits are reached"},
{3,method_allow_all,u_info,     "INFO","n","Show Info for Pack n"},
{3,method_allow_all,u_remove,   "REMOVE","n","Removes Pack n"},
{3,method_allow_all,u_renumber, "RENUMBER","x y","Moves Pack x to y"},
{3,method_allow_all,u_add,      "ADD","<filename>","Add New Pack With <filename>"},
{3,method_allow_all,u_adddir,   "ADDDIR","<dir>","Add Every File in <dir>"},
{3,method_allow_all,u_chfile,   "CHFILE","n <msg>","Change File of pack n to <msg>"},
{3,method_allow_all,u_chdesc,   "CHDESC","n <msg>","Change Description of pack n to <msg>"},
{3,method_allow_all,u_chnote,   "CHNOTE","n <msg>","Change Note of pack n to <msg>"},
{3,method_allow_all,u_chmins,   "CHMINS","n x","Change min speed of pack n to x KB"},
{3,method_allow_all,u_chmaxs,   "CHMAXS","n x","Change max speed of pack n to x KB"},

{4,method_allow_all,u_mesg,     "MESG","<message>","Sends msg to all users who are transferring"},
{4,method_allow_all,u_mesq,     "MESQ","<message>","Sends msg to all users in a queue"},
{4,method_allow_all,u_ignore,   "IGNORE","n [<host>| *<hostmask>]","Ignore <host> (hostname) or any hostname ending in hostmask for n minutes"},
{4,method_allow_all,u_nosave,   "NOSAVE","n","Disables XDCC AutoSave for next n minutes"},
{4,method_allow_all,u_nosend,   "NOSEND","n","Disables XDCC Send for next n minutes"},
{4,method_allow_all,u_adverts,  "ADVERTS","<off|n>","Disables adverts for an optional time"},
{4,method_allow_all,u_nolist,   "NOLIST","[on|n] [-q|m]","Disables XDCC List and Plist for next n mins and optionally makes output quiet (-q) or bans any user requesting a list for m minutes"},
{4,method_allow_all,u_badpack,  "BADPACK","[on|n] [m]","Enables autobanning (for n minutes) for m minutes if they request an invalid pack"},
{4,method_allow_all,u_bdpklmt, "BDPKLMT","n m","Used with BADPACK. Autoban user if they request invalid packs n times in m minutes"},
{4,method_allow_all,u_fullignore,   "FULLIGNORE","n","Will automatically ignore any user who makes a send request when the queues are full. Their request is silently dropped"},
{4,method_allow_all,u_msgread,  "MSGREAD",NULL,"Show MSG log"},
{4,method_allow_all,u_msgdel,   "MSGDEL",NULL,"Delete MSG log"},
{4,method_allow_all,u_rmul,     "RMUL","<file>","Delete a file in the Upload Dir"},
{4,method_allow_all,u_raw,      "RAW","<command>","Send <command> to server (RAW IRC)"},
{4,method_allow_all,u_say,      "SAY","<#channel|nick> <text...>","Say text in a channel or to a person"},
{4,method_allow_all,u_humiliate,      "HUMILIATE","<list|badpack> [message]","Will announce this message (%u is replaced with nick and %t is replaced with the ban time) to all channels when user is autobanned by server"},
{5,method_allow_all,u_servers,  "SERVERS",NULL,"Shows the server list"},
{5,method_allow_all,u_jump,     "JUMP","<num>","Switches to a random server or server <num>"},
{5,method_allow_all,u_status,   "STATUS",NULL,"Show Useful Information"},
{5,method_allow_all,u_rehash,   "REHASH",NULL,"Re-reads config file(s) and reconfigures"},
{5,method_allow_all,u_botinfo,  "BOTINFO",NULL,"Show Information about the bot status"},
{5,method_allow_all,u_memstat,  "MEMSTAT",NULL,"Show Information about memory usage"},
{5,method_allow_all,u_clearrecords, "CLEARRECORDS",NULL,"Clears transfer, bandwidth, uptime, and total sent"},
{5,method_stdin,    u_redraw,   "REDRAW",NULL,"Redraws the Screen"},
{5,method_dcc,      u_closedcc, "QUIT",NULL,"Close DCC Chat"},
{5,method_msg,      u_chatme,   "CHATME",NULL,"Sends you a DCC Chat Request"},
{5,method_stdin,    u_debug,    "DEBUG","n","Set Debugging to n [0,1,2]"},
{5,method_allow_all,u_shutdown, "SHUTDOWN","<act>","Shutdown iroffer, <act> is \"now\", \"delayed\", or \"cancel\""},
{5,method_allow_all,u_public,      "PUBLIC","<+|->","Turn on (+) or off (-) the ability to resond to public triggers"},

{6,method_stdin,    u_crash, "CRASH",NULL,"Cause a segmentation fault"},
};



void u_fillwith_stdin (userinput * const u, char *line) {
   char* tempstr1 = mycalloc(maxtextlength,"u_fillwith_stdin");
   char* tempstr2 = mycalloc(maxtextlength,"u_fillwith_stdin");
   int i;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (line[strlen(line)-1] == '\n') line[strlen(line)-1] = '\0';
   
   u->method = method_stdin;
   u->snick = NULL;

   u->cmd = caps(getpart(line,1,"u_fillwith_stdin"));
   u->arg1 = getpart(line,2,"u_fillwith_stdin");
   u->arg2 = getpart(line,3,"u_fillwith_stdin");
   u->arg3 = getpart(line,4,"u_fillwith_stdin");
   
   strncpy(tempstr1,"",maxtextlength-1);
   if (u->arg1) {
      strncpy(tempstr1,line,maxtextlength-1);
      for (i=strlen(u->cmd)+1; i<=sstrlen(line); i++)
         tempstr1[i-strlen(u->cmd)-1] = tempstr1[i];
      }
   u->arg1e = tempstr1;
   
   strncpy(tempstr2,"",maxtextlength-1);
   if (u->arg1 && u->arg2) {
      strncpy(tempstr2,line,maxtextlength-1);
      for (i=sstrlen(u->cmd)+sstrlen(u->arg1)+2; i<=sstrlen(line); i++)
         tempstr2[i-strlen(u->cmd)-strlen(u->arg1)-2] = tempstr2[i];
      }
   u->arg2e = tempstr2;
   
   }

void u_fillwith_dcc (userinput * const u, char *line) {
   char* tempstr1 = mycalloc(maxtextlength,"u_fillwith_dcc");
   char* tempstr2 = mycalloc(maxtextlength,"u_fillwith_dcc");
   int i;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (line[strlen(line)-1] == '\n') line[strlen(line)-1] = '\0';
   
   u->method = method_dcc;
   u->snick = NULL;

   u->cmd = caps(getpart(line,1,"u_fillwith_dcc"));
   u->arg1 = getpart(line,2,"u_fillwith_dcc");
   u->arg2 = getpart(line,3,"u_fillwith_dcc");
   u->arg3 = getpart(line,4,"u_fillwith_dcc");
   
   strncpy(tempstr1,"",maxtextlength-1);
   if (u->arg1) {
      strncpy(tempstr1,line,maxtextlength-1);
      for (i=sstrlen(u->cmd)+1; i<=sstrlen(line); i++)
         tempstr1[i-strlen(u->cmd)-1] = tempstr1[i];
      }
   u->arg1e = tempstr1;
   
   strncpy(tempstr2,"",maxtextlength-1);
   if (u->arg1 && u->arg2) {
      strncpy(tempstr2,line,maxtextlength-1);
      for (i=sstrlen(u->cmd)+sstrlen(u->arg1)+2; i<=sstrlen(line); i++)
         tempstr2[i-strlen(u->cmd)-strlen(u->arg1)-2] = tempstr2[i];
      }
   u->arg2e = tempstr2;
   
   }

void u_fillwith_msg (userinput * const u, char* n, const char *line) {
   char* tempstr1 = mycalloc(maxtextlength,"u_fillwith_msg");
   char* tempstr2 = mycalloc(maxtextlength,"u_fillwith_msg");
   char *t1,*t2,*t3,*t4,*t5;
   int i,len;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   u->method = method_msg;
   u->snick = n;
   t1 = getpart(line,1,"u_fillwith_msg"); t2 = getpart(line,2,"u_fillwith_msg");
   t3 = getpart(line,3,"u_fillwith_msg"); t4 = getpart(line,4,"u_fillwith_msg");
   t5 = getpart(line,5,"u_fillwith_msg");
   
   u->cmd = caps(getpart(line,6,"u_fillwith_msg"));
   u->arg1 = getpart(line,7,"u_fillwith_msg");
   u->arg2 = getpart(line,8,"u_fillwith_msg");
   u->arg3 = getpart(line,9,"u_fillwith_msg");
   
   len = strlen(t1) + strlen(t2) + strlen(t3) + strlen(t4) + strlen(t5) +5;
   if (u->cmd) len += strlen(u->cmd);
   
   strncpy(tempstr1,"",maxtextlength-1);
   if (u->arg1) {
      strncpy(tempstr1,line,maxtextlength-1);
      for (i=len+1; i<=sstrlen(line); i++)
         tempstr1[i-len-1] = tempstr1[i];
      }
   u->arg1e = tempstr1;
   
   strncpy(tempstr2,"",maxtextlength-1);
   if (u->arg1 && u->arg2) {
      len += strlen(u->arg1);
      strncpy(tempstr2,line,maxtextlength-1);
      for (i=len+2; i<=sstrlen(line); i++)
         tempstr2[i-len-2] = tempstr2[i];
      }
   u->arg2e = tempstr2;
   
   mydelete(t1);
   mydelete(t2);
   mydelete(t3);
   mydelete(t4);
   mydelete(t5);
   }

void u_fillwith_clean (userinput * const u) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   mydelete(u->cmd);
   mydelete(u->arg1e);
   mydelete(u->arg2e);
   mydelete(u->arg1);
   mydelete(u->arg2);
   mydelete(u->arg3);
   }

static void u_respond(const userinput * const u, const char *a) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   switch (u->method) {
   case method_stdin:
      ioutput(0,OUT_S,NULL,"%s",a);
      break;
   case method_dcc:
      ioutput(0,OUT_D,NULL,"%s",a);
      break;
   case method_msg:
      privmsg(u->snick,"%s",a);
      break;
   case method_xdl_channel:
      privmsg(u->snick,"%s",a);
      break;
   case method_xdl_user:
      notice(u->snick,"%s",a);
      break;
   case method_out_all:
      ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"%s",a);
      break;
   case method_xdl_channel_min:
      privmsg(u->snick,"%s",a);
      break;
   case method_xdl_channel_sum:
   case method_xdl_channel_cust:
      privmsg(u->snick,"%s",a);
      break;
   case method_allow_all:
   default:
      break;
   }
   
   }

void u_parseit(userinput * const u) {
   int i,found = 0;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!u->cmd || !strlen(u->cmd)) {
      u_respond(u,"*** Missing Command, try again");
      u_fillwith_clean(u);
      return;
      }
   
   for (i=0; !found && i<(sizeof(userinput_parse)/sizeof(userinput_parse_t)); i++)
      if ( (!strcmp(userinput_parse[i].command,u->cmd)) &&
           (userinput_parse[i].methods_allowed & u->method) ) {
         found=1;
         userinput_parse[i].handler(u);
         }
   
   if (!found)
      u_respond(u,"*** User Command Not Recognized, try \"HELP\"");
   else
     switch (u->method)
       {
       case method_stdin:
      ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","ADMIN %s Requested (stdin)",u->cmd);
	 break;
       case method_dcc:
      ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","ADMIN %s Requested (DCC Chat)",u->cmd);
	 break;
       case method_msg:
      ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","ADMIN %s Requested (MSG: %s)",u->cmd,u->snick);
       case method_xdl_channel:
       case method_xdl_user:
       case method_out_all:
       case method_xdl_channel_min:
       case method_xdl_channel_sum:
       case method_xdl_channel_cust:
       case method_allow_all:
	 break;
       }
   u_fillwith_clean(u);
   
   }

static void u_help(const userinput * const u) {
   int i,which=0;
   char *tempstr, *tempstr2;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1 && strlen(u->arg1)) {
      if (!strcmp(caps(u->arg1),"INFO"))    which=1;
      else if (!strcmp(u->arg1,"TRANSFER")) which=2;
      else if (!strcmp(u->arg1,"PACK"))     which=3;
      else if (!strcmp(u->arg1,"MISC"))     which=4;
      else if (!strcmp(u->arg1,"BOT"))      which=5;
      }
   
   if (!which) {
      u_respond(u,"Usage: \"HELP <section>\"");
      u_respond(u,"Help Sections Available:");
      u_respond(u,"  Info     - help, xdl, xds, dcl, dcld, trinfo, qul, ignl, listul, chanl");
      u_respond(u,"  Transfer - close, rmq, rpq, nomin, nomax, send, adsend, psend, qsend, spdwrn");
      u_respond(u,"  Pack     - info, remove, renumber, add, adddir, chfile, chdesc, chnote, chmins, chmaxs");
      u_respond(u,"  Misc     - mesg, mesq, ignore, nosave, nosend, adverts, nolist, badpack, bdpklmt, fullignore msgread, msgdel, rmul, raw, say, public, humiliate");
      u_respond(u,"  Bot      - servers, jump, status, rehash, botinfo, memstat, clearrecords, redraw, quit, chatme, debug, shutdown, public");
      u_respond(u,"For additional help, see the complete documentation at http://iroffer.org/");
      return;
      }
   
   tempstr  = mycalloc(maxtextlength,"u_help");
   tempstr2 = mycalloc(maxtextlengthshort,"u_help");
   
   isnprintf(tempstr,maxtextlength-2,"-- %s Commands (%s) --",
            which==1?"Info":
            which==2?"Transfer":
            which==3?"Pack":
            which==4?"Misc":
            which==5?"Bot":"<Unknown>",
            u->method==method_stdin?"stdin":
            u->method==method_dcc?"dcc":
            u->method==method_msg?"msg":"<Unknown>"
            );
   u_respond(u,tempstr);
   
   for (i=0; i<(sizeof(userinput_parse)/sizeof(userinput_parse_t)); i++)
      if (userinput_parse[i].methods_allowed & u->method &&
          userinput_parse[i].help_section == which) {
         if (userinput_parse[i].args)
            isnprintf(tempstr2,maxtextlengthshort-2,"%s %s",
              userinput_parse[i].command,userinput_parse[i].args);
          else
            isnprintf(tempstr2,maxtextlengthshort-2,"%s",
              userinput_parse[i].command);
         isnprintf(tempstr,maxtextlength-2,"  %-16s - %s",
           tempstr2,userinput_parse[i].desc);
         u_respond(u,tempstr);
         }
   
   u_respond(u,"For additional help, see the complete documentation at http://iroffer.org/");
   
   mydelete(tempstr);
   mydelete(tempstr2);
   }

static void u_xdl(const userinput * const u) {
   char *tempstr,*tempstr2,*tempstr3, *cptr, *nptr;
   const char *spaces[] = { ""," ","  ","   ","    ","     ","      " };
   int a,i,p,m,m1,s,spaceleft,x;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if ((u->method == method_xdl_channel || u->method == method_xdl_channel_min || u->method == method_xdl_channel_sum) && (gdata.nolisting > gdata.curtime)) return;
   
   tempstr = mycalloc(maxtextlength,"u_xdl");

   if ((u->method == method_xdl_user) && (gdata.nolisting > gdata.curtime)) {
      isnprintf(tempstr,maxtextlength-2,
            "The Owner Has Requested That No Lists Be Sent In The Next %li Minute%s",
            1+(gdata.nolisting-gdata.curtime)/60,((1+(gdata.nolisting-gdata.curtime)/60)!=1?"s":""));
      u_respond(u,tempstr);
      mydelete(tempstr);
      return;
      }

   tempstr2 = mycalloc(maxtextlength,"u_xdl");
   tempstr3 = mycalloc(maxtextlengthshort,"u_xdl");

   if (u->method==method_xdl_channel_cust)
	{
       /* We are in a loop to display the formated stuff from the advert definition string */
       for (a=0;a<MAXADVERTS && gdata.advert[a]!=NULL;a++)
	 {
	   memset(tempstr,0,maxtextlength);
	   i=0;
	   cptr=gdata.advert[a];
	   nptr=tempstr;
	   /* All strings will be null terminated.
	      We must ensure we do no outstretch ourselves and write more than maxtextlength
	      to the tempstring
	   */
	   spaceleft=maxtextlength-2;
	   while (spaceleft>0)
	     switch (*cptr)
	       {
	       case 0:
		 spaceleft=0;
         break;
	       case '%':
		 cptr++;tempstr2[0]=0;
		 switch(capchar(*(cptr++)))
     {
		   case 'A': /* Number of slots in use */
		     isnprintf(tempstr2, maxtextlength-1, "%i", gdata.slotsfull);
		     break;
		   case 'B': /* Totle slots */
		     isnprintf(tempstr2, maxtextlength-1, "%i", gdata.slotsmax);
         break;
		   case 'C': /* Number in queue */
		     isnprintf(tempstr2, maxtextlength-1, "%i", gdata.inqueue);		     
		     break;
		   case 'D': /* Size of queue */
		     isnprintf(tempstr2, maxtextlength-1, "%i", gdata.queuesize);
		     break;
		   case 'E': /* number in packs queue */
		     isnprintf(tempstr2, maxtextlength-1, "%i", gdata.inslotsmaxqueue);
		     b    strncpy(tempstr1,line,maxtextlength-1);
      for (i=strlen(u->cmd)+1; i<=sstrlen(line); i++)
         tempstr1[i-strlen(u->cmd)-1] = tempstr1[i];
      }
   u->arg1e = tempstr1;
   
   strncpy(tempstr2,"",maxtextlength-1);
   if (u->arg1 && u->arg2) {
      strncpy(tempstr2,line,maxtextlength-1);
      for (i=sstrlen(u->cmd)+sstrlen(u->arg1)+2; i<=sstrlen(line); i++)
         tempstr2[i-strlen(u->cmd)-strlen(u->arg1)-2] = tempstr2[i];
   }
   u->arg2e = tempstr2;

      }
   
void u_fillwith_dcc (useri                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               