/*      
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) misc.c 1.53@(#)
 * pmg@alliance.centerclick.org|src/misc.c|20011110162745|63902
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"


void getconfig (void) {
   char *templine = mycalloc(maxtextlength,"getconfig_templine");
   char *tempc = mycalloc(2,"getconfig_tempc");
   int h,i,filedescriptor=-1;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   for (h=0; h<MAXCONFIG && gdata.configfile[h]; h++) {
      printf("*** Loading %s ... \n",gdata.configfile[h]);
   
      filedescriptor=open(gdata.configfile[h], O_RDONLY | ADDED_OPEN_FLAGS);
      if (filedescriptor < 0)
         outerror(0,"Couldn't Open Config File");
      
      gdata.highmeminfo=1;
      
      i = 0;
      while(read(filedescriptor,tempc,1) == 1) {
         if (tempc[0] == '\n' || tempc[0] == 13) {  /* 13 is ^M */
            templine[i] = '\0';
            if ( templine[0] != '#' && strlen(templine) != 0 ) {
               for (i=strlen(templine)-1; i>2 && templine[i] == ' '; i--)
                  templine[i] = '\0';
               getconfig_set (templine,0);
               }
            i = 0;
            }
         else {
            templine[i] = tempc[0];
            i++;
            }
          }
       }
   close(filedescriptor);   
   printf("*** Checking for completeness of config file ...\n");
   
   if ( gdata.server[0] == NULL
        || gdata.user_nick == NULL || gdata.user_realname == NULL
        || gdata.channels[0] == NULL || gdata.slotsmax == 0 
        || gdata.xdccautosavetime == 0 || gdata.xdccfile == 0)
      outerror(0,"Config File Missing Necessary Information");

   if ( gdata.autosend && ( gdata.autoword == NULL || gdata.automsg == NULL || !gdata.autopack ) )
      outerror(0,"Config File Missing Autosend Information");

   if ( gdata.uploadallowed && ( gdata.uploaddir == NULL || strlen(gdata.uploaddir) < 2 ) )
      outerror(0,"Config File Missing Upload Information");
      
   if (gdata.background) gdata.debug = 0;
   
   if ( USESCREEN  && !gdata.background) {
      printf("\x1b[%i;12H%s) >",gdata.termlines,gdata.user_nick);
      printf("\x1b[%i;%iH",gdata.termlines, (int)(gdata.user_nick ? 16+strlen(gdata.user_nick) : 16));
      gototop();
      }
   
   gdata.caps_nick = mycalloc(maxtextlengthshort,"getconfig_caps_nick");
   strncpy(gdata.caps_nick,gdata.user_nick,maxtextlengthshort-1);
   caps(gdata.caps_nick);
   
   gdata.highmeminfo = 0;
   
   mydelete(tempc);
   mydelete(templine);
   }

void getconfig_set (const char *line, int rehash) {
   char *type = mycalloc(maxtextlength,"getconfig_set_type");
   char *var2 = mycalloc(maxtextlength,"getconfig_set_var2");
   char *var;
   char *a,*b;
   struct hostent *thost;
   struct sockaddr_in tsocka;
   int i,j;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   for (i=0; i<maxtextlength; i++) {
      if (line[i] == ' ' || line[i] == '\0')
         break;
      type[i] = line[i];
      }
   type[i] = '\0';
   if (line[i]==0)
     i--;
   for (j=i+1; j<maxtextlength; j++) {
      if (line[j] == '\0')
         break;
      var2[j-i-1] = line[j];
      }
   var2[j-i-1] = '\0';
   
   var = mycalloc(strlen(var2)+2,"getconfig_set_var");
   strncpy(var,var2,strlen(var2)+1);
   
   /* parse it */
   if (!strcmp(type,"debug")) {
      if (!strcmp(var,"yes")) {
         gdata.debug = 1;
         gdata.debug2 = 1;
         }
      else {
         gdata.debug = 0;
         gdata.debug2 = 0;
         }
      mydelete(var);
      }
   else if (!strcmp(type,"virthost") && !rehash) {
      if (!strcmp(var,"yes")) gdata.virthost = 1;
      else gdata.virthost = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"virthost") && rehash) {
      if (!strcmp(var,"yes")) gdata.r_virthost = 1;
      else gdata.r_virthost = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"autosend")) {
      if (!strcmp(var,"yes")) gdata.autosend = 1;
      else gdata.autosend = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"logstats")) {
      if (!strcmp(var,"yes")) gdata.logstats = 1;
      else gdata.logstats = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"slowlink")) {
      /* no longer used */
      mydelete(var);
      }
   else if (!strcmp(type,"firewall")) {
      if (!strcmp(var,"yes")) gdata.firewall = 1;
      else gdata.firewall = 0;
      mydelete(var);
      }
   else if ( ! strcmp(type,"dccrangestart")) {
      gdata.dccrangestart = atoi(var);
      mydelete(var);
      }
   else if ( ! strcmp(type,"server")) {
      for (i=0;i<MAXSRVS && gdata.server[i]; i++) ;
      if (i==MAXSRVS)
	{
	  ioutput(0,OUT_S|OUT_L|OUT_D,NULL," !!! Too many servers, ignoring %s in config file !!!",var);
	}
      else
      gdata.server[i] = var;
      }
   else if ( ! strcmp(type,"advert")) {
     for (i=0; i<MAXADVERTS && gdata.advert[i]!=NULL;i++);
     if ((i!=MAXADVERTS) && (gdata.advert[i]==NULL))
       gdata.advert[i]=var;
   }
   else if ( ! strcmp(type,"nolist")) {
     char* cptr;
     gdata.nolisting=(-3ul)>>1;
     if ((cptr=getpart(var,1,"getconfig_set_nolist")))
	 gdata.nolistbantime=(!strcasecmp(cptr,"-q"))?0:atoi(cptr);
     else
       gdata.nolistbantime=-1;
     mydelete (cptr);
   }
   else if ( ! strcmp(type,"noadverts")) {
     gdata.noadverts=(-3ul)>>1;
   }
   else if ( ! strcmp(type,"public")) {
     gdata.publictriggers=1;
   }
   else if ( ! strcmp(type,"speedwarnings")) {
     gdata.nospeedwarnings=0;
   }
   else if ( ! strcmp(type,"nospeedwarnings")) {
     gdata.nospeedwarnings=10;
   }
   else if ( ! strcmp(type,"nopublic")) {
     gdata.publictriggers=0;
   }
   else if ( ! strcmp(type, "badpack")) {
     /* badpack <attempts> <in mins>  <banfor> */
     char *tptr;
     int i,num[4];

     for(i=1;i<4;i++)
       {
	 if ((tptr=getpart(var,i,"badpackstring")))
	   {
	     if ((num[i]=atoi(tptr))<1)
	       {
		 
		 ioutput(0,OUT_S|OUT_L|OUT_D,NULL," !!! Invalid badpack paramter %i in config file: %s",i,var);
		 mydelete (tptr);
		 i=9;
	       }
	   }
	 else
	   {
	     ioutput(0,OUT_S|OUT_L|OUT_D,NULL," !!! Missing badpack paramter in config file: %s",var);
	     mydelete (tptr);
	     i=9;
	   }
       }
     if (i!=9)
       {
	 gdata.badpack.badpacktime=(-3ul)>>1;
	 gdata.badpack.maxattempts=num[1];
	 gdata.badpack.interval=num[2];
	 gdata.badpack.bantime=num[3];
	 badpackrotate(1);
       }
   }
   else if ( ! strcmp(type,"humiliate")) {
     char** ccptr=NULL;
     char* cptr=NULL;
     int i;
     for (i=0;var[i]!=0;i++)
       if (var[i]==' ')
	 {
	   cptr=&(var[i+1]);
	   var[i]=0;
	   break;
	 }
     
     if ( ! strcasecmp(var,"nolist") )
       ccptr=&gdata.humiliate;
     else if ( ! strcasecmp (var , "badpack") )
       ccptr=&gdata.badpack.humiliate;
     else
       {
	 ioutput(0,OUT_S|OUT_L|OUT_D,NULL," !!! Bad syntax for humiliate %s in config file !!!",var);
       }
     if (ccptr)
       {
	 if (*ccptr)
	   {
	     mydelete (*ccptr);
	     *ccptr=NULL;
	   }
	 strncpy(*ccptr=mycalloc(maxtextlength,"u_humiliate"),
		 cptr, maxtextlength-2);
       }
   }
   else if ( ! strcmp(type,"fullignore")) {
     char* cptr;
     if ((cptr=getpart(var,1,"getconfig_set_fullignoretime")))
       gdata.fullignoretime=atoi(cptr);
     else
       gdata.fullignoretime=0;
     mydelete (cptr);
   } 
   else if ( ! strcmp(type,"prejoin")) {
     for (i=0; i<MAXPREJOIN && gdata.prejoin[i]!=NULL;i++);
     if ((i<MAXPREJOIN) && (gdata.prejoin[i]==NULL))
       gdata.prejoin[i]=var;
   }   
   else if ( ! strcmp(type,"channel")) {
      char *tptr = NULL, *tptr2 = NULL, *tname;
      int ok=1;
      channel_t *cptr = NULL;
      
      if (!rehash) {
         for (i=0; gdata.channels[i] && i<MAXCHNLS; i++) ;
         cptr = gdata.channels[i] = mycalloc(sizeof(channel_t),"getconfig_set_gdata.channels[i]");
         }
      else {
         for (i=0; gdata.r_channel[i] && i<MAXCHNLS; i++) ;
         cptr = gdata.r_channel[i] = mycalloc(sizeof(channel_t),"getconfig_set_gdata.channels[i]");
         }
      
      tname = getpart(var,1,"getconfig_set_channel");
      strncpy(cptr->name,caps(tname),maxtextlength-1);
      
      for (i=2; i<20 && ok && (tptr = getpart(var,i,"getconfig_set_channel")); i++) {
         if (!strcmp(tptr,"-plist")) {
            i++;
            if ((tptr2 = getpart(var,i,"getconfig_set_channel_sub1")))
               cptr->plisttime = atoi(tptr2);
            else ok=0;
            }
         else if (!strcmp(tptr,"-pformat")) {
            i++;
            if ((tptr2 = getpart(var,i,"getconfig_set_channel_sub2"))) {
               if (!strcmp(tptr2,"full"))
                  ;
               else if (!strcmp(tptr2,"minimal"))
                  cptr->flags |= CHAN_MINIMAL;
               else if (!strcmp(tptr2,"summary"))
                  cptr->flags |= CHAN_SUMMARY;
               else ok=0;
               }
            else ok=0;
            }
         else if (!strcmp(tptr,"-key")) {
            i++;
            if ((tptr2 = getpart(var,i,"getconfig_set_channel_sub2")))
               strncpy(cptr->key,tptr2,maxtextlengthshort-1);
            else ok=0;
            }
	 else if ((!strcmp(tptr,"-advert")) && (cptr->flags | CHAN_CUSTOM))
	   {
	     i++;
	     cptr->flags |= CHAN_CUSTOM;
	   }
         else ok=0;
         
         mydelete(tptr);
         mydelete(tptr2);
         }
      
      if (!ok) ioutput(0,OUT_S|OUT_L|OUT_D,NULL," !!! Bad syntax for channel %s in config file !!!",tname);
      
      mydelete(tptr);
      mydelete(tptr2);
      mydelete(tname);
      mydelete(var);
      }
   else if ( ! strcmp(type,"adminhost")) {
      for (i=0; gdata.adminhost[i] && i<MAXAHOST; i++) ;
      hostmasktoregex(caps(var2));
      gdata.adminhost[i] = mycalloc(sizeof(regex_t),"getconfig_set_adminhost[i]");
      if (regcomp(gdata.adminhost[i],var2,REG_ICASE|REG_NOSUB))
         gdata.adminhost[i] = NULL;
      mydelete(var);
      }
   else if ( ! strcmp(type,"user_nick") && !rehash) {
      mydelete(gdata.user_nick);
      gdata.user_nick = var;
      }
   else if ( ! strcmp(type,"user_nick") && rehash) {
      mydelete(gdata.r_user_nick);
      gdata.r_user_nick = var;
      }
   else if ( ! strcmp(type,"user_realname")) {
      mydelete(gdata.user_realname);
      gdata.user_realname = var;
      }
   else if ( ! strcmp(type,"user_modes")) {
      mydelete(gdata.user_modes);
      gdata.user_modes = var;
      }
   else if ( ! strcmp(type,"slotsmax")) {
      gdata.slotsmax = between(1,atoi(var),MAXTRANS);
      mydelete(var);
      }
   else if ( ! strcmp(type,"slotsmaxpack")) {
      gdata.slotsmaxpack = between(0,atoi(var),MAXXDCCS);
      mydelete(var);
      }
   else if ( ! strcmp(type,"slotsmaxslots")) {
      gdata.slotsmaxslots = between(1,atoi(var),MAXTRANS);
      mydelete(var);
      }
   else if ( ! strcmp(type,"vhost_ip") && !rehash) {
      mydelete(gdata.vhost_ip);
      gdata.vhost_ip = var;
      }
   else if ( ! strcmp(type,"vhost_ip") && rehash) {
      mydelete(gdata.r_vhost_ip);
      gdata.r_vhost_ip = var;
      }
   else if ( ! strcmp(type,"autoword")){
      mydelete(gdata.autoword);
      gdata.autoword = var;
      }
   else if ( ! strcmp(type,"automsg")){
      mydelete(gdata.automsg);
      gdata.automsg = var;
      }
   else if ( ! strcmp(type,"autopack")) {
      gdata.autopack = between(1,atoi(var),MAXXDCCS);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallminspeed")) {
      gdata.overallminspeed = atof(var);
      mydelete(var);
      }
   else if ( ! strcmp(type,"transfermaxspeed")) {
      gdata.transfermaxspeed = max2(0,atof(var));
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeed")) {
      gdata.overallmaxspeed = max2(0,atoi(var)*4);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeeddayspeed")) {
      gdata.overallmaxspeeddayspeed = max2(0,atoi(var)*4);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeeddaytime")) {
      a = getpart(var,1,"getconfig_set"); b = getpart(var,2,"getconfig_set");
      if (a && b) {
         gdata.overallmaxspeeddaytimestart = between(0,atoi(a),23);
         gdata.overallmaxspeeddaytimeend   = between(0,atoi(b),23);
         }
      mydelete(a); mydelete(b);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeeddaydays")) {
      gdata.overallmaxspeeddaydays = 0;
      for (i=0; (i<sstrlen(var) && i<8); i++)
         gdata.overallmaxspeeddaydays |= dayofweektomask(var[i]);
      mydelete(var);
      }
   else if ( ! strcmp(type,"logrotate")) {
      gdata.logrotate = 0;
      if (!strcmp(var,"daily")) gdata.logrotate = 1;
      if (!strcmp(var,"weekly")) gdata.logrotate = 2;
      if (!strcmp(var,"monthly")) gdata.logrotate = 3;
      mydelete(var);
      }
   else if ( ! strcmp(type,"xdccautosavetime")) {
      gdata.xdccautosavetime = max2(5,atoi(var));
      mydelete(var);
      }
   else if ( ! strcmp(type,"slotsmaxqueue")) {
      gdata.slotsmaxqueue = between(0,atoi(var),MAXQUEUE);
      mydelete(var);
      }
   else if ( ! strcmp(type,"queuesize")) {
      gdata.queuesize = between(0,atoi(var),MAXQUEUE);
      mydelete(var);
      }
   else if ( ! strcmp(type,"adminpass")) {
      mydelete(gdata.adminpass);
      gdata.adminpass = var;
      checkadminpass();
      }
   else if ( ! strcmp(type,"pidfile") && !rehash) {
      mydelete(gdata.pidfile);
      gdata.pidfile = var;
      }
   else if ( ! strcmp(type,"pidfile") && rehash) {
      mydelete(gdata.r_pidfile);
      gdata.r_pidfile = var;
      }
   else if ( ! strcmp(type,"lowbdwth")) {
      gdata.lowbdwth = max2(0,atoi(var));
      mydelete(var);
      }
   else if ( ! strcmp(type,"filedir")) {
      mydelete(gdata.filedir);
      gdata.filedir = var;
      }
   else if ( ! strcmp(type,"messagefile")) {
      mydelete(gdata.messagefile);
      gdata.messagefile = var;
      i = open(gdata.messagefile, O_WRONLY | O_CREAT | ADDED_OPEN_FLAGS, S_IRUSR | S_IWUSR );
      if (i > 2) close(i);
      }
   else if ( ! strcmp(type,"ignorefile")) {
      mydelete(gdata.ignorefile);
      gdata.ignorefile = var;
      i = open(gdata.ignorefile, O_RDWR | O_CREAT | ADDED_OPEN_FLAGS, S_IRUSR | S_IWUSR );
      if (i > 2) close(i);
      }
   else if ( ! strcmp(type,"logfile")) {
      mydelete(gdata.logfile);
      gdata.logfile = var;
      }
   else if ( ! strcmp(type,"xdccfile") && !rehash) {
      mydelete(gdata.xdccfile);
      gdata.xdccfile = var;
      }
   else if ( ! strcmp(type,"xdccfile") && rehash) {
      mydelete(gdata.r_xdccfile);
      gdata.r_xdccfile = var;
      }
   else if ( ! strcmp(type,"creditline")) {
      mydelete(gdata.creditline);
      gdata.creditline = var;
      }
   else if ( ! strcmp(type,"loginname")) {
      mydelete(gdata.loginname);
      gdata.loginname = var;
      }
   else if ( ! strcmp(type,"proxyinfo")) {
      mydelete(gdata.proxyinfo);
      gdata.proxyinfo = var;
      }
   else if ( ! strcmp(type,"proxyinfo2")) {
      mydelete(gdata.proxyinfo2);
      gdata.proxyinfo2 = var;
      }
   else if ( ! strcmp(type,"periodicmsg")) {
      char *tnum;
      int offset;
      mydelete(gdata.periodicmsg_nick);
      mydelete(gdata.periodicmsg_msg);
      
      gdata.periodicmsg_nick = getpart(var,1,"getconfig_set_periodicmsg");
      tnum = getpart(var,2,"getconfig_set_periodicmsg");
      gdata.periodicmsg_msg = getpart(var,3,"getconfig_set_periodicmsg");
      
      if (!gdata.periodicmsg_nick || !tnum || !gdata.periodicmsg_msg) {
         outerror(1,"Syntax Error In periodicmsg, Ignoring");
         mydelete(gdata.periodicmsg_nick);
         mydelete(gdata.periodicmsg_msg);
         mydelete(var);
         }
      else {
         gdata.periodicmsg_time = max2(1,atoi(tnum));
         
         offset = strlen(gdata.periodicmsg_nick) + strlen(tnum) + 2;
         for (i=offset; i<=strlen(var); i++)
            var[i-offset] = var[i];
         
         mydelete(gdata.periodicmsg_msg);
         gdata.periodicmsg_msg = var;
         
         }
      
      mydelete(tnum);
      }
   else if ( ! strcmp(type,"maxqueueditemsperperson")) {
     gdata.maxqueueditemsperperson = max2(1,atoi(var));
     mydelete(var);
   }
   else if ( ! strcmp(type,"maxtransfersperperson")) {
     gdata.maxtransfersperperson = max2(1,atoi(var));
     mydelete(var);
   }
   else if ( ! strcmp(type,"usenatip")) {
      gdata.usenatip = 1;
      if (( thost = gethostbyname(var)) == NULL) {
         outerror(1,"Can't Resolve NAT Host, Ignoring");
         gdata.usenatip = 0;
         }
      else {
         memcpy(&tsocka.sin_addr, *((struct in_addr **)thost->h_addr_list), sizeof(struct in_addr));
         gdata.ourip = ntohl(tsocka.sin_addr.s_addr);
         if (gdata.debug) printf("ip=0x%8.8lX\n",gdata.ourip);
         }
      mydelete(var);
      }
   else if (!strcmp(type,"uploadallowed")) {
      if (!strcmp(var,"yes")) gdata.uploadallowed = 1;
      else gdata.uploadallowed = 0;
      mydelete(var);
      }
   else if ( ! strcmp(type,"uploaddir")) {
      mydelete(gdata.uploaddir);
      gdata.uploaddir = var;
      }
   else if ( ! strcmp(type,"uploadmaxsize")) {
      gdata.uploadmaxsize = max2(0,atoi(var)*1024*1024);
      mydelete(var);
      }
   else if ( ! strcmp(type,"connectionmethod")) {
      char *thow = getpart(var,1,"getconfig_set_connectionmethod");
      char *targ1 = getpart(var,2,"getconfig_set_connectionmethod");
      char *targ2 = getpart(var,3,"getconfig_set_connectionmethod");
      char *targ3 = getpart(var,4,"getconfig_set_connectionmethod");
      char *targ4 = getpart(var,5,"getconfig_set_connectionmethod");
      
      bzero((char *) &gdata.connectionmethod,sizeof(connectionmethod_t));
      
      if (thow && !strcmp(thow,"direct")) {
         gdata.connectionmethod.how = how_direct;
         }
      else if (thow && targ1 && targ2 && targ3 && !strcmp(thow,"bnc")) {
         gdata.connectionmethod.how = how_bnc;
         strncpy(gdata.connectionmethod.host,targ1,maxtextlengthshort);
         gdata.connectionmethod.port = atoi(targ2);
         strncpy(gdata.connectionmethod.password,targ3,maxtextlengthshort);
         if (targ4)
            strncpy(gdata.connectionmethod.vhost,targ4,maxtextlength);
         }
      else if (thow && targ1 && targ2 && !strcmp(thow,"wingate")) {
         gdata.connectionmethod.how = how_wingate;
         strncpy(gdata.connectionmethod.host,targ1,maxtextlengthshort);
         gdata.connectionmethod.port = atoi(targ2);
         }
      else if (thow && targ1 && targ2 && !strcmp(thow,"custom")) {
         gdata.connectionmethod.how = how_custom;
         strncpy(gdata.connectionmethod.host,targ1,maxtextlengthshort);
         gdata.connectionmethod.port = atoi(targ2);
         }
      else {
         gdata.connectionmethod.how = how_direct;
         outerror(1,"Invalid connectionmethod in config file, defaulting to direct");
         }
      
      mydelete(thow);
      mydelete(targ1);
      mydelete(targ2);
      mydelete(targ3);
      mydelete(targ4);
      mydelete(var);
      }
   else if (!strcmp(type,"restrictlist")) {
      if (!strcmp(var,"yes")) gdata.restrictlist = 1;
      else gdata.restrictlist = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"restrictsend")) {
      if (!strcmp(var,"yes")) gdata.restrictsend = 1;
      else gdata.restrictsend = 0;
      mydelete(var);
      }
   else {
      outerror(1,"Ignored invalid line in config file: %s",type);
      mydelete(var);
      }

   mydelete(type);
   mydelete(var2);
   }

int connectirc (const char *tserver) {
   struct sockaddr_in ircserverip;
   struct sockaddr_in localaddr;
   struct hostent *remotehost, *localhost;
   int i, retval;
   char tempstr[maxtextlength], *to_ip, *to_port;
   
   SIGNEDSOCK int addrlen;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   for (i=0; i<30; i++)
      gdata.serversent[i]=0;
   
   if (!tserver) return 1;
   
   gdata.nocon++;
   
   mydelete(gdata.curserverip);
   mydelete(gdata.curserverport);
   gdata.curserverip = getpart(tserver,1,"connectirc_curserverip");
   gdata.curserverport = getpart(tserver,2,"connectirc_curserverport");
   to_ip = getpart(tserver,1,"connectirc_to_ip");
   to_port = getpart(tserver,2,"connectirc_to_port");
   
   if (!gdata.curserverport) {
      gdata.curserverport = mycalloc(7,"connectirc_curserverport");
      strncpy(gdata.curserverport,"6667",6);
      to_port = mycalloc(7,"connectirc_to_port");
      strncpy(to_port,"6667",6);
      }
   
   switch (gdata.connectionmethod.how) {
    case how_direct:
       isnprintf(tempstr,maxtextlength-1," (direct)");
       break;
    case how_bnc:
       if (gdata.connectionmethod.vhost[0])
          isnprintf(tempstr,maxtextlength-1," (bnc at %s:%i with %s)",gdata.connectionmethod.host,gdata.connectionmethod.port,gdata.connectionmethod.vhost);
       else
          isnprintf(tempstr,maxtextlength-1," (bnc at %s:%i)",gdata.connectionmethod.host,gdata.connectionmethod.port);
       strncpy(to_ip,gdata.connectionmethod.host,maxtextlength-1);
       isnprintf(to_port,maxtextlength-1,"%i",gdata.connectionmethod.port);
       break;
    case how_wingate:
       isnprintf(tempstr,maxtextlength-1," (wingate at %s:%i)",gdata.connectionmethod.host,gdata.connectionmethod.port);
       strncpy(to_ip,gdata.connectionmethod.host,maxtextlength-1);
       isnprintf(to_port,maxtextlength-1,"%i",gdata.connectionmethod.port);
       break;
    case how_custom:
       isnprintf(tempstr,maxtextlength-1," (custom at %s:%i)",gdata.connectionmethod.host,gdata.connectionmethod.port);
       strncpy(to_ip,gdata.connectionmethod.host,maxtextlength-1);
       isnprintf(to_port,maxtextlength-1,"%i",gdata.connectionmethod.port);
       break;
    default:
       mydelete(to_ip);
       mydelete(to_port);
       return 1; /* error */
    }
      
   if (gdata.virthost && gdata.vhost_ip)
      ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Attempting Connection to %s from %s%s",tserver,gdata.vhost_ip,tempstr);
   else
      ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Attempting Connection to %s%s",tserver,tempstr);
   
   if (gdata.attop) gotobot();
   
   bzero ((char *) &ircserverip, sizeof (ircserverip));
   
   gdata.ircserver = socket( AF_INET, SOCK_STREAM, 0);
   if (gdata.ircserver < 0) {
      outerror(1,"Socket Error");
      mydelete(to_ip);
      mydelete(to_port);
      return 1;
      }
   
   ircserverip.sin_family = AF_INET;
   ircserverip.sin_port = htons(atoi(to_port));
   
   if (( remotehost = gethostbyname(to_ip)) == NULL) {
      outerror(1,"Can't Resolve Server Host");
      close(gdata.ircserver);
      mydelete(to_ip);
      mydelete(to_port);
      return 1;
      }
   
   memcpy(&ircserverip.sin_addr, *((struct in_addr **)remotehost->h_addr_list), sizeof(struct in_addr));
   
   if (gdata.virthost) {
      if (!gdata.vhost_ip) outerror(0,"virthost = yes, but no vhost_ip set");
      bzero((char*)&localaddr, sizeof(struct sockaddr_in));
      localaddr.sin_family = AF_INET;
      localaddr.sin_port = 0;
      if (( localhost = gethostbyname(gdata.vhost_ip)) == NULL) {
         outerror(1,"Can't Resolve Virtual Host");
         close(gdata.ircserver);
         mydelete(to_ip);
         mydelete(to_port);
         return 1;
         }
      memcpy(&localaddr.sin_addr, *((struct in_addr **)localhost->h_addr_list), sizeof(struct in_addr));
      if (bind(gdata.ircserver, (struct sockaddr *) &localaddr, sizeof(localaddr)) < 0) {
         outerror(1,"Couldn't Bind To Virtual Host");
         close(gdata.ircserver);
         mydelete(to_ip);
         mydelete(to_port);
         return 1;
         }
      }
   
   if (set_socket_nonblocking(gdata.ircserver,1) < 0 )
      outerror(2,"Couldn't Set Non-Blocking");
   
   alarm(CTIMEOUT);
   retval = connect(gdata.ircserver, (struct sockaddr *) &ircserverip, sizeof(ircserverip));
   if ( (retval < 0) && !((errno == EINPROGRESS) || (errno == EAGAIN)) ) {
      outerror(1,"Connection to Server Failed");
      alarm(0);
      close(gdata.ircserver);
      mydelete(to_ip);
      mydelete(to_port);
      return 1;
      }
   alarm(0);
   
   addrlen = sizeof (ircserverip);
   if (getsockname(gdata.ircserver,(struct sockaddr *) &ircserverip, &addrlen) < 0) {
      outerror(1,"Couldn't get sock name");
      close(gdata.ircserver);
      mydelete(to_ip);
      mydelete(to_port);
      return 1;
      }
   
   if (!gdata.usenatip)
      gdata.ourip = ntohl(ircserverip.sin_addr.s_addr);
   
   if (gdata.debug) {
      ioutput(0,OUT_S,"0;33","ircserver socket = %d",gdata.ircserver);
      ioutput(0,OUT_S,"0;33","ourip = %d.%d.%d.%d",
	      (gdata.ourip >> 24) & 0xFF,
	      (gdata.ourip >> 16) & 0xFF,
	      (gdata.ourip >>  8) & 0xFF,
	      (gdata.ourip      ) & 0xFF
	      );
      }

   highestsock();
   
   gdata.lastservercontact=gdata.curtime;
   
   mydelete(to_ip);
   mydelete(to_port);
   return 0;
   }

void initirc(void) {
   char *tempstr = mycalloc(maxtextlength,"initirc");
   int i,j,k;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   highestsock();
   
   if (gdata.connectionmethod.how == how_custom && gdata.proxyinfo) {
      for (i=j=0; j<maxtextlength && i<strlen(gdata.proxyinfo); i++,j++) {
         tempstr[j] = gdata.proxyinfo[i];
         if (gdata.proxyinfo[i] == '$' && gdata.proxyinfo[i+1] == 's') {
            for (k=0,i++; j<maxtextlength && k<strlen(gdata.curserverip); k++,j++)
               tempstr[j] = gdata.curserverip[k];
            j--;
            }
         if (gdata.proxyinfo[i] == '$' && gdata.proxyinfo[i+1] == 'p') {
            for (k=0,i++; j<maxtextlength && k<strlen(gdata.curserverport); k++,j++)
               tempstr[j] = gdata.curserverport[k];
            j--;
            }
         }
      tempstr[j] = '\0';
      writeserver2(tempstr,1);
      }
      
   if (gdata.connectionmethod.how == how_custom && gdata.proxyinfo2) {
      for (i=j=0; j<maxtextlength && i<strlen(gdata.proxyinfo2); i++,j++) {
         tempstr[j] = gdata.proxyinfo2[i];
         if (gdata.proxyinfo2[i] == '$' && gdata.proxyinfo2[i+1] == 's') {
            for (k=0,i++; j<maxtextlength && k<strlen(gdata.curserverip); k++,j++)
               tempstr[j] = gdata.curserverip[k];
            j--;
            }
         if (gdata.proxyinfo2[i] == '$' && gdata.proxyinfo2[i+1] == 'p') {
            for (k=0,i++; j<maxtextlength && k<strlen(gdata.curserverport); k++,j++)
               tempstr[j] = gdata.curserverport[k];
            j--;
            }
         }
      tempstr[j] = '\0';
      writeserver2(tempstr,1);
      }
      
   if (gdata.connectionmethod.how == how_wingate) {
      isnprintf(tempstr,maxtextlength-2,"%s %s",gdata.curserverip,gdata.curserverport);
      writeserver2(tempstr,1);
      }
   
   isnprintf(tempstr,maxtextlength-2,"NICK %s",gdata.user_nick);
   writeserver2(tempstr,1);
   isnprintf(tempstr,maxtextlength-2,"USER %s 32 . :%s",gdata.loginname,gdata.user_realname);
   writeserver2(tempstr,1);
   
   if (gdata.connectionmethod.how == how_bnc) {
      isnprintf(tempstr,maxtextlength-2,"PASS %s",gdata.connectionmethod.password);
      writeserver2(tempstr,1);
      if (gdata.connectionmethod.vhost[0]) {
         isnprintf(tempstr,maxtextlength-2,"VIP %s",gdata.connectionmethod.vhost);
         writeserver2(tempstr,1);
         }
      isnprintf(tempstr,maxtextlength-2,"CONN %s %s",gdata.curserverip,gdata.curserverport);
      writeserver2(tempstr,1);
      }
   
   if (gdata.user_modes && strlen(gdata.user_modes)) {
      isnprintf(tempstr,maxtextlength-2,"MODE %s %s",gdata.user_nick,gdata.user_modes);
      writeserver2(tempstr,1);
      }

   for (i=0; i<MAXPREJOIN && gdata.prejoin[i]!=NULL;i++)
     writeserver(gdata.prejoin[i]);
     
   for (i=0; i<MAXCHNLS; i++)
      if (gdata.channels[i]) {
         joinchannel(gdata.channels[i]);
         gdata.channels[i]->flags &= ~CHAN_ONCHAN;
         }
   
   gdata.recentsent = 0;
   
   mydelete(tempstr);
   
   }

void writeserver2 (char *msg, int sendt) {
   int i, found;
   found = 0;
   
   if ( ( sendt || ! SND_FPROT ) && gdata.serverstatus == 'C') {
      if (gdata.debug)
         ioutput(0,OUT_S,"0;35","<SND<: %s",msg);
      strncat(msg,"\n",maxtextlength-strlen(msg)-1);
      write(gdata.ircserver, msg, strlen(msg));
      }
   else if (gdata.exiting)
     return;
   else {
      if (gdata.debug)
         ioutput(0,OUT_S,"0;35","<QUE<: %s",msg);
      found=0;
      for (i=0; (!found && i<MAXSENDQ); i++)
         if (gdata.serverq[i] == NULL) {
            found=1;
            gdata.serverq[i] = mycalloc(strlen(msg)+2,"writeserver2");
            strncpy(gdata.serverq[i],msg,strlen(msg)+1);
            }
      if (!found) {
         if (!gdata.attop) gototop();
         outerror(2,"Server Queue Is Full!! Are We Being Flooded??");
         }
      }
   }

void sendserver(void) {
   int i,j,count,curnum,howmany,temp1,sendmsg1;
   char *tempstr;
   
   sendmsg1 = gdata.curtime%3;
   curnum = gdata.curtime%30;
   
   if (gdata.serverq[0] == NULL && gdata.exiting && !gdata.recentsent) {
      FD_CLR(gdata.ircserver, &gdata.readset);
      close(gdata.ircserver);
      gdata.serverstatus = 'N';
      ioutput(0,OUT_S|OUT_D,NULL,"Connection to %s Closed",gdata.curserverip);
      return;
      }
   
   if (gdata.serverq[0] == NULL || gdata.serverstatus != 'C') {
      gdata.serversent[curnum] = 0;
      return;
      }
   
   temp1 = 0;
   for (i=1; i<30; i++)
      temp1 += gdata.serversent[getend(30,curnum-i)];
   
   if (temp1 > EXCESS_LEVEL_0) howmany = 0;
   else if (temp1 > EXCESS_LEVEL_1) howmany = 1;
   else if (temp1 > EXCESS_LEVEL_2) howmany = 2;
   else if (temp1 > EXCESS_LEVEL_3) howmany = 3;
   else howmany = 4;
   
   count=0;
   for (i=0; i<howmany; i++)
      if (gdata.serverq[0] != NULL) {
         if (!gdata.attop) gototop();
         if (gdata.debug)
            ioutput(0,OUT_S,"0;35","<IRC<: %s",gdata.serverq[0]);
         write(gdata.ircserver, gdata.serverq[0], strlen(gdata.serverq[0]));
         write(gdata.ircserver, "\n", 1);
         
         mydelete(gdata.serverq[0]);
         for (j=1; j<MAXSENDQ && gdata.serverq[j]; j++)
            gdata.serverq[j-1] = gdata.serverq[j];
         gdata.serverq[j-1] = NULL;
         
         if (j>srvqnotify && !sendmsg1) {
            tempstr = mycalloc(maxtextlength,"sendserver");
            outerror(2,"Server Queue Is Getting Big (%i Lines)",j);
            mydelete(tempstr);
            }
         count++;
         if (gdata.serverq[0] == NULL)
            gdata.recentsent = 6;
         else
            gdata.recentsent = 0;
         }

   gdata.serversent[curnum] = count;
   }

void getxdccconfig(const char *filename) {
   char *templine1 = mycalloc(maxtextlength,"getxdccconfig_templine1");
   char *templine2 = mycalloc(maxtextlength,"getxdccconfig_templine2");
   char *templine3 = mycalloc(maxtextlength,"getxdccconfig_templine3");
   char *templine4 = mycalloc(maxtextlength,"getxdccconfig_templine4");
   char *templine5 = mycalloc(maxtextlength,"getxdccconfig_templine5");
   char *templine6 = mycalloc(maxtextlength,"getxdccconfig_templine6");
   char *msg;
   int ok,i,count,hasspaces;
   int filedescriptor,xfiledescriptor;
   
   gdata.highmeminfo = 1;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   printf("*** Loading %s ... \n",filename);
   
   filedescriptor=open(filename, O_RDONLY | O_CREAT | ADDED_OPEN_FLAGS, S_IRUSR | S_IWUSR);
   if (filedescriptor < 0)
      outerror(0,"Couldn't Open/Create the xdcc File \"%s\"",filename);
   
   if (getfline(templine1,filedescriptor,0) != NULL) {            
      ok = 0;
      
      msg = getpart(templine1,6,"getxdccconfig");
      if (msg) {
         gdata.record=atof(msg);
         mydelete(msg);
         }
      else
         ok++;
         
      msg = getpart(templine1,7,"getxdccconfig");
      if (msg) {
         gdata.sentrecord=atof(msg);
         mydelete(msg);
         }
      else
         ok++;
      
      gdata.totalsent=0;
      msg = getpart(templine1,8,"getxdccconfig");
      if (msg) {
         gdata.totalsent=atoull(msg);
         mydelete(msg);
         }
      else
         ok++;
      
      gdata.totaluptime=0;
      msg = getpart(templine1,9,"getxdccconfig");
      if (msg) {
         gdata.totaluptime=atol(msg);
         mydelete(msg);
         }
      else
         ok++;
      
      
      if (ok) {
         outerror(1,"Invalid First Line, Reverting Values to 0");
         gdata.record = gdata.sentrecord = 0.0;
         gdata.totalsent = 0;
	 gdata.totaluptime = 0;
         }
      
      /* old format */
      msg = getpart(templine1,10,"getxdccconfig");
      if (msg) {
         gdata.totaluptime=atol(msg);
         mydelete(msg);
         
         msg = getpart(templine1,9,"getxdccconfig");
         if (msg) {
            gdata.totalsent=atoull(msg);
            mydelete(msg);
            }
      
         }
      
      }
   else {
      outerror(1,"Empty XDCC File, Starting With No Packs Offered");
      gdata.numpacks=0;
   
      gdata.slotsfull=0;
      close(filedescriptor);

      mydelete(templine1);
      mydelete(templine2);
      mydelete(templine3);
      mydelete(templine4);
      mydelete(templine5);
      mydelete(templine6);
      return;
      }

   ok=0;
   count=0;
   
   while (getfline(templine1,filedescriptor,1) != NULL) {
   
      if (getfline(templine1,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine2,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine3,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine4,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine5,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine6,filedescriptor,0) == NULL)  ok++;
      
      if (ok)
         outerror(0,"XDCC file syntax error (missing/extra line)");
      
      for (i=strlen(templine1)-1; i>2 && templine1[i] == ' '; i--)
         templine1[i] = '\0';
      for (i=strlen(templine2)-1; i>2 && templine2[i] == ' '; i--)
         templine2[i] = '\0';
      for (i=strlen(templine3)-1; i>2 && templine3[i] == ' '; i--)
         templine3[i] = '\0';
      for (i=strlen(templine4)-1; i>2 && templine4[i] == ' '; i--)
         templine4[i] = '\0';
      for (i=strlen(templine5)-1; i>2 && templine5[i] == ' '; i--)
         templine5[i] = '\0';
      for (i=strlen(templine6)-1; i>2 && templine6[i] == ' '; i--)
         templine6[i] = '\0';

      if ( templine1[3] != 'f' || templine1[4] != 'i' || templine1[5] != 'l' || templine1[6] != 'e' ) ok++;
      if ( templine2[3] != 'd' || templine2[4] != 'e' || templine2[5] != 's' || templine2[6] != 'c' ) ok++;
      if ( templine3[3] != 'n' || templine3[4] != 'o' || templine3[5] != 't' || templine3[6] != 'e' ) ok++;
      if ( templine4[3] != 'g' || templine4[4] != 'e' || templine4[5] != 't' || templine4[6] != 's' ) ok++;
      if ( templine5[3] != 'm' || templine5[4] != 'i' || templine5[5] != 'n' || templine5[6] != 's' ) ok++;
      if ( templine6[3] != 'm' || templine6[4] != 'a' || templine6[5] != 'x' || templine6[6] != 's' ) ok++;
      
      if (ok)
         outerror(0,"XDCC file syntax error (incorrect order?)");
      
      for (i=8; i<sstrlen(templine1); i++)
         templine1[i-8] = templine1[i];
      templine1[i-8]='\0';
      for (i=8; i<sstrlen(templine2); i++)
         templine2[i-8] = templine2[i];
      templine2[i-8]='\0';
      for (i=8; i<sstrlen(templine3); i++)
         templine3[i-8] = templine3[i];
      templine3[i-8]='\0';
      for (i=8; i<sstrlen(templine4); i++)
         templine4[i-8] = templine4[i];
      templine4[i-8]='\0';
      for (i=8; i<sstrlen(templine5); i++)
         templine5[i-8] = templine5[i];
      templine5[i-8]='\0';
      for (i=8; i<sstrlen(templine6); i++)
         templine6[i-8] = templine6[i];
      templine6[i-8]='\0';
      
      gdata.xdccs[count] = mycalloc(sizeof(xdcc),"getxdccconfig_xdccs[count]");
      
      strncpy(gdata.xdccs[count]->file,templine1,maxtextlength-1);
      
      hasspaces=0;
      for (i=0; i<sstrlen(gdata.xdccs[count]->file); i++)
         if (gdata.xdccs[count]->file[i] == ' ') hasspaces++;
      if (hasspaces)
         outerror(0,"The file \"%s\" has a space in the filename",gdata.xdccs[count]->file);

      strncpy(gdata.xdccs[count]->desc,templine2,maxtextlength-1);
      
      if ( strlen(templine3) )
         strncpy(gdata.xdccs[count]->note,templine3,maxtextlength-1);
      else
         strncpy(gdata.xdccs[count]->note,"",maxtextlength-1);
      
      gdata.xdccs[count]->gets     = atoi(templine4);
      
      gdata.xdccs[count]->minspeed = gdata.overallminspeed;
      if ( atof(templine5) > 0)
         gdata.xdccs[count]->minspeed = atof(templine5);
            
      gdata.xdccs[count]->maxspeed = gdata.transfermaxspeed;
      if ( atof(templine6) )
         gdata.xdccs[count]->maxspeed = atof(templine6);
            
      xfiledescriptor=open(gdata.xdccs[count]->file, O_RDONLY | ADDED_OPEN_FLAGS);
      if (xfiledescriptor < 0)
         outerror(0,"The file \"%s\" Could Not Be Opened Or Read",gdata.xdccs[count]->file);
      
      gdata.xdccs[count]->size = lseek(xfiledescriptor, 0, SEEK_END);
      
      if ( gdata.xdccs[count]->size == 0 )
         outerror(0,"The file \"%s\" has size of 0 bytes!",gdata.xdccs[count]->file);
      
      close(xfiledescriptor);
      
      count++;
      }
   
   gdata.numpacks=count;
   
   gdata.slotsfull=0;
   
   if (!gdata.totalsent)
      for (i=0; i<MAXXDCCS; i++)
         if (gdata.xdccs[i])
            gdata.totalsent += ((unsigned long long)gdata.xdccs[i]->gets)*((unsigned long long)gdata.xdccs[i]->size);

   close(filedescriptor);
   
   gdata.highmeminfo=0;
   
   mydelete(templine1);
   mydelete(templine2);
   mydelete(templine3);
   mydelete(templine4);
   mydelete(templine5);
   mydelete(templine6);

   }

char* getfilename(char * const full) {
   int i,lastslash;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   lastslash = -1;
   for (i=0; i<sstrlen(full); i++)
      if (full[i] == '/' || full[i] == '\\')
         lastslash=i;
   
   return full+lastslash+1;
   }

void pingserver(void) {
   char *tempstr = mycalloc(maxtextlength,"pingserver");

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   isnprintf(tempstr,maxtextlength-2,"PING %s",gdata.curserverip);
   writeserver2(tempstr, 1);
   mydelete(tempstr);
   }
  
void xdccsave(int autosave) {
   char *tempstr, *tempstr2;
   int i, filedescriptor, p;

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (autosave && gdata.noautosave > gdata.curtime ) return;
   
   tempstr = mycalloc(maxtextlength,"xdccsave");
   tempstr2 = mycalloc(maxtextlengthshort,"xdccsave");
   
   if (autosave)
      ioutput(1,OUT_S|OUT_D,NULL,"XDCC Autosave: Backing Up... ");
   else
      ioutput(1,OUT_S|OUT_D,NULL,"XDCC Save: Backing up... ");
   fflush(stdout);
   isnprintf(tempstr,maxtextlength-1,"%s.bkup",gdata.xdccfile);
   rename(gdata.xdccfile,tempstr);
   fflush(stdout);
   
   ioutput(2,OUT_S|OUT_D,NULL,"Saving... ");
   fflush(stdout);
   
   filedescriptor=open(gdata.xdccfile, O_WRONLY | O_CREAT | ADDED_OPEN_FLAGS, S_IRUSR | S_IWUSR);
   if (filedescriptor < 0) outerror(0,"Permission Denied");
   
   isnprintf(tempstr,(maxtextlength*2)-2,"Do Not Edit This File: %1.2f %1.2f %lu%09lu %li\n",
	     gdata.record,
	     gdata.sentrecord,
	     (unsigned long)(gdata.totalsent/1000000000),
	     (unsigned long)(gdata.totalsent%1000000000),
	     gdata.totaluptime);
   write(filedescriptor,tempstr,strlen(tempstr));
   
   
   for (i=1, p=0; i<=gdata.numpacks; i++, p++) {
      while ( p<(MAXXDCCS-1) && (gdata.xdccs[p] == NULL))
         p++;
      
      isnprintf(tempstr,maxtextlength-2,"\n"
              "%02i_file %s\n" "%02i_desc %s\n"
              "%02i_note %s\n" "%02i_gets %i\n",
              i%100,gdata.xdccs[p]->file, i%100,gdata.xdccs[p]->desc,
              i%100,gdata.xdccs[p]->note, i%100,gdata.xdccs[p]->gets );
      write(filedescriptor,tempstr,strlen(tempstr));
              
      if ( gdata.xdccs[p]->minspeed > 0 && gdata.overallminspeed != gdata.xdccs[p]->minspeed)
         isnprintf(tempstr,maxtextlength-2,"%02i_mins %1.1f\n",i%100,gdata.xdccs[p]->minspeed );
      else
         isnprintf(tempstr,maxtextlength-2,"%02i_mins \n",i%100 );
      write(filedescriptor,tempstr,strlen(tempstr));
      
      if ( gdata.xdccs[p]->maxspeed > 0 && gdata.transfermaxspeed != gdata.xdccs[p]->maxspeed)
         isnprintf(tempstr,maxtextlength-2,"%02i_maxs %1.1f\n",i%100,gdata.xdccs[p]->maxspeed );
      else
         isnprintf(tempstr,maxtextlength-2,"%02i_maxs \n",i%100 );
      write(filedescriptor,tempstr,strlen(tempstr));
      
      }
   close(filedescriptor);
   ioutput(3,OUT_S|OUT_D,NULL,"Done");
   fflush(stdout);
   
   mydelete(tempstr);
   mydelete(tempstr2);
   }

void writepidfile (const char *filename) {
   char *tempstr2 = mycalloc(maxtextlengthshort,"writepidfile");
   int filedescriptor;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Writing pid file...");
   
   filedescriptor=open(filename, O_WRONLY | O_TRUNC | O_CREAT | ADDED_OPEN_FLAGS, S_IRUSR | S_IWUSR);
   if (filedescriptor < 0) outerror(0,"PID File: Permission Denied");
   
   isnprintf(tempstr2,maxtextlengthshort,"%i\n",getpid());
   write(filedescriptor,tempstr2,strlen(tempstr2));
   
   close(filedescriptor);
   
   mydelete(tempstr2);
   }

char* getfline(char* str, int descr, int ret) {
   char tempc[2];
   int j;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   j = 0;
   strncpy(str,"",2);
   while(read(descr,&tempc,1) == 1) {
      if (tempc[0] == '\n' || tempc[0] == 13) { /* 13 is ^M */
         str[j] = '\0';
         j = 0;
         if (strlen(str) != 0 ) return str;
         else if ( ret )        return str;
         else                   return NULL;
         }
      else {
         str[j] = tempc[0];
         j++;
         }
      }
   return NULL;
   }

void gobackground(void) {
   int s,i;

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   printf("\n*** Entering Background Mode\n"
          "*** All Commands must be issued by remote administration\n");
   fflush(stdout);
   fflush(stderr);
   
   /* parent forks */
   s = fork();
   if (s < 0)
      outerror(0,"Unable to Fork");
   else if (s > 0) {
      /* parent exits */
      exit(0);
      }

/*   struct rlimit r = { 0 }; */
/*   r.rlim_max = 0; */
/*   s = getrlimit(RLIMIT_NOFILE, &r); */
/*   if ( r.rlim_max < 1 || s < 0) */
/*      outerror(0,"Couldn't get rlimit"); */
   
   for (i=0; i< 4; i++) close(i);
/*   for (i=0; i< r.rlim_max; i++) close(i); */
   
   s = setsid();
   if (s < 0)
      outerror(0,"Couldn't setsid");
   
   /* parent forks */
   s = fork();
   if (s < 0)
      outerror(0,"Unable to Fork");
   else if (s > 0)
      /* parent exits */
      exit(0);
   
   
   /* background continues... */
   
/*   umask(0); */
   s = open("/dev/null", O_RDWR); /* stdin */
   dup(s);                        /* stdout */
   dup(s);                        /* stderr */
   
   mylog(0,"Entered Background Mode");
   gdata.background = 2;
   
/*   execlp(program,"iroffer","--background-mode--",config,NULL); */
/*   exit(0); */
   
   }

void gotserverswitch (int sig) {
   sig = sig; /* -Wall complains its unused */

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   signal(SIGUSR1,gotserverswitch);
   ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Caught SIGUSR1, Switching Servers");
   gdata.serverstatus='S';
   }

void gotcrash (int sig) {
  int i;
  const char *reason;
  
  signal(SIGBUS,SIG_DFL);
  signal(SIGABRT,SIG_DFL);
  signal(SIGILL,SIG_DFL);
  signal(SIGFPE,SIG_DFL);
  signal(SIGSEGV,SIG_DFL);
  
  switch (sig)
    {
    case SIGBUS:
      reason = "Bus Fault";
      break;
    case SIGABRT:
      reason = "Abort Signal";
      break;
    case SIGILL:
      reason = "Illegal Instruction";
      break;
    case SIGFPE:
      reason = "Floating Point Exception";
      break;
    case SIGSEGV:
      reason = "Segmentation Fault";
      break;
    default:
      reason = "Unknown Fault";
      break;
    }
  
  ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"!!!!!!!!! %s !!!!!!!!!",reason);
  ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Context Trace:");
  
  for (i=0; i<MAXCONTEXTS; i++)
    ioutput(0,OUT_S|OUT_L|OUT_D,NULL,
	    "Trace %3i  %-20s %-16s:%5i",
	    i-MAXCONTEXTS+1,
	    gdata.context_log[(gdata.context_cur_ptr + 1 + i) % MAXCONTEXTS].func ?
	    gdata.context_log[(gdata.context_cur_ptr + 1 + i) % MAXCONTEXTS].func : "UNKNOWN",
	    gdata.context_log[(gdata.context_cur_ptr + 1 + i) % MAXCONTEXTS].file ?
	    gdata.context_log[(gdata.context_cur_ptr + 1 + i) % MAXCONTEXTS].file : "UNKNOWN",
	    gdata.context_log[(gdata.context_cur_ptr + 1 + i) % MAXCONTEXTS].line
	    );
  
  ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"!!!!!!!!! %s !!!!!!!!!",reason);
  ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Crashing... Please report this problem to PMG");
  
  if (!gdata.background) printf("\x1b[r\x1b[%i;1H\n",gdata.termlines);
  
  /* will crash when we leave the function because returning signal handling back to default */
}

void gothup (int sig) {
   sig = sig; /* -Wall complains its unused */

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   signal(SIGHUP,gothup);
   ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Caught SIGHUP, SIGHUP no longer used, read README");
   }

void gotstop (int sig) {
   sig = sig; /* -Wall complains its unused */

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   signal(SIGTSTP,gotstop);
   ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Caught SIGTSTP, Stopping with Ctrl-Z is not allowed, Sorry");
   }

void gotsigrehash (int sig) {
   sig = sig; /* -Wall complains its unused */

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   signal(SIGUSR2,gotsigrehash);
   gdata.needsrehash = 1;
   }

void gotalarm (int sig) {
   sig = sig; /* -Wall complains its unused */

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   signal(SIGALRM,gotalarm);
   }

char* getuptime(char *str, int type, time_t fromwhen) {
   int days, hours, mins;
   long temp;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   temp  = (gdata.curtime-fromwhen)/60;
   days  = temp/60/24;
   hours = temp/60 - (24*days);
   mins  = temp - (60*hours) - (24*60*days);
   
   if (type)
      isnprintf(str,maxtextlengthshort-2,"%dD %dH %dM",days,hours,mins);
   else
      isnprintf(str,maxtextlengthshort-2,"%d Days %d Hrs and %d Min",days,hours,mins);
      
   return str;
   }


void parsestdin(void) {
   int length;
   char* tempbuff1 = mycalloc(maxtextlength,"parsestdin");
   userinput ui;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   length = read (0, tempbuff1, maxtextlength-1);
   tempbuff1[length] = '\0';
   
   if (!gdata.attop) gototop();
   gdata.needsclear = strlen(tempbuff1);
   
   u_fillwith_stdin(&ui,tempbuff1);
   u_parseit(&ui);
   
   mydelete(tempbuff1);
   }

void shutdowniroffer(int sig) {
   int i;
   char *tempstr2;
   char *tempstr = mycalloc(maxtextlength,"shutdowniroffer");
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (!gdata.attop) gototop();
   signal(SIGINT,shutdowniroffer);
   signal(SIGTERM,shutdowniroffer);
   
   if ( SAVEQUIT )
      xdccsave(0);
   if ( SAVEQUIT )
      write_ignorefile();
   
   if (gdata.exiting || gdata.serverstatus != 'C') {
      if (gdata.exiting)
         ioutput(0,OUT_S,NULL,"Shutting Down (FORCED)");
      else
         ioutput(0,OUT_S,NULL,"Shutting Down");
      
      if (sig)
         mylog(0,"iroffer exited (shutdown/SIGTERM/SIGINT)\n\n");
      else
         mylog(0,"iroffer exited (shutdown)\n\n");

      if (!gdata.background) printf("\x1b[r\x1b[%i;1H\n",gdata.termlines);
      if (gdata.pidfile) unlink(gdata.pidfile);
      exit(0);
      }
   
   
   ioutput(0,OUT_S,NULL,"Shutting Down... (Issue \"SHUTDOWN\" again to force quit)");
   
   /* empty queue */
   for (i=0; i<MAXSENDQ; i++)
      gdata.serverq[i] = NULL;
   
   /* close connections */
   for (i=0; i<MAXTRANS; i++)
      if (gdata.trans[i] != NULL) {
         notice(gdata.trans[i]->nick,"*** Shutting Down. Closing Connection. (Resume Supported)");
      
         FD_CLR(gdata.trans[i]->clientsocket, &gdata.writeset);
         FD_CLR(gdata.trans[i]->clientsocket, &gdata.readset);
         if (gdata.trans[i]->listensocket != 1000)
            close(gdata.trans[i]->listensocket);
         if (gdata.trans[i]->clientsocket != 1000)
            close(gdata.trans[i]->clientsocket);
         if (gdata.trans[i]->filedescriptor != 1000)
            close(gdata.trans[i]->filedescriptor);
         gdata.trans[i]->status='D';
         gdata.trans[i]->xpack->gets++;
         
         ioutput(0,OUT_S|OUT_D,"0;33","XDCC Transfer to %s Closed",gdata.trans[i]->nick);
         }
   
   /* close upload connections */
   for (i=0; i<MAXUPLDS; i++)
      if (gdata.uploads[i] != NULL) {
         notice(gdata.uploads[i]->nick,"*** Shutting Down. Closing Upload Connection. (Resume Supported)");
      
         FD_CLR(gdata.uploads[i]->clientsocket, &gdata.writeset);
         FD_CLR(gdata.uploads[i]->clientsocket, &gdata.readset);
         if (gdata.uploads[i]->clientsocket != 1000)
            close(gdata.uploads[i]->clientsocket);
         if (gdata.uploads[i]->filedescriptor != 1000)
            close(gdata.uploads[i]->filedescriptor);
         gdata.uploads[i]->status='D';
         
         ioutput(0,OUT_S|OUT_D,"0;33","Upload Transfer from %s Closed",gdata.uploads[i]->nick);
         }
   
   /* quit */
   tempstr2 = mycalloc(maxtextlengthshort,"shutdowniroffer");
   tempstr2 = getuptime(tempstr2,1,gdata.startuptime);
   isnprintf(tempstr,maxtextlength-2,"QUIT :iroffer v" VERSION " By PMG - %s - running %s",gdata.osstring,tempstr2);
   mydelete(tempstr2);
   if (gdata.serverstatus == 'C')
      writeserver(tempstr);
   
   gdata.exiting = 1;
   
   ioutput(0,OUT_S|OUT_D,NULL,"Waiting for Server Queue To Flush...");
   
   write(gdata.dccchat,"Shutdown Recieved, Closing DCC Chat\n",36);
   FD_CLR(gdata.dccchat, &gdata.readset);
   msleep(100);
   close(gdata.dccchat);
   gdata.dccchat = 1000;
   highestsock();

   mydelete(tempstr);
   }

void switchserver(int which) {
   char *tempstr = mycalloc(maxtextlength,"switchserver");
   int i, snum;
   float j;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   /* quit */
   if (gdata.serverstatus == 'C') {
      strncpy(tempstr,"QUIT :Changing Servers",maxtextlength-1);
      writeserver2(tempstr,1);
      ioutput(0,OUT_S|OUT_L|OUT_D,"0;31","Changing Servers");
   
      FD_CLR(gdata.ircserver, &gdata.readset);
      close(gdata.ircserver);
      }
   
   if (gdata.serverstatus == 'T')
     {
       FD_CLR(gdata.ircserver, &gdata.readset);
       close(gdata.ircserver);
     }
   
   gdata.serverstatus = 'N';
   
   if ( which >= 0 && which < MAXSRVS && gdata.server[which] )
     /* manual jump */
     if (!connectirc(gdata.server[which]))
       gdata.serverstatus = 'T';

   while (gdata.serverstatus == 'N') {
   
      for (i=0; gdata.server[i] && i<MAXSRVS; i++);
      j = (float)i;
      
      snum = (int) (j*rand()/(RAND_MAX+0.0));
      
      /* weird problem? */
      if (snum > i || snum < 0)
         outerror(1,"rand() returned out of range value, it broke!?!?");
      while (snum > i || snum < 0) {
         if (snum < 0) snum += i;
         if (snum > i) snum -= i;
         }
      
      if (!connectirc(gdata.server[snum]))
         gdata.serverstatus = 'T';
      
      }
   
   gdata.servertime = 0;
   mydelete(tempstr);
   }

char* getstatusline(char *str) {
   int i,count,srvq;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   count = 0;
   for (i=0; i<120; i++)
      count += gdata.xdccsent[i];
   
   for (srvq=0; gdata.serverq[srvq] && srvq<MAXSENDQ; srvq++);
   
   isnprintf(str,maxtextlength-2,"Stat: %i/%i Sls, %i/%i,%i/%i Q, %1.1fK/s Rcd, %i SrQ (Bdw: %iK, %1.1fK/s, %1.1fK/s Rcd)",
      gdata.slotsfull,gdata.slotsmax,gdata.inqueue,gdata.queuesize,gdata.inslotsmaxqueue,gdata.slotsmaxqueue,
      gdata.record,srvq,count/1024,((float)count)/120.0/1024.0,gdata.sentrecord);
   
   return str;
   
   }

char* getstatuslinenums(char *str) {
   int i,count,gcount,srvq;
   float scount,ocount;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   count = 0;
   for (i=0; i<120; i++)
      count += gdata.xdccsent[i];
   
   for (srvq=0; gdata.serverq[srvq]; srvq++);
   
   gcount = 0;
   scount = ocount = 0;
   for (i=0; i<MAXXDCCS; i++)
      if (gdata.xdccs[i]) {
         gcount += gdata.xdccs[i]->gets;
         ocount += (float)gdata.xdccs[i]->size;
         scount += ((float)gdata.xdccs[i]->gets)*((float)gdata.xdccs[i]->size);
         }
   
   isnprintf(str,maxtextlength-2,"stat %i %1.0f %i %1.0f %i %i %i %i %i %i %1.1f %i %i %1.1f %1.1f",
      gdata.numpacks,ocount/1024/1024,gcount,scount/1024/1024,
      gdata.slotsfull,gdata.slotsmax,gdata.inqueue,gdata.queuesize,gdata.inslotsmaxqueue,gdata.slotsmaxqueue,
      gdata.record,srvq,count/1024,((float)count)/120.0/1024.0,gdata.sentrecord);
   
   return str;
   
   }

void sendxdlqueue (void) {
   int i;
   char *tempstr;
   userinput ui;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (!(gdata.xlistqueue[0])) return;
   
   tempstr = mycalloc(maxtextlength,"sendxdlqueue");
   
   tempstr[0] = '\0';
   strncat(tempstr,gdata.xlistqueue[0],maxtextlength-strlen(tempstr)-1);
   for (i=1; i<MAXXLQUE && gdata.xlistqueue[i]; i++) {
      strncat(tempstr,",",maxtextlength-strlen(tempstr)-1);
      strncat(tempstr,gdata.xlistqueue[i],maxtextlength-strlen(tempstr)-1);
      }
   
   ioutput(0,OUT_S|OUT_D,"0;33","Sending XDCC LIST to: %s",tempstr);
   
   u_fillwith_msg(&ui,tempstr,"A A A A A xdl");
   ui.method = method_xdl_user;
   u_parseit(&ui);
   
   for (i=0; i<MAXXLQUE && gdata.xlistqueue[i]; i++)
      mydelete(gdata.xlistqueue[i]);
   
   mydelete(tempstr);
   }

int addressedtome(const char *dest)
{
     if (!dest) { outerror(1,"addressedtome() got NULL value"); return 1; }
     return (!strcmp(gdata.caps_nick,dest));
}

int isthisforme (const char *dest, char *msg1) {
   if (!msg1 || !dest) { outerror(1,"isthisforme() got NULL value"); return 1; }
   
   
   if (
         !strcmp(msg1,"\1CLIENTINFO") || !strcmp(msg1,"\1CLIENTINFO\1")
      || !strcmp(msg1,"\1PING") || !strcmp(msg1,"\1PING\1") 
      || !strcmp(msg1,"\1VERSION") || !strcmp(msg1,"\1VERSION\1")
      || !strcmp(msg1,"\1UPTIME") || !strcmp(msg1,"\1UPTIME\1") 
      || !strcmp(msg1,"\1STATUS") || !strcmp(msg1,"\1STATUS\1")
      || (!strcmp(gdata.caps_nick,dest) && !strcmp(caps(msg1),"\1DCC"))
      || (!strcmp(gdata.caps_nick,dest) && !strcmp(caps(msg1),"ADMIN"))
      || (!strcmp(gdata.caps_nick,dest) && (!strcmp(caps(msg1),"XDCC") || !strcmp(msg1,"\1XDCC") || !strcmp(caps(msg1),"CDCC") || !strcmp(msg1,"\1CDCC")))
      || !strcmp(dest,gdata.caps_nick)
      ) return 1;
   
   return 0;
   
   }

void initvars(void) {
  int i;
  
   bzero((char *) gdata.serverq, MAXSENDQ * sizeof(char*) );
   bzero((char *) gdata.inamnt, 10 * sizeof(int) );
   bzero((char *) gdata.xdccsent, 120 * sizeof(unsigned long) );
   bzero((char *) gdata.adminhost, MAXAHOST * sizeof(regex_t) );
   bzero((char *) gdata.xlistqueue, MAXXLQUE * sizeof(char *) );
   
   bzero((char *) gdata.meminfo, MAXMEMINFO * sizeof(meminfo_t) );
   bzero((char *) gdata.configfile, MAXCONFIG * sizeof(char *) );
   bzero((char *) &gdata.connectionmethod,sizeof(connectionmethod_t));
   bzero((char *) gdata.context_log, MAXCONTEXTS * sizeof(context_t) );
   
   gdata.context_cur_ptr = 0;
   gdata.ignore = 0;
   gdata.servertime = 0;
   gdata.serverstatus = 'N';
   gdata.record = 0.0;
   gdata.nocon = 0;
   gdata.slotsmaxpack = 0;
   gdata.slotsmaxslots = 0;
   gdata.sentrecord = 0.0;
   gdata.exiting = 0;
   gdata.slotsmaxqueue = 0;
   gdata.inslotsmaxqueue = 0;
   gdata.queuesize = 0;
   gdata.inqueue = 0;
   gdata.termcols = 0;
   gdata.termlines = 0;
   gdata.lowbdwth = 0;
   gdata.dccchat = 1000;
   gdata.dccchatlisten = 1000;
   gdata.logstats = 1;
   gdata.logrotate = 0;
   gdata.firewall = 0;
   gdata.dccrangestart = 4000;
   gdata.overallminspeed = gdata.transfermaxspeed = 0;
   gdata.noautosave = 0;
   gdata.nonewcons = 0;
   gdata.nolisting = 0;
   gdata.overallmaxspeed = gdata.overallmaxspeeddayspeed = 0;
   gdata.overallmaxspeeddaytimestart = gdata.overallmaxspeeddaytimeend = 0;
   gdata.overallmaxspeeddaydays = 0x7F; /* all days */
   gdata.maxb = 0;
   gdata.maxtransfersperperson = 1;
   gdata.virthost = 0;
   gdata.autosend = 0;
   gdata.debug = 0;
   gdata.debug2 = 0;
   gdata.delayedshutdown = gdata.needsrehash = 0;
   gdata.highmeminfo = 1;
   gdata.usenatip = 0;
   gdata.ignorefile = gdata.messagefile = gdata.filedir = NULL;
   gdata.uploadallowed = 0;
   gdata.uploaddir = NULL;
   gdata.uploadmaxsize = 0;
   gdata.connectionmethod.how = how_direct;
   gdata.termcols = 80;
   gdata.termlines = 24;
   gdata.restrictlist = gdata.restrictsend = 0;
   
   gdata.startuptime = gdata.curtime = time(NULL);
   for (i=0;i<MAXADVERTS;i++)
     gdata.advert[i]=NULL;
   gdata.nolistbantime=-1;
   gdata.publictriggers=1;
   gdata.humiliate=NULL;
   gdata.nospeedwarnings=0;
   gdata.fullignoretime=0;
   gdata.noadverts=0;
   for (i=0;i<MAXPREJOIN;i++)
     gdata.prejoin[i]=NULL;
   gdata.badpack.interval=gdata.badpack.maxattempts=1;
   gdata.badpack.badpacktime=gdata.badpack.bantime=0;
   for (i=0;i<MAXBADPACK;i++)
     gdata.badpack.list[i].hostmask=NULL;
   }
   
void startupiroffer(void) {
   char *tempstr23, *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   srand((unsigned int)( (getpid()*5000) + (gdata.curtime%5000) ));
   
   if (!gdata.background) {
      initscreen();
      gotobot();
      gototop();
      }
   
   printf("\n");
   if (!gdata.background) printf("\x1b[1;33m");
   printf("Welcome to iroffer by PMG\nVersion " VERSION " [" VERSIONDATE "]\n");
   if ( ! RELEASE )
      printf("\n                          *** PRE-RELEASE VERSION ***");
   printf(   "\n             *** Visit the iroffer web site http://iroffer.org/ ***"
             "\n       *** Have you joined the iroffer mailing list? See the web site ***");
   if (!gdata.background) printf("\x1b[0m");
   printf("\n\n");
   
   /* signal handling */
   signal(SIGPIPE,SIG_IGN);
   signal(SIGALRM,gotalarm);
   signal(SIGHUP,gothup);

   signal(SIGBUS,gotcrash);
   signal(SIGABRT,gotcrash);
   signal(SIGILL,gotcrash);
   signal(SIGFPE,gotcrash);
   signal(SIGSEGV,gotcrash);
   
   signal(SIGTERM,shutdowniroffer);
   signal(SIGINT, shutdowniroffer);
   
   signal(SIGUSR1,gotserverswitch);
   signal(SIGUSR2,gotsigrehash);

   signal(SIGTSTP,gotstop);

   printf("*** iroffer is distributed under the GNU General Public License.\n"
          "***    please see the README for more information.\n");

   printf("\n*** Starting up...\n");
   
   if (geteuid() == 0)
     {
       outerror(
#if BLOCKROOT
		0, /* die */
#else
		1, /* warn */
#endif
		"iroffer should not be run as root!"
		);
     }
   
   if (!gdata.background)
      printf("*** Window Size: %ix%i\n",gdata.termcols,gdata.termlines);
   
   tempstr23 = mycalloc(maxtextlength,"startupiroffer_temp");
   printf("*** Started on: %s\n",getdatestr(tempstr23,0));
   mydelete(tempstr23);
   
   set_loginname();
   
   getconfig();
   
   if (RELEASE) mylog(0,"iroffer started v" VERSION " [" VERSIONDATE "]");
   else mylog(0,"iroffer started v" VERSION " [" VERSIONDATE "] *PRERELEASE*");

   getxdccconfig(gdata.xdccfile);
   
   getos();
   
   if ( gdata.curtime > VERSIONDATEUTC + 120*24*60*60 )
      printf("\n*** NOTICE: This version is %li days old.\n"
               "***         Please check for a newer version.\n\n",
                (long)(gdata.curtime - VERSIONDATEUTC)/(24*60*60));

   if (gdata.messagefile) {
      tempstr = mycalloc(maxtextlength,"startupiroffer_temp");
      msglog_howmany(tempstr);
      printf("%s\n",tempstr);
      mydelete(tempstr);
      }

   if (gdata.ignorefile)
      read_ignorefile();

   /* fork to background if in background mode */
   if (gdata.background) gobackground();
   
   if (gdata.pidfile)
      writepidfile(gdata.pidfile);
   
   gdata.serverstatus = 'N';
   switchserver(-1);
   
   
   plugin_initialize();
   
   }


void isrotatelog(void) {
   time_t then;
   struct tm *lnow = NULL, *lthen = NULL;
   char *newname;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   lnow = localtime(&gdata.curtime);
   
   if (lnow == NULL || lnow->tm_hour != 0)
      return;
   
   newname = mycalloc(maxtextlength-2,"isrotatelog");
   if (gdata.logrotate == 1) {
      then = gdata.curtime - 60*60*24;
      lthen = localtime(&then);
      isnprintf(newname,maxtextlength-1,"%s.%04i-%02i-%02i",
         gdata.logfile,lthen->tm_year+1900,lthen->tm_mon+1,lthen->tm_mday);
      if (!doesfileexist(newname)) {
         mylog(0,"Rotating Log");
         rename(gdata.logfile,newname);
         ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Logfile moved (daily) to %s",newname);
         }
      }
   if (gdata.logrotate == 2 && lnow->tm_wday == 0) {
      then = gdata.curtime - 60*60*24*7;
      lthen = localtime(&then);
      isnprintf(newname,maxtextlength-1,"%s.%04i-w%02i",
         gdata.logfile,lthen->tm_year+1900,lthen->tm_yday/7);
      if (!doesfileexist(newname)) {
         mylog(0,"Rotating Log");
         rename(gdata.logfile,newname);
         ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Logfile moved (weekly) to %s",newname);
         }
      }
   if (gdata.logrotate == 3 && lnow->tm_mday == 1) {
      then = gdata.curtime - 60*60*24*2;
      lthen = localtime(&then);
      isnprintf(newname,maxtextlength-1,"%s.%04i-%02i",
         gdata.logfile,lthen->tm_year+1900,lthen->tm_mon+1);
      if (!doesfileexist(newname)) {
         mylog(0,"Rotating Log");
         rename(gdata.logfile,newname);
         ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Logfile moved (monthly) to %s",newname);
         }
      }
   
   
   mydelete(newname);
   }


void createpassword(void) {
#if ENCRYPTPASS
   char pw1[maxtextlengthshort], pw2[maxtextlengthshort];
   int len, ok, saltnum;
   char salt[3], *pwout;
   
   printf("\niroffer v" VERSION " [" VERSIONDATE "] by PMG\n"
          "  Configuration File Password Generator\n"
          "\n"
          "This will take a password of your choosing and encrypt it.\n"
          "You should place the output this program generates in your config file.\n"
          "You can then use your password you enter here over irc.\n"
          "\n"
          "NOTE: if iroffer crashes after you enter your passowrd, you may need to\n"
          "      disable password encryption.  there are some systems that have a\n"
          "      non-standard crypt() that iroffer doesn't know how to use.\n"
          "      To disable password encryption change ENCRYPTPASS to 0 in defines.h\n"
          "\n"
          "Your password must be between 5 and 8 characters\n");
   
   
   ok = 0;
   while ( !ok ) {
      printf("Please Enter Your Password: "); fflush(stdout);
      
      if ( (len = read(0,pw1,maxtextlengthshort-1)) < 0 )
         { fprintf(stderr,"Couldn't Read Your Password, Try Again\n"); exit(1); }
      if (pw1[len-1] == '\n') { pw1[len-1] = '\0'; len--;}
      
      if ( len < 5 || len > 8 )
         printf("Wrong Length, Try Again\n");
      else
         ok = 1;
   }
   
   printf("And Again for Verification: ");
   fflush(stdout);

   if ( (len = read(0,pw2,maxtextlengthshort-1)) < 0 )
      { fprintf(stderr,"Couldn't Read Your Password, Try Again\n"); exit(1); }
   if (pw2[len-1] == '\n') { pw2[len-1] = '\0'; len--;}
   
   if ( strcmp(pw1,pw2) )
      { fprintf(stderr,"The Password Didn't Match, Try Again\n"); exit(1); }
   
   
   srand((unsigned int)( (getpid()*5000) + (time(NULL)%5000) ));
   saltnum = (int)(4096.0*rand()/(RAND_MAX+0.0));
   salt[0] = inttosaltchar((saltnum>>6) %64);
   salt[1] = inttosaltchar( saltnum     %64);
   salt[2] = '\0';
   
   pwout = crypt(pw1,salt);
   
   if (pwout && strlen(pwout) == 13)
      printf("\n"
             "To use \"%s\" as your password use the following in your config file:\n"
             "adminpass %s\n"
             "\n"
             ,pw1,pwout);
   else
      printf("\n"
             "The crypt() function does not appear to be working correctly\n"
             "You might need to disable password encryption in defines.h and recompile\n"
             "\n");
   
#else
   printf("This binary of iroffer was compiled without encrypted password support. See defines.h\n");
#endif
   }

/* 0 .. 63 */
char inttosaltchar (int n) {
   
   if ( n < 26 )
      return  n + 'a';
   else if ( n < 26*2 )
      return  n - 26 + 'A';
   else if ( n < 26*2+10 )
      return  n - 26 - 26 + '0';
   else if ( n < 26*2+10+1 )
      return  '.';
   else if ( n < 26*2+10+2 )
      return  '/';
   
   return 0; /* error */
   
   }

void notifyqueued(void) {
   int i,j,count;
   unsigned long rtime, lastrtime;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if ( !gdata.exiting && (gdata.inqueue || gdata.inslotsmaxqueue)) {
      count = 0;
      for (i=0; i<120; i++)
         count += gdata.xdccsent[i];
      
      ioutput(0,OUT_S|OUT_D,"0;33","Notifying %d Queued People (%dK/sec used, %dK/sec limit)",
         gdata.inqueue+gdata.inslotsmaxqueue,count/120/1024,gdata.lowbdwth);

      }
   
   lastrtime=0;
   
   /* if we are sending more than allowed, we need to skip the difference */
   for (i=0; i<gdata.slotsfull-gdata.slotsmax; i++)
     {
       rtime=-1;
       for (j=0; j<MAXTRANS; j++)
	 if (gdata.trans[j]) {
	   int left = min2(359999,(gdata.trans[j]->xpack->size-gdata.trans[j]->bytessent)/((int)(max2(gdata.trans[j]->lastspeed,0.001)*1024)));
	   if (left > lastrtime && left < rtime)
	     rtime = left;
	 }
       if (rtime < 359999)
	 lastrtime=rtime;
     }
   
   for (i=0; i<gdata.inqueue; i++) {
     
     rtime=-1;
     for (j=0; j<MAXTRANS; j++)
       if (gdata.trans[j]) {
	 int left = min2(359999,(gdata.trans[j]->xpack->size-gdata.trans[j]->bytessent)/((int)(max2(gdata.trans[j]->lastspeed,0.001)*1024)));
	 if (left > lastrtime && left < rtime)
	   rtime = left;
       }
     if (rtime < 359999)
       lastrtime=rtime;
     
     notice(gdata.mainqueue[i]->nick,"You have been queued for %li hr %li min, currently in main queue position %i of %i.  Estimated remaining time is %li hr %li min or %s.  To remove yourself type \"/msg %s xdcc remove\".",
            (gdata.curtime-gdata.mainqueue[i]->queuedtime)/60/60,
            ((gdata.curtime-gdata.mainqueue[i]->queuedtime)/60)%60,
            i+1,
            gdata.inqueue,
	    lastrtime/60/60,
	    (lastrtime/60)%60,
	    (rtime >= 359999) ? "more" : "less",
            gdata.user_nick);
      }
   for (i=0; i<gdata.inslotsmaxqueue; i++) {
         notice(gdata.packqueue[i]->nick,"You have been queued for %li hr %li min, currently in pack queue position %i of %i.  To remove yourself type \"/msg %s xdcc remove\".",
            (gdata.curtime-gdata.packqueue[i]->queuedtime)/60/60,
            ((gdata.curtime-gdata.packqueue[i]->queuedtime)/60)%60,
            i+1,
            gdata.inslotsmaxqueue,
            gdata.user_nick);
      }
   
   
   }

void notifybandwidth(void) {
   int i,j;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (gdata.exiting) return;
   if (!gdata.maxb || gdata.nospeedwarnings) return;
   
   
   j = 0;
   for (i=0; i<120; i++)
      j += gdata.xdccsent[i];
   j /= 1024;
   
   /* send if over 90% */
   if ( (j*10) > (gdata.maxb*30*9) ) {
      for (i=0; i<MAXTRANS; i++)
         if (gdata.trans[i] != NULL && (gdata.trans[i]->needsdata > 0) ) {
         notice(gdata.trans[i]->nick,"%s has an overall bandwidth limit. %2.1fKB/sec of %2.1fKB/sec is in use right now. "
           "%s can only send you %2.1fKB/sec even though you are requesting more than that.",
           gdata.user_nick,
           ((float)j)/120.0,
           ((float)gdata.maxb)/4.0,
           gdata.user_nick,
           gdata.trans[i]->lastspeed
           );
         }
      }
   
   }

void notifybandwidthtrans(void) {
   int i;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (gdata.exiting || gdata.nospeedwarnings) return;
   
   for (i=0; i<MAXTRANS; i++)
      if (gdata.trans[i] != NULL
      && !gdata.trans[i]->nomax
      && (gdata.trans[i]->xpack->maxspeed > 0)
      && gdata.curtime-gdata.trans[i]->connecttime > MIN_TL
      && gdata.trans[i]->lastspeed*10 > gdata.trans[i]->xpack->maxspeed*9) {
         /* send if over 90% */
         notice(gdata.trans[i]->nick,"Your pack has a transfer bandwidth limit. "
           "You are using %2.1fKB/sec of %2.1fKB/sec right now.",
           gdata.trans[i]->lastspeed,
           gdata.trans[i]->xpack->maxspeed
           );
         }
   
   }

void write_ignorefile(void) {
   int fd,i;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (gdata.ignorefile == NULL)
      return;
   
   ioutput(1,OUT_S|OUT_D,NULL,"Saving Ignore List... ");
   
   fd=open(gdata.ignorefile, O_WRONLY | O_CREAT | O_TRUNC | ADDED_OPEN_FLAGS, S_IRUSR | S_IWUSR );
   if (fd < 0) {
      outerror(1,"Couldn't open/create Ignore File");
      return;
      }
   
   write(fd,&gdata.curtime,sizeof(time_t));
   
   for (i=0; i<MAXIGNL; i++)
      if (gdata.ignorelist[i])
         write(fd,gdata.ignorelist[i],sizeof(igninfo));
   
   close(fd);
   
   ioutput(3,OUT_S|OUT_D,NULL,"Done");
   }

void read_ignorefile(void) {
   int fd,i,end=0;
   time_t whenwritten = 0;
   igninfo tempi;
   struct stat st;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (gdata.ignorefile == NULL)
      return;
   
   ioutput(1,OUT_S|OUT_D,NULL,"Loading Ignore List... ");
   
   fd=open(gdata.ignorefile, O_RDONLY | O_CREAT | ADDED_OPEN_FLAGS, S_IRUSR | S_IWUSR );
   if (fd < 0) {
      outerror(1,"Couldn't open/create Ignore File");
      return;
      }
   
   if (fstat(fd,&st) < 0 || st.st_size == 0) {
      ioutput(3,OUT_S|OUT_D,NULL,"Empty, Skipping");
      return;
      }
   
   if (read(fd,&whenwritten,sizeof(time_t)) != sizeof(time_t)) {
      outerror(1,"Couldn't Read Ignore File Timestamp!");
      return;
      }
   
   if (whenwritten > gdata.curtime) {
      outerror(1,"Ignore File Timestamp Is In The Future?!@?");
      return;
      }
   
   for (i=0; i<MAXIGNL && !end; i++) {
      if (read(fd,&tempi,sizeof(igninfo)) == sizeof(igninfo)) {
         tempi.bucket -= (gdata.curtime-whenwritten)/IGN_TL;
         gdata.ignorelist[i] = mycalloc(sizeof(igninfo),"read_ignorefile");
         memcpy(gdata.ignorelist[i],&tempi,sizeof(igninfo));
         }
      else
         end=1;
      }
   
   close(fd);
   
   ioutput(3,OUT_S|OUT_D,NULL,"Done");
   }



int isbanned(const int i, const char* host)
{
  /* This function check to see if the host is in the list either
     directly or via a netmask */
  int x,y;
  char *hptr;

  if (!gdata.ignorelist[i] || !host)
    return 0;
  hptr=gdata.ignorelist[i]->hostname;
  if (gdata.ignorelist[i]->flags & IGN_RANGE)
    {
      /* Its a range so we have to check the host name matches */
      x=strlen(++hptr);
      y=strlen(host);
      if (y<x)
	return 0;
      return (!strcmp(&(host[y-x]),hptr))?1:0;
    }
  return (!strcmp(hptr,host));
}
  
      
	  

/* End of File */





