/*      
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) globals.h 1.30@(#)
 * pmg@alliance.centerclick.org|src/globals.h|20011110143645|13985
 * 
 */

#if !defined _IROFFER_GLOBALS
#define _IROFFER_GLOBALS

#include "headers.h"

#if !defined GEX
#define GEX extern
#endif


typedef struct
{
/* config */
connectionmethod_t connectionmethod;
char* configfile[MAXCONFIG];
char* osstring;
long startuptime;
int virthost;
char *vhost_ip;
int lowbdwth;
int logstats;
char *logfile;
int logrotate;
char *creditline;
int background;
unsigned long ourip;
int usenatip;
int autosend;
int autopack;
char *autoword, *automsg;
char *xdccfile;
char *pidfile;
char *proxyinfo, *proxyinfo2;
int firewall, dccrangestart;
float overallminspeed, transfermaxspeed;
int overallmaxspeed, overallmaxspeeddayspeed;
int maxb;
int overallmaxspeeddaytimestart, overallmaxspeeddaytimeend;
char overallmaxspeeddaydays;
int maxtransfersperperson, maxqueueditemsperperson;
char *adminpass;
regex_t *adminhost[MAXAHOST];
char *filedir, *messagefile, *ignorefile;
char *periodicmsg_nick, *periodicmsg_msg;
int  periodicmsg_time;
int uploadallowed;
char *uploaddir;
size_t uploadmaxsize;
char *user_nick, *caps_nick;
char *user_realname, *user_modes, *loginname;
int restrictlist, restrictsend;

/* rehash temp variables */
channel_t *r_channel[MAXCHNLS];
channel_t *t_channel[MAXCHNLS];
char *r_vhost_ip;
char *r_pidfile;
char *r_user_nick;
char *r_xdccfile;
int r_virthost;
float r_overallminspeed, r_transfermaxspeed;

/* server */
char *server[MAXSRVS], *curserverip, *curserverport;
int nocon;
int servertime;
char serverstatus; /* C = connected, T = trying, N = need to connect, S = need to switch */
long lastservercontact;
char *serverq[MAXSENDQ];
int serversent[30];
int ircserver;
int xdccautosavetime;

/* screen */
int attop, needsclear, termcols, termlines;

/* channel */
channel_t *channels[MAXCHNLS];

/* dcc chat */
int dccchat, dccchatin, dccchatlisten;
struct sockaddr_in dccchatlistenaddr;

time_t curtime;

fd_set readset, writeset;
int highests;


float record;
float sentrecord;
unsigned long long totalsent;
long totaluptime;
int debug;
int debug2;
int exiting;

unsigned long xdccsent[120];

int inamnt[10];
int ignore;

int numpacks, slotsfull, slotsmax;
int recentsent;
int slotsmaxpack, slotsmaxslots, slotsmaxqueue, inslotsmaxqueue;
int queuesize, inqueue;


int noautosave;
long nonewcons;
long nolisting;
int needsrehash;
int delayedshutdown;
int highmeminfo;
int cursendptr;

char sendbuff[BUFFERSIZE];

context_t context_log[MAXCONTEXTS];
int context_cur_ptr;

#ifdef NO_SNPRINTF
char mysnprintf_buff[1024*10];
#endif

char *xlistqueue[MAXXLQUE];

igninfo *ignorelist[MAXIGNL];

xdcc *xdccs[MAXXDCCS+1];
pqueue *mainqueue[MAXQUEUE];
pqueue *packqueue[MAXQUEUE];
transfer *trans[MAXTRANS];
upload *uploads[MAXUPLDS];

meminfo_t meminfo[MAXMEMINFO];
  /* The custom advert */
  char* advert[MAXADVERTS];

  /* Time to ban a user
     -1: Disable, normal list operation response
      0: Ignore all list requests silently
    n>0: Ban a user for n minutes should they xdcc list this bot
  */
  int nolistbantime;
  int publictriggers;
  char* humiliate;
  int nospeedwarnings;
  int fullignoretime;
  int noadverts;
  char* prejoin[MAXPREJOIN];
  struct {
    int rotate;
    int interval;
    int maxattempts;
    int badpacktime;
    int bantime;
    char* humiliate;
    struct {
      char *hostmask;
      int first;
      int last;
    } list[MAXBADPACK];
  } badpack;

  /* fields for tracking total sent over x days */

  /*   over the course of <days>, we limit sends to
   *     no more than <max_kbytes>.  We keep track of
   *     amount sent each day in <records>, and when
   *     <next_rotate> is (approximately) now, we drop
   *     oldest day's amount from total - room to move
   *     on day <days> + 1
   */

  // seconds per day
  #define data_limit_increment (60 * 60 * 24)
  struct {
     size_t max_kbytes;  // max we must stay under
     size_t days;        // number of days to track
     time_t next_rotate; // when to rotate records
     size_t *records;    // track amount per day
     char   *stats_file; // save state here
     size_t max_send;    // how much we can send max - sum(records[i])
  } data_limit;

  /*  end of fields for data / day limit */

} gdata_t;


GEX gdata_t gdata;


#endif

/* End of File */
