/*      
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) headers.h 1.46@(#)
 * pmg@alliance.centerclick.org|src/headers.h|20011110162745|06411
 * 
 */

#if !defined _IROFFER_HEADERS
#define _IROFFER_HEADERS

/*------------ includes ------------- */

#ifndef _OS_HPUX
#include <stdio.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <pwd.h>
#include <regex.h>
#include <sys/types.h>
#include <sys/times.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <errno.h>
#include <dirent.h>
#include <stdarg.h>
#include <sys/utsname.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>


#ifdef CRYPT_H
#include <crypt.h>
#endif

#if defined(_OS_SunOS) \
 || defined(_OS_HPUX) \
 || defined(_OS_CYGWIN)
#include <sys/termios.h>
#endif

#if defined(_OS_SunOS) \
 || defined(_OS_HPUX) \
 || defined(_OS_IRIX) \
 || defined(_OS_IRIX64)
#include <strings.h>
#endif


/*------------ snprintf() ------------- */

#ifdef NO_SNPRINTF
#define isnprintf mysnprintf
#define ivsnprintf myvsnprintf
#else
#define isnprintf snprintf
#define ivsnprintf vsnprintf
#endif


/*------------ structures/classes ------------- */

typedef struct {
   char file[maxtextlength],
        desc[maxtextlength],
        note[maxtextlength];
   int gets;
   float minspeed,
         maxspeed;
   size_t size;
   } xdcc;

typedef struct {
   xdcc *xpack;
   char nick[maxtextlengthshort],
        hostname[maxtextlength];
   time_t queuedtime;
   } pqueue;

typedef struct {
   char hostname[maxtextlength];
   short flags;
   long bucket;
   time_t lastcontact;
   } igninfo;

typedef struct {
   int listensocket,
       clientsocket,
       filedescriptor,
       id,needsdata;
   size_t bytessent,
          bytesgot,
          lastack,
          startresume,
          lastspeedamt,
          xdccsent[4];
   time_t lastcontact, connecttime;
   unsigned short listenport, remoteport;
   unsigned long localip, remoteip;
   float lastspeed;
   xdcc *xpack;
   struct sockaddr_in serveraddress;
   char nick[maxtextlengthshort],
        caps_nick[maxtextlengthshort],
        hostname[maxtextlength],
        status,nomin,nomax,reminded;
   /* L = listening */
   /* S = Sending */
   /* W = Done reading, waiting for write buffer to be flushed */
   /* E = read/write error, need to kill this transfer */
   /* D = Done */
   
   } transfer;
   
typedef struct {
   int clientsocket,
       filedescriptor;
   size_t bytesgot,
          totalsize,
          lastspeedamt;
   time_t lastcontact, connecttime;
   unsigned short localport, remoteport;
   unsigned long localip, remoteip;
   float lastspeed;
   char nick[maxtextlengthshort],
        hostname[maxtextlength],
        file[maxtextlength],
        status;
   /* T = trying to connect */
   /* G = Getting */
   /* W = Done writing, waiting to close */
   /* E = read/write error, need to kill this transfer */
   /* D = Done */
   } upload;

typedef enum {
   method_stdin           = 0x01,
   method_dcc             = 0x02,
   method_msg             = 0x04,
   method_xdl_channel     = 0x08,
   method_xdl_user        = 0x10,
   method_out_all         = 0x20,
   method_xdl_channel_min = 0x40,
   method_xdl_channel_sum = 0x80,
   method_xdl_channel_cust= 0x100,
   method_allow_all       = 0x1FF
   } userinput_method_e;

typedef struct {
   userinput_method_e method;
   char *snick, *cmd, *arg1e, *arg2e, *arg1, *arg2, *arg3;
   } userinput;

typedef struct {
   const short help_section;
   const userinput_method_e methods_allowed;
   void (*handler)(const userinput * const);
   const char *command;
   const char *args;
   const char *desc;
   } userinput_parse_t;

typedef struct {
   void *ptr;
   const char *src;
   time_t alloctime;
   short size;
   } meminfo_t;

typedef struct channel_member_t2
{
  struct channel_member_t2 *next;
  char nick[1]; /* actual space is allocated with the struct */
} channel_member_t;

typedef struct {
   char name[maxtextlength];
   char key[maxtextlengthshort];
   short flags, plisttime;
   channel_member_t *members;
} channel_t;

typedef enum {
   how_direct = 1,
   how_bnc,
   how_wingate,
   how_custom
   } how_e;

typedef struct {
   how_e how;
   char host[maxtextlengthshort];
   unsigned short port;
   char password[maxtextlengthshort];
   char vhost[maxtextlength];
   } connectionmethod_t;

typedef struct {
  const char *file;
  const char *func;
  int line;
} context_t;

/*------------ function declerations ------------- */

/* iroffer.cpp */
void sendxdccfile(char* nick, const char* hostname, int pack, char* msg);
void sendaqueue(int type);

/* display.cpp */
void initscreen(void);
void checktermsize(void);
void gototop(void);
void clearbot(void);
void gotobot(void);

/* utilities.cpp */
void msleep(int msec);
int strcmppart (const char *str, const char *match);
int strcmpany (const char *str1, const char *match1);
int strcmpend (const char *str, const char *match);
int simpleformat(char* buffer, const int length, char* format,
		 char* params, ...);
char* getpart(const char *line, int howmany, const char *src);
char* caps(char *text);
char* nocaps(char *text);
char* sizestr(int spaces, char* str, unsigned long num);
int highestsock (void);
void getos(void);
int getend(int amt, int num);
int getbeg(int amt, int num);
int getsrv(int amt, int num);
void floodchk(void);
void outerror(int type, const char *format, ...);
char* getdatestr(char* str, time_t Tp);
void mylog(int beg, const char *format, ...);
void logstat(void);
unsigned long atoul (const char *str);
unsigned long long atoull (const char *str);
void ioutput(int beg, int dest, const char *color, const char *format, ...);
void allchanmsg(const char *message);
void privmsg(const char *nick, const char *format, ...);
void notice(const char *nick, const char *format, ...);
char* hostmasktoregex(char *str);
int verifyadmin(const char *hmask);
int verifypass(const char *testpass);
int packnumtonum(char *a);
int sstrlen (const char *p);
char dayofweektomask(const char a);
void msglog_add(char* hostmask, char* line);
char* msglog_howmany(char *str);
char *strrev(char *str);
int isprintable(char a);
char onlyprintable(char a);
void* mycalloc(int a, const char *r);
void mydeletepart(void *t);
char* removenonprintable(char *str1);
char* removenonprintablefile(char *str);
int doesfileexist(const char *f);
void joinchannel(channel_t *c);
void checkadminpass(void);
void updatecontext(const char *file, const char *func, int line);
void clearmemberlist(channel_t *c);
int isinmemberlist(const char *nick);
void addtomemberlist(channel_t *c, const char *nick);
void removefrommemberlist(channel_t *c, char *nick);
void changeinmemberlist(channel_t *c, char *oldnick, char *newnick);
int set_socket_nonblocking (int s, int nonblock);
void set_loginname(void);
#ifdef NO_SNPRINTF
int mysnprintf(char *str, size_t n, const char *format, ... );
int myvsnprintf(char *str, size_t n, const char *format, va_list ap );
#endif
char capchar(const char c);
double getEngineerval(const double value, const char *engfix, char *res);
int badpackadd(const char* hostmask, int *count);
void badpackrotate(int now);

/* misc.cpp */
/* data limit stuff */
void data_limit_read(void);
void data_limit_save(void);
int set_data_limit(const char *, const char *);
int data_limit_can_send(void);
inline int data_limit_can_send_pack(int);
void data_limit_rotate(void);
#define downcase(c) if ((c) == 'M') (c) = 'm'; \
               else if ((c) == 'G') (c) = 'g';
/* done */
void getconfig (void);
void getconfig_set (const char *line, int rehash);
int connectirc (const char *tserver);
void initirc(void);
#define writeserver(x) writeserver2(x,0)
void writeserver2 (char *msg, int sendt);
void sendserver(void);
void getxdccconfig(const char *filename);
char* getfilename(char * const full);
void pingserver(void);
void xdccsave(int autosave);
void writepidfile (const char *filename);
char* getfline(char* str, int descr, int ret);
void gobackground(void);
void gotcrash(int sig);
void gothup(int sig);
void gotstop(int sig);
void gotserverswitch(int sig);
void gotsigrehash(int sig);
void gotalarm(int sig);
char* getuptime(char *str, int type, time_t fromwhen);
void parsestdin(void);
void shutdowniroffer(int sig);
void switchserver(int which);
char* getstatusline(char *str);
char* getstatuslinenums(char *str);
void sendxdlqueue(void);
int addressedtome(const char *dest);
int isthisforme (const char *dest, char *msg1);
void initvars(void);
void startupiroffer(void);
void isrotatelog(void);
void createpassword(void);
char inttosaltchar (int n);
void notifyqueued(void);
void notifybandwidth(void);
void notifybandwidthtrans(void);
void write_ignorefile(void);
void read_ignorefile(void);
int isbanned(const int i, const char* host);

/* dccchat.cpp */
int setupdccchatout(const char *nick);
void setupdccchataccept(void);
int setupdccchat(const char *line);
void parsedccchat(char* line);
void writedccchat(const char *str);
void writestatus(void);

/* plugins.cpp */
void plugin_initialize (void);
void plugin_everyloop (void);
void plugin_every1sec (void);
void plugin_every20sec (void);
void plugin_ircprivmsg (const char *fullline, const char *nick, const char *hostname,
			const char *dest, const char *msg1, const char *msg2, const char *msg3,
			const char *msg4, const char *msg5);
void plugin_ircinput (const char *fullline, const char *part2, const char *part3, const char *part4);

/* transfer.cpp */
void t_initvalues (transfer * const t);
void t_setuplisten (transfer * const t);
void t_establishcon (transfer * const t);
void t_transfersome (transfer * const t);
void t_readjunk (transfer * const t);
void t_istimeout (transfer * const t);
void t_flushed(transfer * const t);
void t_closeconn(transfer * const t, const char *msg);
void t_setresume(transfer * const t, const char *amt);
void t_remind(transfer * const t);
void t_checkminspeed(transfer * const t);

/* upload.cpp */
void l_initvalues (upload * const l);
void l_establishcon (upload * const l);
void l_transfersome (upload * const l);
void l_istimeout (upload * const l);
void l_closeconn(upload * const l, const char *msg);

/* admin.cpp */
void u_fillwith_stdin(userinput * const u, char *line);
void u_fillwith_dcc(userinput * const u, char *line);
void u_fillwith_msg(userinput * const u, char *n, const char *line);
void u_fillwith_clean(userinput * const u);
int sendAdvert(const char* ch, int force);
void u_parseit(userinput * const u);
int fullignore(const char* nick, const char* hostname);
void ignoreuser(const char* hostname, int bantime);

#endif

/* End of File */
