/*      
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) transfer.c 1.44@(#)
 * pmg@alliance.centerclick.org|src/transfer.c|20011110151512|56636
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"


void t_initvalues (transfer * const t) {

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

      t->status = 'U';
      t->listensocket=1000;
      t->clientsocket=1000;
      t->filedescriptor=1000;
      t->lastcontact = gdata.curtime;
      t->id = 200;   
   }

void t_setuplisten (transfer * const t) {
      int i;
      SIGNEDSOCK int addrlen;
      
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

      if ((t->listensocket = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
         outerror(1,"Could Not Create Socket, Aborting");
         t_closeconn(t,"Connection Error, Try Again");
         return;
         }

      bzero ((char *) &t->serveraddress, sizeof (struct sockaddr_in));
      
      t->serveraddress.sin_family = AF_INET;
      
	  t->serveraddress.sin_addr.s_addr = INADDR_ANY;
	  
	  if (gdata.firewall)
	     t->serveraddress.sin_port = htons(gdata.dccrangestart+t->id);
	  else
	     t->serveraddress.sin_port = htons(0);
      
      i = 0;
      while ( i < 20 ) {
         if ((bind(t->listensocket, (struct sockaddr *)&t->serveraddress, sizeof(struct sockaddr_in))) < 0) {
            i++;
            if (gdata.firewall)
               t->serveraddress.sin_port = htons(gdata.dccrangestart+t->id+i);
            else i = 50;
            }
         else
            i = 50;
         }
      if ( i != 50) {
         outerror(1,"Couldn't Bind to Socket, Aborting");
         t_closeconn(t,"Connection Error, Try Again");
         return;
         }
      
      addrlen = sizeof (struct sockaddr_in);

      if ((getsockname (t->listensocket, (struct sockaddr *)&t->serveraddress, &addrlen)) < 0) {
         outerror(1,"Couldn't get Port Number, Aborting");
         t_closeconn(t,"Connection Error, Try Again");
         return;
         }
      
	  t->listenport = ntohs (t->serveraddress.sin_port);
	  
	  if (listen (t->listensocket, 1) < 0) {
         outerror(1,"Couldn't Listen, Aborting");
         t_closeconn(t,"Connection Error, Try Again");
         return;
         }
	  
	  t->status = 'L';
	  
	  highestsock();
   }

void t_establishcon (transfer * const t) {
   struct sockaddr_in temp1;
   SIGNEDSOCK int addrlen;
   
#if !defined(_OS_SunOS)
   SIGNEDSOCK int tempi;
   int tempc;
#endif
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   addrlen = sizeof (struct sockaddr_in);
   
   if (!gdata.attop) gototop();
   
   if ((t->clientsocket = accept(t->listensocket, (struct sockaddr *) &t->serveraddress, &addrlen)) < 0) {
      outerror(2,"Accept Error, Aborting");
      t_closeconn(t,"Connection Error, Try Again");
      return;
      }
      
   FD_CLR(t->listensocket, &gdata.readset);
   t->status='S';
   close(t->listensocket);
   t->listensocket = 1000;
   highestsock();
   
   if (gdata.debug) {
      ioutput(0,OUT_S,"0;33","clientsock = %d",t->clientsocket);
      }
      
   t->filedescriptor=open(t->xpack->file, O_RDONLY | ADDED_OPEN_FLAGS);
   if (t->filedescriptor < 0) {
      outerror(1,"An Offered File Could Not Be Opened Or Read, Aborting");
      t_closeconn(t,"File Error, Report the Problem to the Owner");
      return;
      }
   
   lseek(t->filedescriptor, t->startresume, SEEK_SET);
   t->bytessent = t->startresume;
   
#if !defined(_OS_SunOS)
   tempi = sizeof(int);
   if (gdata.debug) printf("SO_SNDBUF ");
   getsockopt(t->clientsocket, SOL_SOCKET, SO_SNDBUF, &tempc, &tempi);
   if (gdata.debug) printf(" a %li",(long)tempc);
   
   tempc = 65535;
   setsockopt(t->clientsocket, SOL_SOCKET, SO_SNDBUF, &tempc, sizeof(int));

   if (gdata.debug) printf(" b %li",(long)tempc);
   getsockopt(t->clientsocket, SOL_SOCKET, SO_SNDBUF, &tempc, &tempi);
   if (gdata.debug) printf(" c %li\n",(long)tempc);
#endif
   
#if defined(_OS_BSD_ANY)
   /* #define SO_SNDLOWAT     0x1003     */
   if (gdata.debug) printf("SO_SNDLOWAT ");
   getsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, &tempi);
   if (gdata.debug) printf(" %i",tempc);
      
   tempc = 24577;
   setsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, sizeof(int));
   if (gdata.debug) printf(" %i",tempc);

   getsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, &tempi);
   if (gdata.debug) printf(" %i\n",tempc);
#endif
   
   if (set_socket_nonblocking(t->clientsocket,1) < 0 )
      outerror(2,"Couldn't Set Non-Blocking");
   
   
   t->lastcontact = gdata.curtime;
   t->connecttime = gdata.curtime;
   t->lastspeed = t->xpack->minspeed;
   t->lastspeedamt = t->startresume;
   
   if ((getpeername(t->clientsocket,(struct sockaddr *) &temp1,&(addrlen))) < 0)
      outerror(2,"Couldn't get Remote IP");
   else {
      t->remoteip = ntohl(temp1.sin_addr.s_addr);
      t->remoteport = ntohs(temp1.sin_port);
      }
   
   if ((getsockname(t->clientsocket,(struct sockaddr *) &temp1,&(addrlen))) < 0)
      outerror(2,"Couldn't get Local IP");
   else
      t->localip = ntohl(temp1.sin_addr.s_addr);
   
   ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC [%02i:%s]: Connection established (%ld.%ld.%ld.%ld:%d -> %ld.%ld.%ld.%ld:%d)",
            t->id,t->nick,
            t->remoteip>>24, (t->remoteip>>16) & 0xFF, (t->remoteip>>8) & 0xFF, t->remoteip & 0xFF, t->remoteport,
            t->localip>>24, (t->localip>>16) & 0xFF, (t->localip>>8) & 0xFF, t->localip & 0xFF, t->listenport
            );
   
   
   }

void t_transfersome (transfer * const t) {
   int i, j, j1, howmuch, howmuch2, tbufsize2;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (t->status == 'E') return;
   tbufsize2 = tbufsize;
   
   /* max bandwidth start.... */
   
   j1 = t->xdccsent[0] + t->xdccsent[1] + t->xdccsent[2] + t->xdccsent[3];
   
   if ( !t->nomax && t->xpack->maxspeed > 0 && (j1 >= t->xpack->maxspeed*1024*4)) return; /* over limit */
   
   j = gdata.xdccsent[getend(120,gdata.curtime%120)] 
        + gdata.xdccsent[getend(120,(gdata.curtime%120)-1)]
        + gdata.xdccsent[getend(120,(gdata.curtime%120)-2)]
        + gdata.xdccsent[getend(120,(gdata.curtime%120)-3)];
   
   if ( gdata.maxb && (j >= gdata.maxb*1024)) return; /* over limit */
   
   /* max bandwidth end.... */
   
   /*
    * transfer limit - new limit recently?  make sure sending this
    * block doesn't break it...
    */
   if (gdata.data_limit.max_kbytes != 0) {
      /* limit is set - check if we can send */
      /* we can send as long as BUFFERSIZE < ...data_limit.max_send */
      if (gdata.data_limit.max_send < BUFFERSIZE) {
         /* we can't - this sucks */
         /* notify receiver why we're closing the send */
         t_closeconn(t, "Transfer limit exceeded.");
         return;
      }
   }
   /* done */

   
   howmuch = 1;
   howmuch2 = 1;
   for (i=0; i<tbufsize2; i++) {
      if (howmuch > 0 && howmuch2 > 0) {
         howmuch = read(t->filedescriptor, gdata.sendbuff, BUFFERSIZE);
	 
         if (howmuch < 0 && errno != EAGAIN) { t->status = 'E'; return;}
	 
         howmuch2 = write(t->clientsocket, gdata.sendbuff, howmuch);
         
         if (howmuch2 < 0 && errno != EAGAIN) { t->status = 'E'; return;}
         howmuch2 = max2(0,howmuch2);
         
         if (howmuch2 < howmuch) {
            lseek(t->filedescriptor,howmuch2-howmuch,SEEK_CUR);
            }
         
         if (howmuch2 > 0) t->lastcontact = gdata.curtime;
         
         t->bytessent += howmuch2;
         gdata.xdccsent[gdata.curtime%120] += howmuch2;
         t->xdccsent[gdata.curtime%4] += howmuch2;
         j += howmuch2;
         j1 += howmuch2;
         gdata.totalsent += (unsigned long long)howmuch2;
         /* update record in limit */
         if ((gdata.data_limit.max_kbytes != 0) &&
             (gdata.data_limit.records != NULL)) {
            /* >> 10 + 1 to convert from b to kb, round up */
            gdata.data_limit.records[0] += (size_t) (howmuch2 >> 10) + 1;
            gdata.data_limit.max_send -= (size_t) (howmuch2 >> 10) + 1;
         }
         /* done */
         
         if (gdata.debug2) {
            ioutput(0,OUT_S,"0;34","File %d Write %d",howmuch,howmuch2);
            }
         
         }
      
      /* if over 33% send half to be fair */
      if ( gdata.maxb && ((j*100) > (gdata.maxb*1024*33)) ) tbufsize2 = max2(1,tbufsize/2);
      
      /* if over 66% send one to be fair */
      if ( gdata.maxb && ((j*100) > (gdata.maxb*1024*66)) ) tbufsize2 = 1;
      
      /* if over 100% send one */
      if ( !t->nomax && t->xpack->maxspeed > 0 && (j1 >= t->xpack->maxspeed*1024*4) ) tbufsize2 = 1;
      
      }
   
   if (tbufsize2 == 1)
      gdata.cursendptr = (t->id+1)%MAXTRANS;
   
   if (t->bytessent == t->xpack->size)
     t->status = 'W';
   
   }

void t_readjunk (transfer * const t) {
   int i,j;
   unsigned long g;

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   i = read(t->clientsocket, gdata.sendbuff, BUFFERSIZE);

   if (i) t->lastcontact = gdata.curtime;

   if (gdata.debug2) {
      ioutput(0,OUT_S,"0;34","Read %d",i);
      for (j=0; j<i; j++)
         printf("%2.2X ",gdata.sendbuff[j] & 0x000000FF);
      printf("\n");
      }
   
   if (i == -1) {
      if (!gdata.attop) gototop();
      t_closeconn(t,"Connection Lost");
      }
   
   if (i>0) t->bytesgot += i;
   
   if (i>3 && !((t->bytesgot)%4)) {
      g  = (gdata.sendbuff[i-4] & 0x000000FF) << 24;
      g |= (gdata.sendbuff[i-3] & 0x000000FF) << 16;
      g |= (gdata.sendbuff[i-2] & 0x000000FF) << 8;
      g |= (gdata.sendbuff[i-1] & 0x000000FF);
      t->lastack = g;
      }
   
   }

void t_istimeout (transfer * const t) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if ( XFR_TMOUT && (gdata.curtime - t->lastcontact > 180)) {
      if (!gdata.attop) gototop();
      t_closeconn(t,"DCC Timeout (180 Sec Timeout)");
      }
   }

void t_flushed (transfer * const t) {
   long timetook;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (t->lastack < t->xpack->size) return;
   
   timetook = gdata.curtime - t->connecttime - 1;
   if (timetook < 1)
      timetook = 1;
   
   ioutput(0,OUT_S|OUT_L|OUT_D,"0;33",
        "XDCC [%02i:%s]: Transfer Completed (%li kbytes, %li %s %li %s, %0.1f kbytes/sec)",
        t->id,t->nick,
        (long)(t->xpack->size-t->startresume)/1024,
        (timetook < 3600) ? timetook/60 : timetook/60/60,
        (timetook < 3600) ? "min" : "hr",
        (timetook < 3600) ? timetook%60 : (timetook/60)%60,
        (timetook < 3600) ? "sec" : "min",
        ((flpt)(t->xpack->size-t->startresume))/1024.0/((flpt)timetook)
        );

   notice(t->nick,"*** Transfer Completed (%li kbytes, %li %s %li %s, %0.1f kbytes/sec)",
        (long)(t->xpack->size-t->startresume)/1024,
        (timetook < 3600) ? timetook/60 : timetook/60/60,
        (timetook < 3600) ? "min" : "hr",
        (timetook < 3600) ? timetook%60 : (timetook/60)%60,
        (timetook < 3600) ? "sec" : "min",
        ((flpt)(t->xpack->size-t->startresume))/1024.0/((flpt)timetook)
        );
         
   if ( ((flpt)(t->xpack->size-t->startresume))/1024.0/((flpt)timetook) > gdata.record )
      gdata.record = ((flpt)(t->xpack->size-t->startresume))/1024.0/((flpt)timetook);
         
   if (gdata.debug) {
      ioutput(0,OUT_S,"0;33","clientsock = %d",t->clientsocket);
      }
   FD_CLR(t->clientsocket, &gdata.writeset);
   FD_CLR(t->clientsocket, &gdata.readset);
   close(t->clientsocket);
   close(t->filedescriptor);
   t->status='D';
   t->xpack->gets++;
   highestsock();
   
   }

void t_closeconn(transfer * const t, const char *msg) {
      
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

      ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC [%02i:%s]: Connection closed: %s",t->id,t->nick,msg);
      
      if (gdata.debug) printf("\x1b[0;33mclientsock = %i\x1b[0m\n",t->clientsocket);
      if (t->listensocket != 1000 && t->listensocket > 3) {
         FD_CLR(t->listensocket, &gdata.readset);
         close (t->listensocket);
         }
      if (t->clientsocket != 1000 && t->clientsocket > 3) {
         FD_CLR(t->clientsocket, &gdata.writeset);
         FD_CLR(t->clientsocket, &gdata.readset);
         close(t->clientsocket);
         }
      if (t->filedescriptor != 1000 && t->filedescriptor > 3)
         close(t->filedescriptor);
      t->status='D';
      highestsock();
      
      notice(t->nick,"*** Closing Connection: %s",msg);
   }

void t_setresume(transfer * const t, const char *amt) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   t->startresume = atoi(amt);
   }

void t_remind(transfer * const t) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (gdata.serverstatus == 'C')
     {
       notice(t->nick,"*** You have a DCC pending, Set your client to receive the transfer. "
	      "(%li seconds remaining until timeout)",t->lastcontact+180-gdata.curtime);
     }
   
   t->reminded++;
   }

void t_checkminspeed(transfer * const t) {
   char *tempstr2;

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (t->status != 'S')                             return; /* no checking unless we're sending */
   if (t->connecttime+MIN_TL > gdata.curtime)              return; /* no checking until time has passed */
   if (t->nomin || (t->xpack->minspeed) == 0.0)      return; /* no minspeed for this transfer */
   if ( t->lastspeed+0.11 > t->xpack->minspeed )     return; /* over minspeed */
   
   tempstr2 = mycalloc(maxtextlength,"t_checkminspeed");
   isnprintf(tempstr2,maxtextlength-2,
        "Under Min Speed Requirement, %2.1fK/sec is less than %2.1fK/sec",
         t->lastspeed,t->xpack->minspeed);
   if (!gdata.attop) gototop();
   t_closeconn(t,tempstr2);
   mydelete(tempstr2);
   
   }

/* End of File */

