/*
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) admin.c 1.50@(#)
 * pmg@alliance.centerclick.org|src/admin.c|20011110165238|65154
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"

/* local functions */
static void u_respond(const userinput *u, const char*);

static void u_help(const userinput * const u);
static void u_xdl(const userinput * const u);
static void u_xds(const userinput * const u);
static void u_dcl(const userinput * const u);
static void u_dcld(const userinput * const u);
static void u_qul(const userinput * const u);
static void u_close(const userinput * const u);
static void u_nomin(const userinput * const u);
static void u_nomax(const userinput * const u);
static void u_rmq_rpq(const userinput * const u);
static void u_raw(const userinput * const u);
static void u_redraw(const userinput * const u);
static void u_info(const userinput * const u);
static void u_remove(const userinput * const u);
static void u_send(const userinput * const u);
static void u_psend(const userinput * const u);
static void u_mesg(const userinput * const u);
static void u_mesq(const userinput * const u);
static void u_closedcc(const userinput * const u);
static void u_status(const userinput * const u);
static void u_chfile(const userinput * const u);
static void u_chdesc(const userinput * const u);
static void u_chnote(const userinput * const u);
static void u_chmins(const userinput * const u);
static void u_chmaxs(const userinput * const u);
static void u_add(const userinput * const u);
static void u_adddir(const userinput * const u);
static void u_chatme(const userinput * const u);
static void u_rehash(const userinput * const u);
static void u_botinfo(const userinput * const u);
static void u_ignl(const userinput * const u);
static void u_ignore(const userinput * const u);
static void u_nosave(const userinput * const u);
static void u_nosend(const userinput * const u);
static void u_nolist(const userinput * const u);
static void u_renumber(const userinput * const u);
static void u_msgread(const userinput * const u);
static void u_msgdel(const userinput * const u);
static void u_memstat(const userinput * const u);
static void u_qsend(const userinput * const u);
static void u_shutdown(const userinput * const u);
static void u_debug(const userinput * const u);
static void u_jump(const userinput * const u);
static void u_servers(const userinput * const u);
static void u_trinfo(const userinput * const u);
static void u_listul(const userinput * const u);
static void u_clearrecords(const userinput * const u);
static void u_rmul(const userinput * const u);
static void u_crash(const userinput * const u);
static void u_chanl(const userinput * const u);

static void u_public(const userinput * const u);
static void u_humiliate(const userinput * const u);
static void u_spdwrn(const userinput * const u);

/* local info */
static const userinput_parse_t userinput_parse[] = {
{1,method_allow_all,u_help,     "HELP","<section>","Shows Help on <section>"},
{1,method_allow_all,u_xdl,      "XDL",NULL,"Lists Offered Files"},
{1,method_allow_all,u_xds,      "XDS",NULL,"Save XDCC File"},
{1,method_allow_all,u_dcl,      "DCL",NULL,"Lists Current Transfers"},
{1,method_allow_all,u_dcld,     "DCLD",NULL,"Lists Current Transfers with Details"},
{1,method_allow_all,u_trinfo,   "TRINFO","n","Lists Information About Transfer n"},
{1,method_allow_all,u_qul,      "QUL",NULL,"Lists Current Queue"},
{1,method_allow_all,u_ignl,     "IGNL",NULL,"Show Ignored List"},
{1,method_allow_all,u_listul,   "LISTUL",NULL,"Shows contents of upload directory"},
{1,method_allow_all,u_chanl,    "CHANL",NULL,"Shows channel list with member list"},

{2,method_allow_all,u_close,    "CLOSE","n","Cancels Transfer with ID = n"},
{2,method_allow_all,u_rmq_rpq,  "RMQ","n","Removes Main Queue Number n"},
{2,method_allow_all,u_rmq_rpq,  "RPQ","n","Removes Pack Queue Number n"},
{2,method_allow_all,u_nomin,    "NOMIN","n","Disables Minspeed For Transfer ID n"},
{2,method_allow_all,u_nomax,    "NOMAX","n","Disables Maxspeed For Transfer ID n"},
{2,method_allow_all,u_send,     "SEND","nick n","Sends Pack n to nick"},
{2,method_allow_all,u_psend,    "PSEND","<channel>","Sends XDCC LIST to <channel>"},
{2,method_allow_all,u_qsend,    "QSEND",NULL,"Sends Out The First Queued Pack"},
{2,method_allow_all,u_spdwrn,      "SPDWRN","<+|->","Turn on (+) or off (-) the notices sent to users when bandwidth limits are reached"},
{3,method_allow_all,u_info,     "INFO","n","Show Info for Pack n"},
{3,method_allow_all,u_remove,   "REMOVE","n","Removes Pack n"},
{3,method_allow_all,u_renumber, "RENUMBER","x y","Moves Pack x to y"},
{3,method_allow_all,u_add,      "ADD","<filename>","Add New Pack With <filename>"},
{3,method_allow_all,u_adddir,   "ADDDIR","<dir>","Add Every File in <dir>"},
{3,method_allow_all,u_chfile,   "CHFILE","n <msg>","Change File of pack n to <msg>"},
{3,method_allow_all,u_chdesc,   "CHDESC","n <msg>","Change Description of pack n to <msg>"},
{3,method_allow_all,u_chnote,   "CHNOTE","n <msg>","Change Note of pack n to <msg>"},
{3,method_allow_all,u_chmins,   "CHMINS","n x","Change min speed of pack n to x KB"},
{3,method_allow_all,u_chmaxs,   "CHMAXS","n x","Change max speed of pack n to x KB"},

{4,method_allow_all,u_mesg,     "MESG","<message>","Sends msg to all users who are transferring"},
{4,method_allow_all,u_mesq,     "MESQ","<message>","Sends msg to all users in a queue"},
{4,method_allow_all,u_ignore,   "IGNORE","n [<host>| *<hostmask>]","Ignore <host> (hostname) or any hostname ending in hostmask for n minutes"},
{4,method_allow_all,u_nosave,   "NOSAVE","n","Disables XDCC AutoSave for next n minutes"},
{4,method_allow_all,u_nosend,   "NOSEND","n","Disables XDCC Send for next n minutes"},
{4,method_allow_all,u_nolist,   "NOLIST","n [-q|m]","Disables XDCC List and Plist for next n mins and optionally makes output quiet (-q) or bans any user requesting a list for m minutes"},
{4,method_allow_all,u_msgread,  "MSGREAD",NULL,"Show MSG log"},
{4,method_allow_all,u_msgdel,   "MSGDEL",NULL,"Delete MSG log"},
{4,method_allow_all,u_rmul,     "RMUL","<file>","Delete a file in the Upload Dir"},
{4,method_allow_all,u_raw,      "RAW","<command>","Send <command> to server (RAW IRC)"},
{4,method_allow_all,u_humiliate,      "HUMILIATE","[message]","Will announce this message (%u is replaced with nick and %t is replaced with the ban time) to all channels when user is autobanned by listing server"},
{5,method_allow_all,u_servers,  "SERVERS",NULL,"Shows the server list"},
{5,method_allow_all,u_jump,     "JUMP","<num>","Switches to a random server or server <num>"},
{5,method_allow_all,u_status,   "STATUS",NULL,"Show Useful Information"},
{5,method_allow_all,u_rehash,   "REHASH",NULL,"Re-reads config file(s) and reconfigures"},
{5,method_allow_all,u_botinfo,  "BOTINFO",NULL,"Show Information about the bot status"},
{5,method_allow_all,u_memstat,  "MEMSTAT",NULL,"Show Information about memory usage"},
{5,method_allow_all,u_clearrecords, "CLEARRECORDS",NULL,"Clears transfer, bandwidth, uptime, and total sent"},
{5,method_stdin,    u_redraw,   "REDRAW",NULL,"Redraws the Screen"},
{5,method_dcc,      u_closedcc, "QUIT",NULL,"Close DCC Chat"},
{5,method_msg,      u_chatme,   "CHATME",NULL,"Sends you a DCC Chat Request"},
{5,method_stdin,    u_debug,    "DEBUG","n","Set Debugging to n [0,1,2]"},
{5,method_allow_all,u_shutdown, "SHUTDOWN","<act>","Shutdown iroffer, <act> is \"now\", \"delayed\", or \"cancel\""},
{5,method_allow_all,u_public,      "PUBLIC","<+|->","Turn on (+) or off (-) the ability to resond to public triggers"},

{6,method_stdin,    u_crash, "CRASH",NULL,"Cause a segmentation fault"},
};



void u_fillwith_stdin (userinput * const u, char *line) {
   char* tempstr1 = mycalloc(maxtextlength,"u_fillwith_stdin");
   char* tempstr2 = mycalloc(maxtextlength,"u_fillwith_stdin");
   int i;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (line[strlen(line)-1] == '\n') line[strlen(line)-1] = '\0';
   
   u->method = method_stdin;
   u->snick = NULL;

   u->cmd = caps(getpart(line,1,"u_fillwith_stdin"));
   u->arg1 = getpart(line,2,"u_fillwith_stdin");
   u->arg2 = getpart(line,3,"u_fillwith_stdin");
   u->arg3 = getpart(line,4,"u_fillwith_stdin");
   
   strncpy(tempstr1,"",maxtextlength-1);
   if (u->arg1) {
      strncpy(tempstr1,line,maxtextlength-1);
      for (i=strlen(u->cmd)+1; i<=sstrlen(line); i++)
         tempstr1[i-strlen(u->cmd)-1] = tempstr1[i];
      }
   u->arg1e = tempstr1;
   
   strncpy(tempstr2,"",maxtextlength-1);
   if (u->arg1 && u->arg2) {
      strncpy(tempstr2,line,maxtextlength-1);
      for (i=sstrlen(u->cmd)+sstrlen(u->arg1)+2; i<=sstrlen(line); i++)
         tempstr2[i-strlen(u->cmd)-strlen(u->arg1)-2] = tempstr2[i];
      }
   u->arg2e = tempstr2;
   
   }

void u_fillwith_dcc (userinput * const u, char *line) {
   char* tempstr1 = mycalloc(maxtextlength,"u_fillwith_dcc");
   char* tempstr2 = mycalloc(maxtextlength,"u_fillwith_dcc");
   int i;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (line[strlen(line)-1] == '\n') line[strlen(line)-1] = '\0';
   
   u->method = method_dcc;
   u->snick = NULL;

   u->cmd = caps(getpart(line,1,"u_fillwith_dcc"));
   u->arg1 = getpart(line,2,"u_fillwith_dcc");
   u->arg2 = getpart(line,3,"u_fillwith_dcc");
   u->arg3 = getpart(line,4,"u_fillwith_dcc");
   
   strncpy(tempstr1,"",maxtextlength-1);
   if (u->arg1) {
      strncpy(tempstr1,line,maxtextlength-1);
      for (i=sstrlen(u->cmd)+1; i<=sstrlen(line); i++)
         tempstr1[i-strlen(u->cmd)-1] = tempstr1[i];
      }
   u->arg1e = tempstr1;
   
   strncpy(tempstr2,"",maxtextlength-1);
   if (u->arg1 && u->arg2) {
      strncpy(tempstr2,line,maxtextlength-1);
      for (i=sstrlen(u->cmd)+sstrlen(u->arg1)+2; i<=sstrlen(line); i++)
         tempstr2[i-strlen(u->cmd)-strlen(u->arg1)-2] = tempstr2[i];
      }
   u->arg2e = tempstr2;
   
   }

void u_fillwith_msg (userinput * const u, char* n, const char *line) {
   char* tempstr1 = mycalloc(maxtextlength,"u_fillwith_msg");
   char* tempstr2 = mycalloc(maxtextlength,"u_fillwith_msg");
   char *t1,*t2,*t3,*t4,*t5;
   int i,len;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   u->method = method_msg;
   u->snick = n;
   t1 = getpart(line,1,"u_fillwith_msg"); t2 = getpart(line,2,"u_fillwith_msg");
   t3 = getpart(line,3,"u_fillwith_msg"); t4 = getpart(line,4,"u_fillwith_msg");
   t5 = getpart(line,5,"u_fillwith_msg");
   
   u->cmd = caps(getpart(line,6,"u_fillwith_msg"));
   u->arg1 = getpart(line,7,"u_fillwith_msg");
   u->arg2 = getpart(line,8,"u_fillwith_msg");
   u->arg3 = getpart(line,9,"u_fillwith_msg");
   
   len = strlen(t1) + strlen(t2) + strlen(t3) + strlen(t4) + strlen(t5) +5;
   if (u->cmd) len += strlen(u->cmd);
   
   strncpy(tempstr1,"",maxtextlength-1);
   if (u->arg1) {
      strncpy(tempstr1,line,maxtextlength-1);
      for (i=len+1; i<=sstrlen(line); i++)
         tempstr1[i-len-1] = tempstr1[i];
      }
   u->arg1e = tempstr1;
   
   strncpy(tempstr2,"",maxtextlength-1);
   if (u->arg1 && u->arg2) {
      len += strlen(u->arg1);
      strncpy(tempstr2,line,maxtextlength-1);
      for (i=len+2; i<=sstrlen(line); i++)
         tempstr2[i-len-2] = tempstr2[i];
      }
   u->arg2e = tempstr2;
   
   mydelete(t1);
   mydelete(t2);
   mydelete(t3);
   mydelete(t4);
   mydelete(t5);
   }

void u_fillwith_clean (userinput * const u) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   mydelete(u->cmd);
   mydelete(u->arg1e);
   mydelete(u->arg2e);
   mydelete(u->arg1);
   mydelete(u->arg2);
   mydelete(u->arg3);
   }

static void u_respond(const userinput * const u, const char *a) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   switch (u->method) {
   case method_stdin:
      ioutput(0,OUT_S,NULL,"%s",a);
      break;
   case method_dcc:
      ioutput(0,OUT_D,NULL,"%s",a);
      break;
   case method_msg:
      privmsg(u->snick,"%s",a);
      break;
   case method_xdl_channel:
      privmsg(u->snick,"%s",a);
      break;
   case method_xdl_user:
      notice(u->snick,"%s",a);
      break;
   case method_out_all:
      ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"%s",a);
      break;
   case method_xdl_channel_min:
      privmsg(u->snick,"%s",a);
      break;
   case method_xdl_channel_sum:
   case method_xdl_channel_cust:
      privmsg(u->snick,"%s",a);
      break;
   case method_allow_all:
   default:
      break;
   }
   
   }

void u_parseit(userinput * const u) {
   int i,found = 0;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!u->cmd || !strlen(u->cmd)) {
      u_respond(u,"*** Missing Command, try again");
      u_fillwith_clean(u);
      return;
      }
   
   for (i=0; !found && i<(sizeof(userinput_parse)/sizeof(userinput_parse_t)); i++)
      if ( (!strcmp(userinput_parse[i].command,u->cmd)) &&
           (userinput_parse[i].methods_allowed & u->method) ) {
         found=1;
         userinput_parse[i].handler(u);
         }
   
   if (!found)
      u_respond(u,"*** User Command Not Recognized, try \"HELP\"");
   
   if (found && u->method==method_stdin)
      ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","ADMIN %s Requested (stdin)",u->cmd);
   if (found && u->method==method_dcc)
      ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","ADMIN %s Requested (DCC Chat)",u->cmd);
   if (found && u->method==method_msg)
      ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","ADMIN %s Requested (MSG: %s)",u->cmd,u->snick);
   
   u_fillwith_clean(u);
   
   }

static void u_help(const userinput * const u) {
   int i,which=0;
   char *tempstr, *tempstr2;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1 && strlen(u->arg1)) {
      if (!strcmp(caps(u->arg1),"INFO"))    which=1;
      else if (!strcmp(u->arg1,"TRANSFER")) which=2;
      else if (!strcmp(u->arg1,"PACK"))     which=3;
      else if (!strcmp(u->arg1,"MISC"))     which=4;
      else if (!strcmp(u->arg1,"BOT"))      which=5;
      }
   
   if (!which) {
      u_respond(u,"Usage: \"HELP <section>\"");
      u_respond(u,"Help Sections Available:");
      u_respond(u,"  Info     - help, xdl, xds, dcl, dcld, trinfo, qul, ignl, listul, chanl");
      u_respond(u,"  Transfer - close, rmq, rpq, nomin, nomax, send, psend, qsend, spdwrn");
      u_respond(u,"  Pack     - info, remove, renumber, add, adddir, chfile, chdesc, chnote, chmins, chmaxs");
      u_respond(u,"  Misc     - mesg, mesq, ignore, nosave, nosend, nolist, msgread, msgdel, rmul, raw, public, humiliate");
      u_respond(u,"  Bot      - servers, jump, status, rehash, botinfo, memstat, clearrecords, redraw, quit, chatme, debug, shutdown, public");
      u_respond(u,"For additional help, see the complete documentation at http://iroffer.org/");
      return;
      }
   
   tempstr  = mycalloc(maxtextlength,"u_help");
   tempstr2 = mycalloc(maxtextlengthshort,"u_help");
   
   isnprintf(tempstr,maxtextlength-2,"-- %s Commands (%s) --",
            which==1?"Info":
            which==2?"Transfer":
            which==3?"Pack":
            which==4?"Misc":
            which==5?"Bot":"<Unknown>",
            u->method==method_stdin?"stdin":
            u->method==method_dcc?"dcc":
            u->method==method_msg?"msg":"<Unknown>"
            );
   u_respond(u,tempstr);
   
   for (i=0; i<(sizeof(userinput_parse)/sizeof(userinput_parse_t)); i++)
      if (userinput_parse[i].methods_allowed & u->method &&
          userinput_parse[i].help_section == which) {
         if (userinput_parse[i].args)
            isnprintf(tempstr2,maxtextlengthshort-2,"%s %s",
              userinput_parse[i].command,userinput_parse[i].args);
          else
            isnprintf(tempstr2,maxtextlengthshort-2,"%s",
              userinput_parse[i].command);
         isnprintf(tempstr,maxtextlength-2,"  %-16s - %s",
           tempstr2,userinput_parse[i].desc);
         u_respond(u,tempstr);
         }
   
   u_respond(u,"For additional help, see the complete documentation at http://iroffer.org/");
   
   mydelete(tempstr);
   mydelete(tempstr2);
   }

static void u_xdl(const userinput * const u) {
   char *tempstr,*tempstr2,*tempstr3, *cptr, *nptr;
   const char *spaces[] = { ""," ","  ","   ","    ","     ","      " };
   int a,i,p,m,m1,s,spaceleft,x;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if ((u->method == method_xdl_channel || u->method == method_xdl_channel_min || u->method == method_xdl_channel_sum) && (gdata.nolisting > gdata.curtime)) return;
   
   tempstr = mycalloc(maxtextlength,"u_xdl");

   if ((u->method == method_xdl_user) && (gdata.nolisting > gdata.curtime)) {
      isnprintf(tempstr,maxtextlength-2,
            "The Owner Has Requested That No Lists Be Sent In The Next %li Minute%s",
            1+(gdata.nolisting-gdata.curtime)/60,((1+(gdata.nolisting-gdata.curtime)/60)!=1?"s":""));
      u_respond(u,tempstr);
      mydelete(tempstr);
      return;
      }

   tempstr2 = mycalloc(maxtextlength,"u_xdl");
   tempstr3 = mycalloc(maxtextlengthshort,"u_xdl");

   if (u->method==method_xdl_channel_cust)
     {
       /* We are in a loop to display the formated stuff from the advert definition string */
       for (a=0;a<MAXADVERTS && gdata.advert[a]!=NULL;a++)
	 {
	   memset(tempstr,0,maxtextlength);
	   i=0;
	   cptr=gdata.advert[a];
	   nptr=tempstr;
	   /* All strings will be null terminated.
	      We must ensure we do no outstretch ourselves and write more than maxtextlength
	      to the tempstring
	   */
	   spaceleft=maxtextlength-2;
	   while (spaceleft>0)
	     switch (*cptr)
	       {
	       case 0:
		 spaceleft=0;
		 break;
	       case '%':
		 cptr++;tempstr2[0]=0;
		 switch(capchar(*(cptr++)))
		   {
		   case 'A': /* Number of slots in use */
		     isnprintf(tempstr2, maxtextlength-1, "%i", gdata.slotsfull);
		     break;
		   case 'B': /* Totle slots */
		     isnprintf(tempstr2, maxtextlength-1, "%i", gdata.slotsmax);
		     break;
		   case 'C': /* Number in queue */
		     isnprintf(tempstr2, maxtextlength-1, "%i", gdata.inqueue);		     
		     break;
		   case 'D': /* Size of queue */
		     isnprintf(tempstr2, maxtextlength-1, "%i", gdata.queuesize);
		     break;
		   case 'E': /* number in packs queue */
		     isnprintf(tempstr2, maxtextlength-1, "%i", gdata.inslotsmaxqueue);
		     break;
		   case 'F': /* size of pack queue */
		     isnprintf(tempstr2, maxtextlength-1, "%i", gdata.slotsmaxqueue);
		     break;
		   case 'G': /* pack speed record */
		     isnprintf(tempstr2,maxtextlength-1, "%1.1fK/s", gdata.record);
		     break;
		   case 'H': /* number of lines in send to server queue*/
		     {
		       int srvq;
		       for (srvq=0; gdata.serverq[srvq] && srvq<MAXSENDQ; srvq++);
		       isnprintf(tempstr2, maxtextlength-1, "%i", srvq);
		     }
		     break;
		   case 'I': /* ammount of data send to network in last 120 seconds*/
		     {
		       int count=0;
		       for (i=0; i<120; i++)
			 count += gdata.xdccsent[i];
		       isnprintf(tempstr2, maxtextlength-1, "%i", count/1024);
		     }
		     break;
		   case 'J': /* Average bandwidth in last 120 seconds */
		     {
		       int count=0;
		       for (i=0; i<120; i++)
			 count += gdata.xdccsent[i];
		       isnprintf(tempstr2, maxtextlength-1, "%1.1fK/s", ((float)count)/120.0/1024.0);
		     }
		     break;
		   case 'K': /* record average bandwidth */
		     isnprintf(tempstr2,maxtextlength-1, "%1.1fK/s", gdata.sentrecord);
		     break;
		   case 'L': /* minimum required bandwidth */
		     isnprintf(tempstr2,maxtextlength,"%1.1fK/s",gdata.overallminspeed);
		     break;
		   case 'W': /* packs offered */
		     isnprintf(tempstr2,maxtextlength,"%i",gdata.numpacks);
		     break;
		   case 'X': /* total size of packs offered */
		     {
		       float ocount = 0;
		       for (i=0; i<MAXXDCCS; i++)
			 if (gdata.xdccs[i])
			   ocount += (float)gdata.xdccs[i]->size;
		       isnprintf(tempstr2,maxtextlength-1,"%1.1f MB",ocount/1024.0/1024.0);
		     }
		     break;
		   case 'Y': /* total completed transfers */
		     {
		       int gcount=0;
		       for (i=0; i<MAXXDCCS; i++)
			 if (gdata.xdccs[i])
			   gcount += gdata.xdccs[i]->gets;
		       isnprintf(tempstr2, maxtextlength-1,"%i",gcount);
		     }
		     break;
		   case 'Z': /* total transfered MB*/
		     {
		       char postfix;
		       float totsent=getEngineerval(gdata.totalsent/1024.0/1024.0,
						    "MGT\0",
						    &postfix);
		       
		       isnprintf(tempstr2,maxtextlength-1,"%1.2f %cB",totsent,postfix);
		     }
		     break;
		   default:
		     cptr--;
		   case '%':
		     tempstr2[0]='%';
		     tempstr2[1]=0;
		     break;
		   }
		 isnprintf(nptr,spaceleft,"%s",tempstr2);
		 spaceleft-=x=strlen(tempstr2);
		 nptr+=x;
		 break;		 
	       default:
		 spaceleft--;
		 *(nptr++)=*(cptr++);
	       }
	   /*	   if (tempstr[0]!=0)*/
	     u_respond(u,tempstr);
	 }
      mydelete(tempstr);
      mydelete(tempstr2);
      mydelete(tempstr3);
      return;
     }
   

   if (u->method==method_xdl_channel_min) m = 1; else m = 0;
   if (u->method==method_xdl_channel_sum) m1 = 1; else m1 = 0;
   
   if (!m && !m1) {
      if (gdata.slotsmax-gdata.slotsfull < 0) a = gdata.slotsfull;
      else a = gdata.slotsmax;
      
      isnprintf(tempstr,maxtextlength-2,
          "\2**\2 %i pack%s \2**\2  %i of %i slot%s open",
          gdata.numpacks,gdata.numpacks!=1?"s":"",a-gdata.slotsfull,a,a!=1?"s":"");
      if (gdata.slotsmax <= gdata.slotsfull) {
         isnprintf(tempstr2,maxtextlength-2,"%s, Queue: %i/%i",tempstr,gdata.inqueue,gdata.queuesize);
         strncpy(tempstr,tempstr2,maxtextlength-1);
         }
      if (gdata.overallminspeed > 0) {
         isnprintf(tempstr2,maxtextlength-2,"%s, Min: %1.1fKB/s",tempstr,gdata.overallminspeed);
         strncpy(tempstr,tempstr2,maxtextlength-1);
         }
      if (gdata.transfermaxspeed > 0) {
         isnprintf(tempstr2,maxtextlength-2,"%s, Max: %1.1fKB/s",tempstr,gdata.transfermaxspeed);
         strncpy(tempstr,tempstr2,maxtextlength-1);
         }
      if (gdata.record > 0.5) {
         isnprintf(tempstr2,maxtextlength-2,"%s, Record: %1.1fKB/s",tempstr,gdata.record);
         strncpy(tempstr,tempstr2,maxtextlength-1);
         }
      u_respond(u,tempstr);
      
      for (i=0,a=0; i<120; i++)
         a += gdata.xdccsent[i];
      isnprintf(tempstr,maxtextlength-2,
          "\2**\2 Bandwidth Usage \2**\2 Current: %1.1fKB/s,",((float)a)/120.0/1024.0);
      if (gdata.maxb) {
         isnprintf(tempstr2,maxtextlength-2,"%s Cap: %i.0KB/s,",tempstr,gdata.maxb/4);
         strncpy(tempstr,tempstr2,maxtextlength-1);
         }
      if (gdata.sentrecord > 0.5) {
         isnprintf(tempstr2,maxtextlength-2,"%s Record: %1.1fKB/s",tempstr,gdata.sentrecord);
         strncpy(tempstr,tempstr2,maxtextlength-1);
         }
      u_respond(u,tempstr);
   
   
      isnprintf(tempstr,maxtextlength-2,
          "\2**\2 To request a file type: \"/msg %s xdcc send #x\" \2**\2",gdata.user_nick);
      u_respond(u,tempstr);
      }
   
   if (m1) {
      isnprintf(tempstr,maxtextlength-2,
          "\2**\2 For a listing type: \"/msg %s xdcc list\" \2**\2",gdata.user_nick);
      u_respond(u,tempstr);
      
      if (gdata.creditline)
	{
	  isnprintf(tempstr,maxtextlength-2,"\2**\2 %s \2**\2",gdata.creditline);
	  u_respond(u,tempstr);
	}
      
      mydelete(tempstr);
      mydelete(tempstr2);
      mydelete(tempstr3);
      return;
      }
   
   s = 0;
   for (i=1, p=0; i<=gdata.numpacks; i++, p++) {
      while (gdata.xdccs[p] == NULL)
         p++;
      if (p>(MAXXDCCS-1))
         break;
      s = max2(s,gdata.xdccs[p]->gets);
      }
   i = s; s = 5;
   if (i < 10000) s = 4;
   if (i < 1000) s = 3;
   if (i < 100) s = 2;
   if (i < 10) s = 1;
   isnprintf(tempstr3,maxtextlengthshort-2,"\2#%%-2i\2 %%%iix [%%s] %%s",s);
   
   for (i=1, p=0; i<=gdata.numpacks; i++, p++) {
      while (gdata.xdccs[p] == NULL)
         p++;
      if (p>(MAXXDCCS-1))
         break;
      
      isnprintf(tempstr,maxtextlength-2,
         tempstr3,
         i,
         gdata.xdccs[p]->gets,
         sizestr(1,tempstr2,gdata.xdccs[p]->size),
         gdata.xdccs[p]->desc);
      
      if (gdata.xdccs[p]->minspeed > 0 && gdata.xdccs[p]->minspeed != gdata.overallminspeed) {
         isnprintf(tempstr2,maxtextlength-2,"%s [%1.1fK Min]",tempstr,gdata.xdccs[p]->minspeed);
         strncpy(tempstr,tempstr2,maxtextlength-1);
         }
      
      if (gdata.xdccs[p]->maxspeed > 0 && gdata.xdccs[p]->maxspeed != gdata.transfermaxspeed) {
         isnprintf(tempstr2,maxtextlength-2,"%s [%1.1fK Max]",tempstr,gdata.xdccs[p]->maxspeed);
         strncpy(tempstr,tempstr2,maxtextlength-1);
         }
      
      u_respond(u,tempstr);
      
      if (gdata.xdccs[p]->note && strlen(gdata.xdccs[p]->note)) {
         isnprintf(tempstr,maxtextlength-2," \2^-\2%s%s",spaces[s],gdata.xdccs[p]->note);
         u_respond(u,tempstr);
         }
      
      if (i == gdata.slotsmaxpack && gdata.inslotsmaxqueue) {
         isnprintf(tempstr,maxtextlength-2," \2^-\2%sPack %i Has Slot Queue: %i/%i",
            spaces[s],i,gdata.inslotsmaxqueue,gdata.slotsmaxqueue);
         u_respond(u,tempstr);
         }
      }
   
   if (gdata.creditline) {
      isnprintf(tempstr,maxtextlength-2,"\2**\2 %s \2**\2",gdata.creditline);
      u_respond(u,tempstr);
      }
   
   if (!m) {
      float toffered = 0;
   
      for (i=0; i<MAXXDCCS; i++)
         if (gdata.xdccs[i])
            toffered += (float)gdata.xdccs[i]->size;
   
      isnprintf(tempstr,maxtextlength-2,
         "Total Offered: %1.1f MB  Total Transferred: %1.2f %cB",
         toffered/1024.0/1024.0,
         (gdata.totalsent/1024/1024) > 1024 ? ( (gdata.totalsent/1024/1024/1024) > 1024 ? ((float)gdata.totalsent)/1024/1024/1024/1024 : ((float)gdata.totalsent)/1024/1024/1024 ) : ((float)gdata.totalsent)/1024/1024 ,
         (gdata.totalsent/1024/1024) > 1024 ? ( (gdata.totalsent/1024/1024/1024) > 1024 ? 'T' : 'G' ) : 'M'
         );
      u_respond(u,tempstr);
      }
   
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(tempstr3);
   }

static void u_xds(const userinput * const u) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   xdccsave(0);
   }

static void u_dcl(const userinput * const u) {
   char *tempstr;
   const char *y;
   int i,j;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   for (j=i=0; i<MAXUPLDS; i++)
      if (gdata.uploads[i] != NULL) j++;

   if (!gdata.slotsfull && !j) {
      u_respond(u,"No Active Transfers");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_dcl");

   isnprintf(tempstr,maxtextlength-2,"Current Transfer%s",gdata.slotsfull!=1?"s":"");
   u_respond(u,tempstr);
   u_respond(u,"   ID  User        File                               Status");
   
   for (i=0; i<MAXTRANS; i++)
      if (gdata.trans[i] != NULL) {
         
         if (gdata.trans[i]->status == 'L') y = "Listening";
         else if (gdata.trans[i]->status == 'W') y = "Finishing";
         else if (gdata.trans[i]->status == 'D') y = "Closing";
         else if (gdata.trans[i]->status == 'E') y = "Error";
         else if (gdata.trans[i]->status == 'S') y = "Sending";
         else y = "Unknown!";
         
         if (gdata.trans[i]->status == 'S') {
            isnprintf(tempstr,maxtextlength-2,"   %2i  %-9s   %-32s   %s %2.0f%%",
               i,gdata.trans[i]->nick,getfilename(gdata.trans[i]->xpack->file),y,
               ((float)gdata.trans[i]->bytessent)*100.0/((float)gdata.trans[i]->xpack->size));
            }
         else
            isnprintf(tempstr,maxtextlength-2,"   %2i  %-9s   %-32s   %s",
               i,gdata.trans[i]->nick,getfilename(gdata.trans[i]->xpack->file),y);
         
         u_respond(u,tempstr);
         
         }
   
   for (i=0; i<MAXUPLDS; i++)
      if (gdata.uploads[i] != NULL) {
         
         if (gdata.uploads[i]->status == 'T') y = "Connecting";
         else if (gdata.uploads[i]->status == 'G') y = "Getting";
         else if (gdata.uploads[i]->status == 'W') y = "Finishing";
         else if (gdata.uploads[i]->status == 'E') y = "Error";
         else if (gdata.uploads[i]->status == 'D') y = "Done";
         else y = "Unknown!";
         
         if (gdata.uploads[i]->status == 'G') {
            isnprintf(tempstr,maxtextlength-2,"   Ul  %-9s   %-32s   %s %2.0f%%",
               gdata.uploads[i]->nick,getfilename(gdata.uploads[i]->file),y,
               ((float)gdata.uploads[i]->bytesgot)*100.0/((float)gdata.uploads[i]->totalsize));
            }
         else
            isnprintf(tempstr,maxtextlength-2,"   Ul  %-9s   %-32s   %s",
               gdata.uploads[i]->nick,getfilename(gdata.uploads[i]->file),y);
         
         u_respond(u,tempstr);
         
         }
   
   mydelete(tempstr);
   }

static void u_dcld(const userinput * const u) {
   char *tempstr, *tempstr2, *tempstr3, *tempstr4;
   const char *y;
   int i,j,left,started;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   for (j=i=0; i<MAXUPLDS; i++)
      if (gdata.uploads[i] != NULL) j++;

   if (!gdata.slotsfull && !j) {
      u_respond(u,"No Active Transfers");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_dcld");
   tempstr2 = mycalloc(maxtextlength,"u_dcld");
   tempstr3 = mycalloc(maxtextlengthshort,"u_dcld");
   tempstr4 = mycalloc(maxtextlengthshort,"u_dcld");

   isnprintf(tempstr,maxtextlength-2,"Current Transfer%s",gdata.slotsfull!=1?"s":"");
   u_respond(u,tempstr);
   u_respond(u," ID  User        File                               Status");
   u_respond(u,"  ^-    Speed    Current/    End   Start/Remain    Min/  Max  Resumed");
   u_respond(u," --------------------------------------------------------------------");
   
   for (i=0; i<MAXTRANS; i++)
      if (gdata.trans[i] != NULL) {
         
         if (gdata.trans[i]->status == 'L') y = "Listening";
         else if (gdata.trans[i]->status == 'W') y = "Finishing";
         else if (gdata.trans[i]->status == 'D') y = "Closing";
         else if (gdata.trans[i]->status == 'E') y = "Error";
         else if (gdata.trans[i]->status == 'S') y = "Sending";
         else y = "Unknown!";
         
         if (gdata.trans[i]->status == 'S') {
            isnprintf(tempstr,maxtextlength-2," %2i  %-9s   %-32s   %s %2.0f%%",
               i,gdata.trans[i]->nick,getfilename(gdata.trans[i]->xpack->file),y,
               ((float)gdata.trans[i]->bytessent)*100.0/((float)gdata.trans[i]->xpack->size));
            }
         else
            isnprintf(tempstr,maxtextlength-2," %2i  %-9s   %-32s   %s",
               i,gdata.trans[i]->nick,getfilename(gdata.trans[i]->xpack->file),y);
         
         u_respond(u,tempstr);
         
         if (gdata.trans[i]->status == 'S' || gdata.trans[i]->status == 'W') {
            left = min2(359999,(gdata.trans[i]->xpack->size-gdata.trans[i]->bytessent)/((int)(max2(gdata.trans[i]->lastspeed,0.001)*1024)));
            started = min2(359999,gdata.curtime-gdata.trans[i]->connecttime);
            isnprintf(tempstr2,maxtextlength-2,"%1.1fK",gdata.trans[i]->xpack->minspeed);
            isnprintf(tempstr3,maxtextlengthshort-2,"%6liK",(long)(gdata.trans[i]->startresume)/1024);
            isnprintf(tempstr4,maxtextlengthshort-2,"%1.1fK",gdata.trans[i]->xpack->maxspeed);
            
            isnprintf(tempstr,maxtextlength-2,
                "  ^- %5.1fK/s %c  %6liK/%6liK  %2i%c%02i%c/%2i%c%02i%c  %5s/%5s  %7s",
                gdata.trans[i]->lastspeed,
                gdata.trans[i]->needsdata > 0 ? 'L' : ' ' ,
                (long)((gdata.trans[i]->bytessent)/1024),
                (long)((gdata.trans[i]->xpack->size)/1024),
                started < 3600 ? started/60 : started/60/60 ,
                started < 3600 ? 'm' : 'h',
                started < 3600 ? started%60 : (started/60)%60 ,
                started < 3600 ? 's' : 'm',
                left < 3600 ? left/60 : left/60/60 ,
                left < 3600 ? 'm' : 'h',
                left < 3600 ? left%60 : (left/60)%60 ,
                left < 3600 ? 's' : 'm',
                (gdata.trans[i]->nomin || (gdata.trans[i]->xpack->minspeed == 0.0)) ? "no" : tempstr2 ,
                (gdata.trans[i]->nomax || (gdata.trans[i]->xpack->maxspeed == 0.0)) ? "no" : tempstr4 ,
                gdata.trans[i]->startresume ? tempstr3 : "no"
                );
            u_respond(u,tempstr);
            }
         else {
            isnprintf(tempstr,maxtextlength-2,
                "  ^-    -----    -------/-------   -----/------  -----/-----      ---");
            u_respond(u,tempstr);
            }
         }
   
   for (i=0; i<MAXUPLDS; i++)
      if (gdata.uploads[i] != NULL) {
         
         if (gdata.uploads[i]->status == 'T') y = "Connecting";
         else if (gdata.uploads[i]->status == 'G') y = "Getting";
         else if (gdata.uploads[i]->status == 'W') y = "Finishing";
         else if (gdata.uploads[i]->status == 'E') y = "Error";
         else if (gdata.uploads[i]->status == 'D') y = "Done";
         else y = "Unknown!";
         
         if (gdata.uploads[i]->status == 'G') {
            isnprintf(tempstr,maxtextlength-2," Ul  %-9s   %-32s   %s %2.0f%%",
               gdata.uploads[i]->nick,getfilename(gdata.uploads[i]->file),y,
               ((float)gdata.uploads[i]->bytesgot)*100.0/((float)gdata.uploads[i]->totalsize));
            }
         else
            isnprintf(tempstr,maxtextlength-2," Ul  %-9s   %-32s   %s",
               gdata.uploads[i]->nick,getfilename(gdata.uploads[i]->file),y);
         
         u_respond(u,tempstr);
         
         if (gdata.uploads[i]->status == 'G' || gdata.uploads[i]->status == 'W') {
            left = min2(359999,(gdata.uploads[i]->totalsize-gdata.uploads[i]->bytesgot)/((int)(max2(gdata.uploads[i]->lastspeed,0.001)*1024)));
            started = min2(359999,gdata.curtime-gdata.uploads[i]->connecttime);
            
            isnprintf(tempstr,maxtextlength-2,
                "  ^- %5.1fK/s    %6liK/%6liK  %2i%c%02i%c/%2i%c%02i%c  -----/-----      ---",
                gdata.uploads[i]->lastspeed,
                (long)((gdata.uploads[i]->bytesgot)/1024),
                (long)((gdata.uploads[i]->totalsize)/1024),
                started < 3600 ? started/60 : started/60/60 ,
                started < 3600 ? 'm' : 'h',
                started < 3600 ? started%60 : (started/60)%60 ,
                started < 3600 ? 's' : 'm',
                left < 3600 ? left/60 : left/60/60 ,
                left < 3600 ? 'm' : 'h',
                left < 3600 ? left%60 : (left/60)%60 ,
                left < 3600 ? 's' : 'm'
                );
            u_respond(u,tempstr);
            }
         else {
            isnprintf(tempstr,maxtextlength-2,
                "  ^-    -----    -------/-------   -----/------  -----/-----      ---");
            u_respond(u,tempstr);
            }
         
         }
      
   u_respond(u," --------------------------------------------------------------------");
   
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(tempstr3);
   mydelete(tempstr4);
   }

static void u_qul(const userinput * const u) {
   char *tempstr;
   int i, j;
   unsigned long rtime, lastrtime; 
  
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!gdata.inqueue && !gdata.inslotsmaxqueue) {
      u_respond(u,"No Users Queued");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_qul");
   
   u_respond(u,"Current Queue:");
   u_respond(u,"    #Q  User        File                              Waiting     Left");
   
   lastrtime=0;
   
   /* if we are sending more than allowed, we need to skip the difference */
   for (i=0; i<gdata.slotsfull-gdata.slotsmax; i++)
     {
       rtime=-1;
       for (j=0; j<MAXTRANS; j++)
	 if (gdata.trans[j]) {
	   int left = min2(359999,(gdata.trans[j]->xpack->size-gdata.trans[j]->bytessent)/((int)(max2(gdata.trans[j]->lastspeed,0.001)*1024)));
	   if (left > lastrtime && left < rtime)
	     rtime = left;
	 }
       if (rtime < 359999)
	 lastrtime=rtime;
     }
   
   for (i=1; i<=gdata.inqueue; i++) {
     
     rtime=-1;
     for (j=0; j<MAXTRANS; j++)
       if (gdata.trans[j]) {
	 int left = min2(359999,(gdata.trans[j]->xpack->size-gdata.trans[j]->bytessent)/((int)(max2(gdata.trans[j]->lastspeed,0.001)*1024)));
	 if (left > lastrtime && left < rtime)
	   rtime = left;
       }
     lastrtime=rtime;
     
     if (rtime < 359999)
      isnprintf(tempstr,maxtextlength-2,"   %2iM  %-9s   %-32s   %2lih%2lim   %2lih%2lim",
         i,
         gdata.mainqueue[i-1]->nick,
         getfilename(gdata.mainqueue[i-1]->xpack->file),
         (gdata.curtime-gdata.mainqueue[i-1]->queuedtime)/60/60,
         ((gdata.curtime-gdata.mainqueue[i-1]->queuedtime)/60)%60,
         rtime/60/60,
         (rtime/60)%60);
     else
      isnprintf(tempstr,maxtextlength-2,"   %2iM  %-9s   %-32s   %2lih%2lim  Unknown",
         i,
         gdata.mainqueue[i-1]->nick,
         getfilename(gdata.mainqueue[i-1]->xpack->file),
         (gdata.curtime-gdata.mainqueue[i-1]->queuedtime)/60/60,
         ((gdata.curtime-gdata.mainqueue[i-1]->queuedtime)/60)%60);


      u_respond(u,tempstr);
      }
   
   for (i=1; i<=gdata.inslotsmaxqueue; i++) {
      isnprintf(tempstr,maxtextlength-2,"   %2iP  %-9s   %-32s   %2lih%2lim",
         i,
         gdata.packqueue[i-1]->nick,
         getfilename(gdata.packqueue[i-1]->xpack->file),
         (gdata.curtime-gdata.packqueue[i-1]->queuedtime)/60/60,
         ((gdata.curtime-gdata.packqueue[i-1]->queuedtime)/60)%60);
      u_respond(u,tempstr);
      }
   
   mydelete(tempstr);
   
   }

static void u_close(const userinput * const u) {
   
   int num = -1;
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   
   if (num > MAXTRANS-1 || num < 0 || gdata.trans[num] == NULL)
      u_respond(u,"Invalid ID number, Try \"DCL\" for a list");
   else
      t_closeconn(gdata.trans[num],"Owner Requested Close");
   
   }

static void u_nomin(const userinput * const u) {
   
   int num = -1;
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   
   if (num > MAXTRANS-1 || num < 0 || gdata.trans[num] == NULL)
      u_respond(u,"Invalid ID number, Try \"DCL\" for a list");
   else
      gdata.trans[num]->nomin = 1;
   
   }

static void u_nomax(const userinput * const u) {
   
   int num = -1;
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   
   if (num > MAXTRANS-1 || num < 0 || gdata.trans[num] == NULL)
      u_respond(u,"Invalid ID number, Try \"DCL\" for a list");
   else
      gdata.trans[num]->nomax = 1;
   
   }

static void u_rmq_rpq(const userinput * const u) {
   int i;
   int num = 0;
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   
   if (u->cmd[1] == 'M') {
      if ( (num > MAXQUEUE) || (num < 1) || gdata.mainqueue[num-1] == NULL )
         u_respond(u,"Invalid ID number, Try \"QUL\" for a list");
      else {
         notice(gdata.mainqueue[num-1]->nick,"*** Removed From Queue: Owner Requested Remove");
         mydelete(gdata.mainqueue[num-1]);
         for (i=num; i<gdata.inqueue; i++)
            gdata.mainqueue[i-1] = gdata.mainqueue[i];
         gdata.mainqueue[i] = NULL;
         gdata.inqueue--;
         }
      }
   else if (u->cmd[1] == 'P') {
      if ( (num > MAXQUEUE) || (num < 1) || gdata.packqueue[num-1] == NULL )
         u_respond(u,"Invalid ID number, Try \"QUL\" for a list");
      else {
         notice(gdata.packqueue[num-1]->nick,"*** Removed From Queue: Owner Requested Remove");
         mydelete(gdata.packqueue[num-1]);
         for (i=num; i<gdata.inslotsmaxqueue; i++)
            gdata.packqueue[i-1] = gdata.packqueue[i];
         gdata.packqueue[i] = NULL;
         gdata.inslotsmaxqueue--;
         }
      }
   else {
      u_respond(u,"internal iroffer error: u_rmq_rpq(): unexpected case, report problem to PMG");
      }
   
   }

static void u_raw(const userinput * const u) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   writeserver(u->arg1e);
   }

static void u_info(const userinput * const u) {
   int num = 0;
   int i,p;
   char *tempstr, *tempstr2;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   
   if (num < 1 || num > gdata.numpacks) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   for (i=1, p=0; i<=gdata.numpacks; i++, p++) {
      while (gdata.xdccs[p] == NULL)
         p++;
      if ( i == num )
         break;
      }
   
   tempstr = mycalloc(maxtextlength,"u_info");
   tempstr2 = mycalloc(maxtextlength,"u_info");
   
   isnprintf(tempstr,maxtextlength-2,"Pack Info for Pack #%i:",num);
   u_respond(u,tempstr);
   
   isnprintf(tempstr,maxtextlength-2,"Gets: %i, Size: %s (%li), Min: %1.1fK/sec, Max: %1.1fK/sec, Xfered: >%liM",
                gdata.xdccs[p]->gets,
                sizestr(1,tempstr2,gdata.xdccs[p]->size),
                (long)gdata.xdccs[p]->size,
                gdata.xdccs[p]->minspeed,
                gdata.xdccs[p]->maxspeed,
	        (long)(((double)gdata.xdccs[p]->gets)*((double)gdata.xdccs[p]->size)/1024.0/1024.0));
   u_respond(u,tempstr);
   isnprintf(tempstr,maxtextlength-2,"Filename:    %s",gdata.xdccs[p]->file);
   u_respond(u,tempstr);
   isnprintf(tempstr,maxtextlength-2,"Description: %s",gdata.xdccs[p]->desc);
   u_respond(u,tempstr);
   isnprintf(tempstr,maxtextlength-2,"Note:        %s",gdata.xdccs[p]->note);
   u_respond(u,tempstr);
   
   
   mydelete(tempstr);
   mydelete(tempstr2);
   }

static void u_remove(const userinput * const u) {
   int i,p;
   int num = 0;
   char *tempstr;
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   
   if ( num < 1 || num > gdata.numpacks ) {
      u_respond(u,"Try a valid pack number");
      return;
      }
/*   if ( gdata.numpacks == 1 ) { */
/*      u_respond(u,"You must offer at least one pack"); */
/*      return; */
/*      } */
   
   tempstr = mycalloc(maxtextlength,"u_remove");
   
   for (i=1, p=0; i<=gdata.numpacks; i++, p++) {
      while (gdata.xdccs[p] == NULL)
         p++;
      if ( i == num )
         break;
      }
   
   isnprintf(tempstr,maxtextlength-2,"Removed Pack %i [%s]",
      num,gdata.xdccs[p]->desc);
   u_respond(u,tempstr);
   
   /* removed pack is leaked for now */
   for (i=p+1; i<=gdata.numpacks; i++)
      gdata.xdccs[i-1] = gdata.xdccs[i];
   
   gdata.numpacks--;
   xdccsave(0);
   
   mydelete(tempstr);
   }

static void u_redraw(const userinput * const u) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   initscreen();
   gotobot();
   }

static void u_send(const userinput * const u) {
   int num = 0;
   char *tempstr;
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg2) num = atoi(u->arg2);
   
   if (!u->arg1 || !strlen(u->arg1)) {
      u_respond(u,"Try Specifying a Nick");
      return;
      }
   
   if (num > gdata.numpacks || num < 1) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_send");
   
   isnprintf(tempstr,maxtextlength-2,"Sending %s pack %i",u->arg1,num);
   u_respond(u,tempstr);
   
   sendxdccfile(u->arg1,"man",num,NULL);
   
   mydelete(tempstr);
   }

static void u_psend(const userinput * const u) {
   char *tempstr;
   userinput manplist;
  
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!u->arg1 || !strlen(u->arg1)) {
      u_respond(u,"Try Specifying a Channel");
      return;
      }
   
   u_fillwith_msg(&manplist,u->arg1,"A A A A A xdl");
   manplist.method = method_xdl_channel;
   u_parseit(&manplist);
   
   tempstr = mycalloc(maxtextlength,"u_psend");
   isnprintf(tempstr,maxtextlength-2,"Sending PLIST to %s",u->arg1);
   mydelete(tempstr);
   
   }

static void u_mesg(const userinput * const u) {
   int i;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!u->arg1e || !strlen(u->arg1e)) {
      u_respond(u,"Try Specifying a Message");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_mesg");
   for (i=0; i<MAXTRANS; i++)
      if (gdata.trans[i] != NULL) {
      notice(gdata.trans[i]->nick,"MESSAGE FROM OWNER: %s",u->arg1e);
      }
   isnprintf(tempstr,maxtextlength-2,"Sent message to %i user%s",gdata.slotsfull,gdata.slotsfull!=1?"s":"");
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   }

static void u_mesq(const userinput * const u) {
   int i,count;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!u->arg1e || !strlen(u->arg1e)) {
      u_respond(u,"Try Specifying a Message");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_mesq");

   count=0;
   for (i=1; i<=gdata.inqueue; i++) {
      notice(gdata.mainqueue[i-1]->nick,"MESSAGE FROM OWNER: %s",u->arg1e);
      count++;
      }
   for (i=1; i<=gdata.inslotsmaxqueue; i++) {
      notice(gdata.packqueue[i-1]->nick,"MESSAGE FROM OWNER: %s",u->arg1e);
      count++;
      }
   isnprintf(tempstr,maxtextlength-2,"Sent message to %i user%s",count,count!=1?"s":"");
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   }

static void u_closedcc(const userinput * const u) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
      ioutput(0,OUT_S|OUT_L,"0;35","DCC CHAT: QUIT");
      writedccchat("Bye.");
      FD_CLR(gdata.dccchat, &gdata.readset);
      msleep(100);
      close(gdata.dccchat);
      gdata.dccchat = 1000;
      highestsock();
   }

static void u_status(const userinput * const u) {
   char *tempstr = mycalloc(maxtextlength,"u_status");
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   getstatusline(tempstr);
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   }

static void u_chfile(const userinput * const u) {
   int num = 0;
   char *tempstr;
   int i,p,xfiledescriptor;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   
   if (num < 1 || num > gdata.numpacks) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   if (u->arg3) {
      u_respond(u,"Filenames can't contain spaces");
      return;
      }

   if (!u->arg2 || !strlen(u->arg2)) {
      u_respond(u,"Try Specifying a Filename");
      return;
      }
   
   for (i=1, p=0; i<=gdata.numpacks; i++, p++) {
      while (gdata.xdccs[p] == NULL)
         p++;
      if ( i == num )
         break;
      }
   
   for (i=0; gdata.xdccs[i]; i++) ;
   gdata.xdccs[i] = mycalloc(sizeof(xdcc),"u_chfile");
   
   strncpy(gdata.xdccs[i]->file,u->arg2,maxtextlength-1);
   strncpy(gdata.xdccs[i]->desc,gdata.xdccs[p]->desc,maxtextlength-1);
   if ( strlen(gdata.xdccs[p]->note) )
      strncpy(gdata.xdccs[i]->note,gdata.xdccs[p]->note,maxtextlength-1);
   else
      strncpy(gdata.xdccs[i]->note,"",maxtextlength-1);
   
   gdata.xdccs[i]->gets = gdata.xdccs[p]->gets;
   
   gdata.xdccs[i]->minspeed = gdata.overallminspeed;
   if ( gdata.xdccs[p]->minspeed != gdata.overallminspeed )
      gdata.xdccs[i]->minspeed = gdata.xdccs[p]->minspeed;

   gdata.xdccs[i]->maxspeed = gdata.transfermaxspeed;
   if ( gdata.xdccs[p]->maxspeed != gdata.transfermaxspeed )
      gdata.xdccs[i]->maxspeed = gdata.xdccs[p]->maxspeed;

   xfiledescriptor=open(gdata.xdccs[i]->file, O_RDONLY | ADDED_OPEN_FLAGS);
   
   if (xfiledescriptor < 0 && gdata.filedir) {
      isnprintf(gdata.xdccs[i]->file,maxtextlength-2,"%s/%s",gdata.filedir,u->arg2);
      xfiledescriptor=open(gdata.xdccs[i]->file, O_RDONLY | ADDED_OPEN_FLAGS);
      }
   
   if (xfiledescriptor < 0) {
      u_respond(u,"File Could Not Be Opened Or Read");
      mydelete(gdata.xdccs[i]);
      return;
      }
   
   gdata.xdccs[i]->size = lseek(xfiledescriptor, 0, SEEK_END);
   
   if ( gdata.xdccs[i]->size == 0 ) {
      u_respond(u,"File has size of 0 bytes!");
      mydelete(gdata.xdccs[i]);
      return;
      }
   
   close(xfiledescriptor);
   
   tempstr = mycalloc(maxtextlength,"u_chfile");
   isnprintf(tempstr,maxtextlength-2,
      "CHFILE: [Pack %i] Old: %s New: %s",
      num,gdata.xdccs[p]->file,gdata.xdccs[i]->file);
   u_respond(u,tempstr);
   mydelete(tempstr);

   /* old is leaked for now */
   gdata.xdccs[p] = gdata.xdccs[i];
   gdata.xdccs[i] = NULL;
   
   xdccsave(0);
   
   }

static void u_add(const userinput * const u) {
   int i,xfiledescriptor;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!u->arg1 || !strlen(u->arg1)) {
      u_respond(u,"Try Specifying a Filename");
      return;
      }
   
   if (u->arg2) {
      u_respond(u,"Filenames can't contain spaces");
      return;
      }
   
   for (i=0; gdata.xdccs[i]; i++) ;
   
   if (i==MAXXDCCS) {
      u_respond(u,"Max Number of Packs Reached");
      return;
      }
   
   gdata.xdccs[i] = mycalloc(sizeof(xdcc),"u_add");
   
   strncpy(gdata.xdccs[i]->file,u->arg1,maxtextlength-1);
   strncpy(gdata.xdccs[i]->note,"",maxtextlength-1);
   strncpy(gdata.xdccs[i]->desc,"no description (",maxtextlength-1);
   strncat(gdata.xdccs[i]->desc,u->arg1,sizeof(gdata.xdccs[i]->desc)-strlen(gdata.xdccs[i]->desc)-1);
   strncat(gdata.xdccs[i]->desc,")",sizeof(gdata.xdccs[i]->desc)-strlen(gdata.xdccs[i]->desc)-1);
   
   gdata.xdccs[i]->gets = 0;
   gdata.xdccs[i]->minspeed = gdata.overallminspeed;
   gdata.xdccs[i]->maxspeed = gdata.transfermaxspeed;

   xfiledescriptor=open(gdata.xdccs[i]->file, O_RDONLY | ADDED_OPEN_FLAGS);
   
   if (xfiledescriptor < 0 && gdata.filedir) {
      isnprintf(gdata.xdccs[i]->file,maxtextlength-2,"%s/%s",gdata.filedir,u->arg1);
      xfiledescriptor=open(gdata.xdccs[i]->file, O_RDONLY | ADDED_OPEN_FLAGS);
      }
   
   if (xfiledescriptor < 0) {
      u_respond(u,"File Could Not Be Opened Or Read");
      mydelete(gdata.xdccs[i]);
      return;
      }
   
   gdata.xdccs[i]->size = lseek(xfiledescriptor, 0, SEEK_END);
   
   if ( gdata.xdccs[i]->size == 0 ) {
      u_respond(u,"File has size of 0 bytes!");
      mydelete(gdata.xdccs[i]);
      return;
      }
   
   close(xfiledescriptor);
   
   gdata.numpacks++;
   
   tempstr = mycalloc(maxtextlength,"u_add");
   isnprintf(tempstr,maxtextlength-2,
      "ADD PACK: [Pack: %i] [File: %s] Use CHDESC to change description",
      gdata.numpacks,gdata.xdccs[i]->file);
   u_respond(u,tempstr);
   mydelete(tempstr);
   
   xdccsave(0);
   
   }

static void u_adddir(const userinput * const u) {
   int count=0;
   DIR *d;
   struct dirent *f;
   char *tempstr, *thedir;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!u->arg1 || !strlen(u->arg1)) {
      u_respond(u,"Try Specifying a Directory");
      return;
      }
   
   if (u->arg2) {
      u_respond(u,"No spaces please");
      return;
      }
   
   if (u->arg1[strlen(u->arg1)-1] == '/') u->arg1[strlen(u->arg1)-1] = '\0';
   if (u->arg1[strlen(u->arg1)-1] == '\\') u->arg1[strlen(u->arg1)-1] = '\0';
   
   thedir = mycalloc(maxtextlength,"u_adddir");
   strncpy(thedir,u->arg1,maxtextlength-1);
   
   d = opendir(thedir);
   
   if (!d && gdata.filedir) {
      isnprintf(thedir,maxtextlength-2,"%s/%s",gdata.filedir,u->arg1);
      d = opendir(thedir);
      }
   
   if (!d) {
      u_respond(u,"Couldn't Read Directory.");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_adddir");
   
   isnprintf(tempstr,maxtextlength-2,"Adding contents of %s...",thedir);
   u_respond(u,tempstr);
   
   while ((f = readdir(d))) {
      if (strcmp(".",f->d_name) && strcmp("..",f->d_name)) {
         count++;
         isnprintf(tempstr,maxtextlength-2,"  Adding %s:",f->d_name);
         u_respond(u,tempstr);
         isnprintf(tempstr,maxtextlength-2,"%s/%s",thedir,f->d_name);
         strncpy(u->arg1,tempstr,maxtextlength-1);
         u_add(u);
         }
      }
   
   isnprintf(tempstr,maxtextlength-2,"Total of %i files added",count);
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   mydelete(thedir);
   closedir(d);
   
   }

static void u_chdesc(const userinput * const u) {
   int num = 0;
   int i,p;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   if (num < 1 || num > gdata.numpacks) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   if (!u->arg2e || !strlen(u->arg2e)) {
      u_respond(u,"Try Specifying a Description");
      return;
      }
   
   for (i=1, p=0; i<=gdata.numpacks; i++, p++) {
      while (gdata.xdccs[p] == NULL)
         p++;
      if ( i == num )
         break;
      }
   
   tempstr = mycalloc(maxtextlength,"u_chdesc");
   isnprintf(tempstr,maxtextlength-2,
      "CHDESC: [Pack %i] Old: %s New: %s",
      num,gdata.xdccs[p]->desc,u->arg2e);
   u_respond(u,tempstr);
   mydelete(tempstr);
   
   strncpy(gdata.xdccs[p]->desc,u->arg2e,maxtextlength-1);
   
   xdccsave(0);
   
   }

static void u_chnote(const userinput * const u) {
   int num = 0;
   int i,p;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   
   if (num < 1 || num > gdata.numpacks) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   for (i=1, p=0; i<=gdata.numpacks; i++, p++) {
      while (gdata.xdccs[p] == NULL)
         p++;
      if ( i == num )
         break;
      }
   
   tempstr = mycalloc(maxtextlength,"u_chnote");
   isnprintf(tempstr,maxtextlength-2,
      "CHNOTE: [Pack %i] Old: %s New: %s",
      num,gdata.xdccs[p]->note,u->arg2e);
   u_respond(u,tempstr);
   mydelete(tempstr);
   
   if (!u->arg2e || !strlen(u->arg2e)) 
      strncpy(gdata.xdccs[p]->note,"",maxtextlength-1);
   else
      strncpy(gdata.xdccs[p]->note,u->arg2e,maxtextlength-1);
   
   xdccsave(0);
   
   }

static void u_chmins(const userinput * const u) {
   int num = 0;
   int i,p;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   if (num < 1 || num > gdata.numpacks) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   if (!u->arg2 || !strlen(u->arg2)) {
      u_respond(u,"Try Specifying a Minspeed");
      return;
      }

   for (i=1, p=0; i<=gdata.numpacks; i++, p++) {
      while (gdata.xdccs[p] == NULL)
         p++;
      if ( i == num )
         break;
      }
   
   tempstr = mycalloc(maxtextlength,"u_chmins");
   isnprintf(tempstr,maxtextlength-2,
      "CHMINS: [Pack %i] Old: %1.1f New: %1.1f",
      num,gdata.xdccs[p]->minspeed,atof(u->arg2));
   u_respond(u,tempstr);
   mydelete(tempstr);
   
   gdata.xdccs[p]->minspeed = gdata.overallminspeed;
   if ( atof(u->arg2) != gdata.overallminspeed )
      gdata.xdccs[p]->minspeed = atof(u->arg2);
   
   xdccsave(0);
   
   }

static void u_chmaxs(const userinput * const u) {
   int num = 0;
   int i,p;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   if (num < 1 || num > gdata.numpacks) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   if (!u->arg2 || !strlen(u->arg2)) {
      u_respond(u,"Try Specifying a Maxspeed");
      return;
      }

   for (i=1, p=0; i<=gdata.numpacks; i++, p++) {
      while (gdata.xdccs[p] == NULL)
         p++;
      if ( i == num )
         break;
      }
   
   tempstr = mycalloc(maxtextlength,"u_chmaxs");
   isnprintf(tempstr,maxtextlength-2,
      "CHMAXS: [Pack %i] Old: %1.1f New: %1.1f",
      num,gdata.xdccs[p]->maxspeed,atof(u->arg2));
   u_respond(u,tempstr);
   mydelete(tempstr);
   
   gdata.xdccs[p]->maxspeed = gdata.transfermaxspeed;
   if ( atof(u->arg2) != gdata.transfermaxspeed )
      gdata.xdccs[p]->maxspeed = atof(u->arg2);
   
   xdccsave(0);
   
   }

static void u_chatme(const userinput * const u) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   u_respond(u,"Sending You A DCC Chat Request");
   
   if (setupdccchatout(u->snick))
      u_respond(u,"[Failed to listen, try again]");
   
   
   }

static void u_rehash(const userinput * const u) {
   
   /* other variables */
   char *templine = mycalloc(maxtextlength,"u_rehash_templine");
   char *tempc = mycalloc(2,"u_rehash_tempc");
   int h,i,j,k,found,filedescriptor=-1,needtojump;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->method==method_out_all) u_respond(u,"Caught SIGUSR2, Rehashing...");
   
   /* clear old config items */
   for (i=0; i<MAXAHOST; i++)
      mydelete(gdata.adminhost[i]);
   for (i=0; i<MAXSRVS; i++)
      mydelete(gdata.server[i]);
   for (i=0; i<MAXCHNLS; i++)
      gdata.t_channel[i] = gdata.r_channel[i] = NULL;
   for (i=0; i<MAXADVERTS && gdata.advert[i]; i++)
     {
       mydelete (gdata.advert[i]);
       gdata.advert[i]=NULL;
     }
   
   gdata.r_overallminspeed = gdata.overallminspeed;
   gdata.r_transfermaxspeed = gdata.transfermaxspeed;
   mydelete(gdata.logfile);
   gdata.logrotate = gdata.logstats = 0;
   mydelete(gdata.ignorefile);
   mydelete(gdata.messagefile);
   mydelete(gdata.user_realname);
   mydelete(gdata.user_modes);
   gdata.firewall = 0;
   gdata.dccrangestart = 4000;
   mydelete(gdata.proxyinfo);
   mydelete(gdata.proxyinfo2);
   gdata.usenatip = 0;
   gdata.slotsmax = gdata.queuesize = gdata.slotsmaxpack = gdata.slotsmaxslots = gdata.slotsmaxqueue = 0;
   gdata.maxtransfersperperson = 1;
   gdata.maxqueueditemsperperson = 1;
   mydelete(gdata.filedir);
   gdata.lowbdwth = 0;
   gdata.overallminspeed = gdata.transfermaxspeed = 0.0;
   gdata.overallmaxspeed = gdata.overallmaxspeeddayspeed = 0;
   gdata.overallmaxspeeddaytimestart = gdata.overallmaxspeeddaytimeend = 0;
   gdata.overallmaxspeeddaydays = 0x7F; /* all days */
   gdata.debug = gdata.debug2 = 0;
   gdata.autosend = gdata.autopack = 0;
   mydelete(gdata.autoword);
   mydelete(gdata.automsg);
   gdata.xdccautosavetime = 0;
   mydelete(gdata.creditline);
   mydelete(gdata.periodicmsg_nick);
   mydelete(gdata.periodicmsg_msg);
   gdata.periodicmsg_time = 0;
   gdata.uploadallowed = gdata.uploadmaxsize = 0;
   mydelete(gdata.uploaddir);
   gdata.restrictlist = gdata.restrictsend = 0;
   mydelete(gdata.loginname);
   set_loginname();
   
   /* go */
   gdata.highmeminfo=1;
   
   for (h=0; h<MAXCONFIG && gdata.configfile[h]; h++) {
      isnprintf(templine,maxtextlength-2,"Reloading %s ...",gdata.configfile[h]);
      u_respond(u,templine);
      
      filedescriptor=open(gdata.configfile[h], O_RDONLY | ADDED_OPEN_FLAGS);
      if (filedescriptor < 0) {
         u_respond(u,"Couldn't Open Config File, Aborting rehash");
         u_respond(u,"***WARNING*** missing vital information, fix and re-rehash ASAP");
         mydelete(templine);
         mydelete(tempc);
         return;
         }
   
      i = 0;
      while(read(filedescriptor,tempc,1) == 1) {
         if (tempc[0] == '\n' || tempc[0] == 13) {  /* 13 is ^M */
            templine[i] = '\0';
            if ( templine[0] != '#' && strlen(templine) != 0 ) {
               for (i=strlen(templine)-1; i>2 && templine[i] == ' '; i--)
                  templine[i] = '\0';
               getconfig_set(templine,1);
               }
            i = 0;
            }
         else {
            templine[i] = tempc[0];
            i++;
            }
         }
      }
   close(filedescriptor);
   /* see what needs to be redone */
   
   u_respond(u,"Reconfiguring...");
   
   needtojump=0;
   if ( gdata.virthost != gdata.r_virthost ||
       (gdata.virthost && gdata.r_virthost && gdata.vhost_ip && gdata.r_vhost_ip && strcmp(gdata.vhost_ip,gdata.r_vhost_ip)) )
      needtojump=1;
   
   k=0;
   /* part deleted channels, add common channels */
   for (i=0; i<MAXCHNLS && gdata.channels[i]; i++) {
      found = 0;
      for (j=0; j<MAXCHNLS && gdata.r_channel[j] && !found; j++)
         if (!strcmp(gdata.channels[i]->name,gdata.r_channel[j]->name)) found = 1;
      j--;
      if (!found) {
         isnprintf(templine,maxtextlength-2,"PART %s",gdata.channels[i]->name);
         if (!needtojump) writeserver(templine);
	 clearmemberlist(gdata.channels[i]);
         if (PRINTCHAN) printf("1 channels[%i] = %s parted\n",i,gdata.channels[i]->name);
         }
      else {
         gdata.t_channel[k] = mycalloc(sizeof(channel_t),"u_rehash_t_channel[k]");
         memcpy(gdata.t_channel[k],gdata.r_channel[j],sizeof(channel_t));
         gdata.t_channel[k]->flags |= gdata.channels[i]->flags & CHAN_ONCHAN;
	 gdata.t_channel[k]->members = gdata.channels[i]->members;
	 if (PRINTCHAN) printf("2 t_channel[%i] <- r_channel[%i] = %s common\n",k,i,gdata.channels[i]->name);
         k++;
         }
      }
   
   /* join/add new channels */
   for (i=0; i<MAXCHNLS && gdata.r_channel[i]; i++) {
      found = 0;
      for (j=0; j<MAXCHNLS && gdata.channels[j]; j++)
         if (!strcmp(gdata.r_channel[i]->name,gdata.channels[j]->name)) found = 1;
      if (!found) {
         gdata.t_channel[k] = mycalloc(sizeof(channel_t),"u_rehash_t_channel[k]");
         memcpy(gdata.t_channel[k],gdata.r_channel[i],sizeof(channel_t));
         if (!needtojump) joinchannel(gdata.t_channel[k]);
         gdata.t_channel[k]->flags &= ~CHAN_ONCHAN;
         if (PRINTCHAN) printf("3 t_channel[%i] <- r_channel[%i] = %s new\n",k,i,gdata.r_channel[i]->name);
         k++;
         }
      }
   
   /* kill old channel lists */
   for (i=0; i<MAXCHNLS && gdata.channels[i]; i++)
      mydelete(gdata.channels[i]);
   for (i=0; i<MAXCHNLS && gdata.r_channel[i]; i++)
      mydelete(gdata.r_channel[i]);
   
   /* switch to new channel list */
   for (i=0; i<MAXCHNLS && gdata.t_channel[i]; i++) {
      gdata.channels[i] = gdata.t_channel[i];
      gdata.t_channel[i] = NULL;
      
      if (PRINTCHAN) printf("4 channels[%i] = %s\n",i,gdata.channels[i]->name);
      }
   
   if (needtojump) {
      u_respond(u,"vhost changed, reconnecting");
      mydelete(gdata.vhost_ip);
      gdata.vhost_ip = gdata.r_vhost_ip;
      gdata.r_vhost_ip = NULL;
      gdata.virthost = gdata.r_virthost;
      switchserver(-1);
      /* switchserver takes care of joining channels */
      }
   else {
      mydelete(gdata.vhost_ip);
      gdata.vhost_ip = gdata.r_vhost_ip;
      gdata.r_vhost_ip = NULL;
      gdata.virthost = gdata.r_virthost;
      }
   
   if (strcmp(gdata.pidfile,gdata.r_pidfile)) {
      u_respond(u,"pidfile changed, switching");
      unlink(gdata.pidfile);
      writepidfile(gdata.r_pidfile);
      }
   mydelete(gdata.pidfile);
   gdata.pidfile = gdata.r_pidfile;
   gdata.r_pidfile = NULL;
   
   if (strcmp(gdata.user_nick,gdata.r_user_nick)) {
      u_respond(u,"user_nick changed, renaming");
      isnprintf(templine,maxtextlength-2,"NICK %s",gdata.r_user_nick);
      writeserver2(templine,1);
      }
   mydelete(gdata.user_nick);
   gdata.user_nick = gdata.r_user_nick;
   gdata.r_user_nick = NULL;
   strncpy(gdata.caps_nick,gdata.user_nick,maxtextlengthshort-1);
   caps(gdata.caps_nick);
   
   
   if (strcmp(gdata.xdccfile,gdata.r_xdccfile))
      u_respond(u,"sorry, changing xdccfile is yet implemented");
   mydelete(gdata.r_xdccfile);
   
   
   gdata.maxb = gdata.overallmaxspeed;
   if (gdata.overallmaxspeeddayspeed != gdata.overallmaxspeed) {
      struct tm *localt;
      localt = localtime(&gdata.curtime);

      if (localt->tm_hour >= gdata.overallmaxspeeddaytimestart
          && localt->tm_hour < gdata.overallmaxspeeddaytimeend
          && ( gdata.overallmaxspeeddaydays & (1 << localt->tm_wday)) )
         gdata.maxb = gdata.overallmaxspeeddayspeed;
      }
   
   if ( gdata.r_overallminspeed != gdata.overallminspeed)
      for (i=0; i<MAXXDCCS; i++)
         if (gdata.xdccs[i] && (gdata.xdccs[i]->minspeed == gdata.r_overallminspeed))
            gdata.xdccs[i]->minspeed = gdata.overallminspeed;
   
   if ( gdata.r_transfermaxspeed != gdata.transfermaxspeed)
      for (i=0; i<MAXXDCCS; i++)
         if (gdata.xdccs[i] && (gdata.xdccs[i]->maxspeed == gdata.r_transfermaxspeed))
            gdata.xdccs[i]->maxspeed = gdata.transfermaxspeed;
   
   /* check for completeness */
   u_respond(u,"Checking for completeness of config file ...");
   
   if ( gdata.server[0] == NULL
        || gdata.user_nick == NULL || gdata.user_realname == NULL
        || gdata.user_modes == NULL || gdata.channels[0] == NULL
        || gdata.slotsmax == 0 || gdata.xdccautosavetime == 0 || gdata.xdccfile == 0)
      u_respond(u,"***WARNING*** missing vital information, fix and re-rehash ASAP");
   
   if ( gdata.autosend && ( gdata.autoword == NULL || gdata.automsg == NULL || !gdata.autopack ) )
      u_respond(u,"***WARNING*** incomplete autosend information, fix and re-rehash ASAP");
   
   if ( gdata.uploadallowed && ( gdata.uploaddir == NULL || strlen(gdata.uploaddir) < 2 ) )
      u_respond(u,"***WARNING*** incomplete upload information, fix and re-rehash ASAP");
      
   u_respond(u,"Done.");
   
   for (i=0; i<100; i++)
      if (!gdata.exiting && (gdata.inqueue || gdata.inslotsmaxqueue) && (gdata.slotsfull < gdata.slotsmax))
         sendaqueue(0);
   
   gdata.highmeminfo=0;
   
   mydelete(tempc);
   mydelete(templine);

   }

static void u_botinfo(const userinput * const u) {
   char *tempstr = mycalloc(maxtextlength,"u_botinfo");
   char *tempstr2 = mycalloc(maxtextlength,"u_botinfo");
   int i;
   struct rusage r;

   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   u_respond(u,"BotInfo:");
   
   isnprintf(tempstr,maxtextlength-2,"iroffer v%s [%s] By PMG, http://iroffer.org/ - %s"
           ,VERSION,VERSIONDATE,gdata.osstring);
   u_respond(u,tempstr);

   getuptime(tempstr2,0,gdata.startuptime);
   isnprintf(tempstr,maxtextlength-2,"iroffer started up %s ago",tempstr2);
   u_respond(u,tempstr);

   getuptime(tempstr2,0,gdata.curtime-gdata.totaluptime);
   isnprintf(tempstr,maxtextlength-2,"total running time of %s",tempstr2);
   u_respond(u,tempstr);

   getrusage(RUSAGE_SELF,&r);
   
   isnprintf(tempstr,maxtextlength-2,"cpu usage: %2.2fs user (%2.5f%%), %2.2fs system (%2.5f%%)",
                  ((float)r.ru_utime.tv_sec+(((float)r.ru_utime.tv_usec)/1000000.0)),
            100.0*((float)r.ru_utime.tv_sec+(((float)r.ru_utime.tv_usec)/1000000.0))/((float)(max2(1,gdata.curtime-gdata.startuptime))),
                  ((float)r.ru_stime.tv_sec+(((float)r.ru_stime.tv_usec)/1000000.0)),
            100.0*((float)r.ru_stime.tv_sec+(((float)r.ru_stime.tv_usec)/1000000.0))/((float)(max2(1,gdata.curtime-gdata.startuptime)))
            );
   u_respond(u,tempstr);

   isnprintf(tempstr,maxtextlength-2,"nick: %s, realname: %s, modes: %s",gdata.user_nick,gdata.user_realname,gdata.user_modes);
   u_respond(u,tempstr);
   
   switch (gdata.connectionmethod.how) {
    case how_direct:
       isnprintf(tempstr,maxtextlength-2,"current server: %s %s (direct)",
       gdata.curserverip,gdata.curserverport);
       break;
    case how_bnc:
       if (gdata.connectionmethod.vhost[0])
          isnprintf(tempstr,maxtextlength-2,"current server: %s %s (bnc at %s:%i with %s)",
          gdata.curserverip,gdata.curserverport,gdata.connectionmethod.host,gdata.connectionmethod.port,gdata.connectionmethod.vhost);
       else
          isnprintf(tempstr,maxtextlength-2,"current server: %s %s (bnc at %s:%i)",
          gdata.curserverip,gdata.curserverport,gdata.connectionmethod.host,gdata.connectionmethod.port);
       break;
    case how_wingate:
       isnprintf(tempstr,maxtextlength-2,"current server: %s %s (wingate at %s:%i)",
       gdata.curserverip,gdata.curserverport,gdata.connectionmethod.host,gdata.connectionmethod.port);
       break;
    case how_custom:
       isnprintf(tempstr,maxtextlength-2,"current server: %s %s (custom at %s:%i)",
       gdata.curserverip,gdata.curserverport,gdata.connectionmethod.host,gdata.connectionmethod.port);
       break;
    }

   u_respond(u,tempstr);
   
   for (i=0; gdata.channels[i] && i<MAXCHNLS; i++) {
      isnprintf(tempstr,maxtextlength-2,"channel %10s: joined: %3s",
               gdata.channels[i]->name,gdata.channels[i]->flags & CHAN_ONCHAN ? "yes" : "no ");
      
      if (strlen(gdata.channels[i]->key)) {
         isnprintf(tempstr2,maxtextlength-2,"%s, key: %s",tempstr,
                  gdata.channels[i]->key);
         strncpy(tempstr,tempstr2,maxtextlength-1);
         }
               
      if (gdata.channels[i]->plisttime) {
         isnprintf(tempstr2,maxtextlength-2,"%s, plist every %2i min (%s)",tempstr,
                  gdata.channels[i]->plisttime,
                  gdata.channels[i]->flags & CHAN_MINIMAL ? "minimal" : 
		   (gdata.channels[i]->flags & CHAN_SUMMARY ? "summary" : 
		    (gdata.channels[i]->flags & CHAN_CUSTOM ? "custom" : "full")));
         strncpy(tempstr,tempstr2,maxtextlength-1);
         }
      
      u_respond(u,tempstr);
      }
   
   isnprintf(tempstr,maxtextlength-2,
            "bandwidth: lowsend: %i, minspeed: %1.1f, maxspeed: %1.1f, overallmaxspeed: %i",
            gdata.lowbdwth,gdata.overallminspeed,gdata.transfermaxspeed,gdata.maxb/4);
   u_respond(u,tempstr);
   
   if (gdata.overallmaxspeed != gdata.overallmaxspeeddayspeed)
      isnprintf(tempstr,maxtextlength-2,
            "           default max: %i, day max: %i ( %i:00 -> %i:59, days=\"%s%s%s%s%s%s%s\" )",
            gdata.overallmaxspeed/4,gdata.overallmaxspeeddayspeed/4,
            gdata.overallmaxspeeddaytimestart,gdata.overallmaxspeeddaytimeend-1,
            (gdata.overallmaxspeeddaydays & (1 << 1)) ? "M":"",
            (gdata.overallmaxspeeddaydays & (1 << 2)) ? "T":"",
            (gdata.overallmaxspeeddaydays & (1 << 3)) ? "W":"",
            (gdata.overallmaxspeeddaydays & (1 << 4)) ? "R":"",
            (gdata.overallmaxspeeddaydays & (1 << 5)) ? "F":"",
            (gdata.overallmaxspeeddaydays & (1 << 6)) ? "S":"",
            (gdata.overallmaxspeeddaydays & (1 << 0)) ? "U":"");
   else
      isnprintf(tempstr,maxtextlength-2,
            "           default max: %i, day max: (same)",
            gdata.overallmaxspeed/4);
   u_respond(u,tempstr);
   
   isnprintf(tempstr,maxtextlength-2,
            "files: xdcc: %s, pid: %s, log: %s, msg: %s, ignl: %s",
            (gdata.xdccfile?gdata.xdccfile:"(none)"),
            (gdata.pidfile?gdata.pidfile:"(none)"),
            (gdata.logfile?gdata.logfile:"(none)"),
            (gdata.messagefile?gdata.messagefile:"(none)"),
            (gdata.ignorefile?gdata.ignorefile:"(none)"));
   u_respond(u,tempstr);
   
   isnprintf(tempstr,maxtextlength-2,
            "config file%s: %s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
            gdata.configfile[1]?"s":"",
            gdata.configfile[0],
            gdata.configfile[1]?", ":"",gdata.configfile[1]?gdata.configfile[1]:"",
            gdata.configfile[2]?", ":"",gdata.configfile[2]?gdata.configfile[2]:"",
            gdata.configfile[3]?", ":"",gdata.configfile[3]?gdata.configfile[3]:"",
            gdata.configfile[4]?", ":"",gdata.configfile[4]?gdata.configfile[4]:"",
            gdata.configfile[5]?", ":"",gdata.configfile[5]?gdata.configfile[5]:"",
            gdata.configfile[6]?", ":"",gdata.configfile[6]?gdata.configfile[6]:"",
            gdata.configfile[7]?", ":"",gdata.configfile[7]?gdata.configfile[7]:"",
            gdata.configfile[8]?", ":"",gdata.configfile[8]?gdata.configfile[8]:"",
            gdata.configfile[9]?", ":"",gdata.configfile[9]?gdata.configfile[9]:""
            );
   u_respond(u,tempstr);
   
   if (gdata.uploadallowed) {
      isnprintf(tempstr2,maxtextlength-2,"%iMB",gdata.uploadmaxsize/1024/1024);
      isnprintf(tempstr,maxtextlength-2,
               "upload allowed, dir: %s, max size: %s",
               gdata.uploaddir,gdata.uploadmaxsize?tempstr2:"none");
      u_respond(u,tempstr);
      }
   
   if (gdata.delayedshutdown) {
      u_respond(u,"NOTICE: Delayed shutdown activated, iroffer will shutdown once there are no active transfers");
      u_respond(u,"NOTICE: To cancel the delayed shutdown, issue \"SHUTDOWN CANCEL\"");
      }
   
   mydelete(tempstr);
   mydelete(tempstr2);
   }


static void u_ignl(const userinput * const u) {
   int i,haveignored,left,ago;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   haveignored=0;
   for (i=0; i<MAXIGNL && gdata.ignorelist[i]; i++)
      if (gdata.ignorelist[i]->flags & IGN_IGNORING) haveignored++;
   
   if (!haveignored) {
      u_respond(u,"No Hosts Ignored");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_ignl");
   
   isnprintf(tempstr,maxtextlength-2,"Current Ignore%s:",haveignored!=1?"s":"");
   u_respond(u,tempstr);
   u_respond(u,"   Last Request  Un-Ignore     Type   Hostname");
   
   for (i=0; i<MAXIGNL && gdata.ignorelist[i]; i++) {
      if (gdata.ignorelist[i]->flags & IGN_IGNORING) {
         ago = gdata.curtime-gdata.ignorelist[i]->lastcontact;
         left = IGN_TL*(gdata.ignorelist[i]->bucket-IGN_OFF);
         isnprintf(tempstr,maxtextlength-2,"   %4i%c%02i%c ago   %4i%c%02i%c   %6s   %-32s",
                ago < 3600 ? ago/60 : ago/60/60 ,
                ago < 3600 ? 'm' : 'h',
                ago < 3600 ? ago%60 : (ago/60)%60 ,
                ago < 3600 ? 's' : 'm',
                left < 3600 ? left/60 : left/60/60 ,
                left < 3600 ? 'm' : 'h',
                left < 3600 ? left%60 : (left/60)%60 ,
                left < 3600 ? 's' : 'm',

            gdata.ignorelist[i]->flags & IGN_MANUAL ? "manual" : "auto",
            gdata.ignorelist[i]->hostname);
         u_respond(u,tempstr);
         }
      }
   
   mydelete(tempstr);
   }

void ignoreuser(char* hostname, int bantime)
{
  /* Ban a host for bantime minutes */
  int i, found;
  if (!hostname)
    return;
  
   for (found=i=0; (i<MAXIGNL && gdata.ignorelist[i] && !found); i++)
      if (isbanned(i,hostname)) found++;
   
   if (i == MAXIGNL) {
      outerror(1,"Out of ignore slots!, This shouldn't happen");
      return;
      }
   if (!found) {

      gdata.ignorelist[i] = mycalloc(sizeof(igninfo),"u_ignore_ignorelist[i]");
      strncpy(gdata.ignorelist[i]->hostname,hostname,maxtextlength-1);
      gdata.ignorelist[i]->flags &= ~IGN_FIRSTIGNORE;
      gdata.ignorelist[i]->lastcontact = gdata.curtime;
      }
   else
   	i--;
      gdata.ignorelist[i]->flags |= IGN_IGNORING;   
      gdata.ignorelist[i]->flags &= ~IGN_MANUAL & ~IGN_RANGE;
   gdata.ignorelist[i]->bucket = (bantime*60)/IGN_TL;
   ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","IGNORE banned: %s (%i)",hostname,bantime);
   write_ignorefile();
}



static void u_ignore(const userinput * const u) {
   int i, num=0, found, mask;
   char *tempstr;
   char* cptr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   
   if (!u->arg1)  {
      u_respond(u,"Try specifying an amount of time to ignore");        
      return;
      }
   cptr=u->arg2;
   if (!cptr || strlen(cptr) < 4) {
      u_respond(u,"Try specifying a hostname longer than 4 characters");
      return;
      }
   
   mask=(cptr[0]=='*')?IGN_RANGE:0;
   
   for (found=i=0; (i<MAXIGNL && gdata.ignorelist[i] && !found); i++)
     if (!strcmp(gdata.ignorelist[i]->hostname,cptr)) found++;
   
   if (i == MAXIGNL) {
      outerror(1,"Out of ignore slots!, This shouldn't happen");
      u_respond(u,"Out of ignore slots!, This shouldn't happen");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_ignore");
   
   if (!found) {
      gdata.ignorelist[i] = mycalloc(sizeof(igninfo),"u_ignore_ignorelist[i]");
      strncpy(gdata.ignorelist[i]->hostname,cptr,maxtextlength-1);
      gdata.ignorelist[i]->flags |= IGN_IGNORING;
      gdata.ignorelist[i]->flags &= ~IGN_FIRSTIGNORE;
      gdata.ignorelist[i]->lastcontact = gdata.curtime;
      }
   else
      i--;
   gdata.ignorelist[i]->flags |= IGN_MANUAL;
   gdata.ignorelist[i]->flags |= mask;
   gdata.ignorelist[i]->bucket = (num*60)/IGN_TL;
   
   isnprintf(tempstr,maxtextlength-2,
            "Ignore activated for *!*@%s which will last %i min",
            cptr,num);
   u_respond(u,tempstr);
   write_ignorefile();

   mydelete(tempstr);
   }


static void u_nosave(const userinput * const u) {
   int num = 0;
   char *tempstr = mycalloc(maxtextlength,"u_nosave");
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   gdata.noautosave=gdata.curtime + 60*num - 1;
   isnprintf(tempstr,maxtextlength-2,
   "*** XDCC AutoSave has been disabled for the next %i minute%s",num,num!=1?"s":"");
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   
   }


static void u_nosend(const userinput * const u) {
   int num = 0;
   char *tempstr = mycalloc(maxtextlength,"u_nosend");
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   gdata.nonewcons=gdata.curtime + 60*num - 1;
   isnprintf(tempstr,maxtextlength-2,
   "*** XDCC Send has been disabled for the next %i minute%s",num,num!=1?"s":"");
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   
}

static void u_humiliate (const userinput * const u)
{
  if (gdata.humiliate)
    {
      mydelete (gdata.humiliate);
      gdata.humiliate=NULL;
    }
  if ((u->arg1) || (strlen(u->arg1e)>1))
    {
      strncpy(gdata.humiliate=mycalloc(maxtextlength,"u_humiliate"),
	      u->arg1e, maxtextlength-2);
    }
}

static void u_spdwrn(const userinput * const u)
{
  char *x=u->arg1;
  updatecontext(__FILE__,__FUNCTION__,__LINE__);
  if ((!x) || (strlen(x)!=1))
    x="\0";
  switch (x[0])
    {
    case '-':
      gdata.nospeedwarnings=1;
      u_respond(u,"*** SPDWRN will not warn users about bandwidth limits");
     break;
    case '+':
      gdata.nospeedwarnings=0;
      u_respond(u,"*** SPDWRN will warn users about bandwidth limits");
      break;
    default:
      {
	char temp[maxtextlength];
	char* t=&(temp[0]);
	isnprintf(t,maxtextlength-2,
		  "Speed warning notices are %s. Use - to turn off, + to turn on",(gdata.nospeedwarnings)?"disabled":"enabled");
	u_respond(u,t);

      }
   }
}


static void u_public(const userinput * const u)
{
  char *x=u->arg1;
  updatecontext(__FILE__,__FUNCTION__,__LINE__);
  if ((!x) || (strlen(x)!=1))
    x="\0";
  switch (x[0])
    {
    case '-':
      gdata.publictriggers=0;
      u_respond(u,"*** PUBLIC will not respond to public triggers");
     break;
    case '+':
      gdata.publictriggers=1;
      u_respond(u,"*** PUBLIC public triggers will receive a response");
      break;
    default:
      {
        char temp[maxtextlength];
        char* t=&(temp[0]);
        isnprintf(t,maxtextlength-2,
                  "Response to public triggers is %s. Use - to turn off, + to tu
rn on",(gdata.publictriggers)?"on":"off");
     u_respond(u,t);

      }

    }
}
static void u_nolist(const userinput * const u) {
   int num = 0, num2=-1, x=maxtextlength-2,y;
   int on=0;
   char tempstr[maxtextlength];
   char *tstr=tempstr;
   tempstr[0]=0;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   /* Can we assume that -1 is 1111 1111 1111 1111 1111 1111 1111 1111
      on a 32 bit architechture using 2s-compliment???
      If so then surely -1>>1 represents the biggest positive number
      representable?
      I certainly hope so, as it's important here :)
   */

   if (u->arg1){
     if (!strcasecmp(u->arg1,"on"))
       {
	 gdata.nolisting=(-3ul)>>1;
	 num=-1;
	 on=1;
       }
     else
       gdata.nolisting=gdata.curtime + 60*(num=atoi(u->arg1));

     if (u->arg2)
       num2=(strcasecmp(u->arg2,"-q")==0)?0:atoi(u->arg2);
   }
   gdata.nolistbantime=num2;



   if (num==0)
     isnprintf(tstr,x,
	       "*** XDCC List and PLIST have been enabled");
   else
     {
       x-=y=isnprintf(tstr,x,
		      "*** XDCC List and PLIST have been disabled%s",
		      ((num2==-1)?"":" silently")
		      );
       tstr+=y;

       if (!on)
	 {
	   x-=y=isnprintf(tstr,x," for the next %i minute%s",num,num!=1?"s":"");
	   tstr+=y;
	 }

       if (num2>0)
	 {
	   x-=y=isnprintf(tstr,x," and any user requesting a list will be banned for %i minute%s",
			  num2,num2!=1?"s":"");
	   tstr+=y;
	 }
     }
   

   u_respond(u,tempstr);
   
   
   }


static void u_renumber(const userinput * const u) {
   int oldp = 0, newp = 0;
   int i,op,np;
   xdcc *t;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) oldp = atoi(u->arg1);
   if (u->arg2) newp = atoi(u->arg2);
   
   if (oldp < 1 || oldp > gdata.numpacks || newp < 1 || newp > gdata.numpacks || newp == oldp ) {
      u_respond(u,"Invalid pack number");
      return;
      }
   
   /* find old */
   for (i=1, op=0; i<=gdata.numpacks; i++, op++) {
      while (gdata.xdccs[op] == NULL)
         op++;
      if ( i == oldp )
         break;
      }
   
   /* find new */
   for (i=1, np=0; i<=gdata.numpacks; i++, np++) {
      while (gdata.xdccs[np] == NULL)
         np++;
      if ( i == newp )
         break;
      }
   
   t = gdata.xdccs[op];
   if (np > op)
      for (i=op; i<np; i++)
         gdata.xdccs[i] = gdata.xdccs[i+1];
   if (np < op)
      for (i=op; i>np; i--)
         gdata.xdccs[i] = gdata.xdccs[i-1];
   gdata.xdccs[np] = t;
   
   tempstr = mycalloc(maxtextlength,"u_renumber");
   isnprintf(tempstr,maxtextlength-2,"*** Moved pack %i to %i",oldp,newp);
   u_respond(u,tempstr);
   mydelete(tempstr);
   
   xdccsave(0);
   
   }


static void u_msgread(const userinput * const u) {
   int fd,count=0,i;
   char *linedate, *linemask;
   int msgoffset;
   char *tempstr, *tempstr2;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!gdata.messagefile) {
      u_respond(u,"no messagefile defined in config");
      return;
      }
   
   fd=open(gdata.messagefile, O_RDONLY | ADDED_OPEN_FLAGS);
   if (fd < 0) {
      u_respond(u,"messagefile couldn't be opened");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_msgread");
   tempstr2 = mycalloc(maxtextlength,"u_msgread");
   while (getfline(tempstr,fd,0) != NULL) {
      count++;
      linedate = getpart(tempstr,1,"u_msgread");
      linemask = getpart(tempstr,2,"u_msgread");
      msgoffset = sstrlen(linedate) + sstrlen(linemask) + 1;
      
      for (i=msgoffset; i<sstrlen(tempstr)+1; i++)
         tempstr[i-msgoffset] = tempstr[i];
      
      
      linedate = getdatestr(linedate,atoul(linedate));
      
      isnprintf(tempstr2,maxtextlength-2,
      "%s: %s",linedate,linemask);
      u_respond(u,tempstr2);
      isnprintf(tempstr2,maxtextlength-2,
      " ^- %s",tempstr);
      u_respond(u,tempstr2);
      
      mydelete(linedate); mydelete(linemask);
      }
   
   isnprintf(tempstr2,maxtextlength-2,
   "msglog: %i message%s in log%s%s",
           count,
           count!=1?"s":"",
           count?", use MSGDEL to remove ":"",
           count>1?"them":(count==1?"it":""));
   u_respond(u,tempstr2);
   
   
   mydelete(tempstr);
   mydelete(tempstr2);
   close(fd);
   
   }


static void u_msgdel(const userinput * const u) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!gdata.messagefile) {
      u_respond(u,"no messagefile defined in config");
      return;
      }
   
   if (truncate(gdata.messagefile,0) < 0) {
      u_respond(u,"couldn't delete messages");
      return;
      }
   
   u_respond(u,"msglog: deleted all messages");
   
   }


static void u_memstat(const userinput * const u) {
   int i;
   long numcount, numcountrecent, sizecount;
   struct rusage r;
   char *tempstr = mycalloc(maxtextlength,"u_memstat");
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   u_respond(u,"iroffer memory usage:");

   getrusage(RUSAGE_SELF,&r);
   
   isnprintf(tempstr,maxtextlength-2,"rusage: maxrss %li, ixrss %li, idrss %li, isrss %li, minflt %li, majflt %li, nswap %li",
            r.ru_maxrss,r.ru_ixrss,r.ru_idrss,r.ru_isrss,r.ru_minflt,r.ru_majflt,r.ru_nswap);
   u_respond(u,tempstr);
   isnprintf(tempstr,maxtextlength-2,"        inbloc %li, oublock %li, msgsnd %li, msgrcv %li, nsignals %li, nvcsw %li, nivcsw %li",
           r.ru_inblock,r.ru_oublock,r.ru_msgsnd,r.ru_msgrcv,r.ru_nsignals,r.ru_nvcsw,r.ru_nivcsw);
   u_respond(u,tempstr);

      
   for (numcountrecent=numcount=sizecount=i=0; i<MAXMEMINFO; i++)
      if (gdata.meminfo[i].ptr != NULL) {
         numcount++;
         sizecount += gdata.meminfo[i].size;
         if (gdata.meminfo[i].alloctime > gdata.curtime-600)
            numcountrecent++;
         }
      
   isnprintf(tempstr,maxtextlength-2,
     "%li bytes allocated for %li arrays (%li created in past 10 min)",
     sizecount,numcount,numcountrecent);
   u_respond(u,tempstr);
   
   if (u->arg1 && !strcmp(u->arg1,"list")) {
      
      u_respond(u,"iroffer memory usage details:");
      u_respond(u,"  id |    address |  size |     when | comment");
      
      for (i=0; i<MAXMEMINFO; i++)
         if (gdata.meminfo[i].ptr != NULL) {
            
            isnprintf(tempstr,maxtextlength-2,
              "%4i | 0x%8.8lX | %4iB | %7lis | \"%s\"",
              i,
              (long)gdata.meminfo[i].ptr,
              gdata.meminfo[i].size,
              gdata.meminfo[i].alloctime-gdata.startuptime,
              gdata.meminfo[i].src ? gdata.meminfo[i].src : "unknown" );
            u_respond(u,tempstr);
            
            }
      
      }
   else
      u_respond(u,"for a detailed listing use \"memstat list\"");
   
   mydelete(tempstr);
   
   }


static void u_qsend(const userinput * const u) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!gdata.inqueue && !gdata.inslotsmaxqueue) {
      u_respond(u,"No Users Queued");
      return;
      }
   
   sendaqueue(2);
   
   }

static void u_shutdown(const userinput * const u) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!u->arg1 || (strcmp(caps(u->arg1),"NOW") && strcmp(caps(u->arg1),"DELAYED") && strcmp(u->arg1,"CANCEL")) ) {
      u_respond(u,"Usage: SHUTDOWN <now|delayed|cancel>");
      return;
      }
   
   if (!strcmp(u->arg1,"NOW")) {
      shutdowniroffer(0);
      }
   else if (!strcmp(u->arg1,"DELAYED")) {
      u_respond(u,"Delayed shutdown activated, iroffer will shutdown once there are no active transfers");
      u_respond(u,"To cancel the delayed shutdown, issue \"SHUTDOWN CANCEL\"");
      gdata.delayedshutdown=1;
      }
   else if (!strcmp(u->arg1,"CANCEL")) {
      u_respond(u,"Delayed shutdown canceled");
      gdata.delayedshutdown=0;
      }
   
   }

static void u_debug(const userinput * const u) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!u->arg1) return;
   
   if (u->arg1[0] == '1') {
      gdata.debug = 1;
      gdata.debug2 = 0;
      }
   else if (u->arg1[0] == '2') {
      gdata.debug = 1;
      gdata.debug2 = 1;
      }
   else if (u->arg1[0] == '0') {
      gdata.debug = 0;
      gdata.debug2 = 0;
      }
   }

static void u_jump(const userinput * const u) {
  int num = 0;
  
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
  if (u->arg1) num = atoi(u->arg1);
  if (num < 0) num = 0;
  
  if (num > 0 && (num > MAXSRVS || !gdata.server[num-1]))
    u_respond(u,"Try specifying a valid server number, use \"servers\" for a list");
  else
    switchserver(num-1);
  
}

static void u_servers(const userinput * const u) {
  int i;
  char *tempstr = mycalloc(maxtextlength,"u_servers");
  
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
  u_respond(u,"Server List:");
  u_respond(u,"  Num  Server/Port");
  
  for (i=0; i<MAXSRVS; i++)
    if (gdata.server[i]) {
      isnprintf(tempstr,maxtextlength-2,"   %2i  %s",i+1,gdata.server[i]);
      u_respond(u,tempstr);
    }
  
  isnprintf(tempstr,maxtextlength-2,"Current Server: %s:%s",gdata.curserverip,gdata.curserverport);
  u_respond(u,tempstr);
  
  mydelete(tempstr);
  

}

static void u_trinfo(const userinput * const u) {
   int num = -1;
   char *tempstr, *tempstr2, *tempstr3;
   const char *y;
   int left,started,lcontact;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (u->arg1) num = atoi(u->arg1);
   if (num < 0 || num > MAXTRANS || gdata.trans[num] == NULL) {
      u_respond(u,"Try Specifying a Valid Transfer Number");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_trinfo");
   tempstr2 = mycalloc(maxtextlength,"u_trinfo");
   tempstr3 = mycalloc(maxtextlengthshort,"u_trinfo");
   
   isnprintf(tempstr,maxtextlength-2,"Transfer Info for ID %i:",num);
   u_respond(u,tempstr);
   
   if (gdata.trans[num]->status == 'L') y = "Listening";
   else if (gdata.trans[num]->status == 'W') y = "Finishing";
   else if (gdata.trans[num]->status == 'D') y = "Closing";
   else if (gdata.trans[num]->status == 'E') y = "Error";
   else if (gdata.trans[num]->status == 'S') y = "Sending";
   else y = "Unknown!";
   
   isnprintf(tempstr,maxtextlength-2,"User %s, Hostname %s, Status %s",
             gdata.trans[num]->nick,gdata.trans[num]->hostname,y);
   u_respond(u,tempstr);
   
   isnprintf(tempstr,maxtextlength-2,"File: %s",getfilename(gdata.trans[num]->xpack->file));
   u_respond(u,tempstr);
   
   isnprintf(tempstr,maxtextlength-2,"Start %liK, Current %liK, End %liK (%2.0f%% File, %2.0f%% Xfer)",
             (long)((gdata.trans[num]->startresume)/1024),
             (long)((gdata.trans[num]->bytessent)/1024),
             (long)((gdata.trans[num]->xpack->size)/1024),
             ((float)gdata.trans[num]->bytessent)*100.0/((float)gdata.trans[num]->xpack->size),
             ((float)(gdata.trans[num]->bytessent-gdata.trans[num]->startresume))*100.0/((float)max2(1,(gdata.trans[num]->xpack->size-gdata.trans[num]->startresume)))
             );
   u_respond(u,tempstr);
   
   isnprintf(tempstr2,maxtextlength-2,"%1.1fK/s",gdata.trans[num]->xpack->minspeed);
   isnprintf(tempstr3,maxtextlengthshort-2,"%1.1fK/s",gdata.trans[num]->xpack->maxspeed);
   
   isnprintf(tempstr,maxtextlength-2,"Min %s, Current %1.1fK/s, Max %s, In Transit %liK, Limit factor %2.0f%%",
             (gdata.trans[num]->nomin || (gdata.trans[num]->xpack->minspeed == 0.0)) ? "no" : tempstr2 ,
             gdata.trans[num]->lastspeed,
             (gdata.trans[num]->nomax || (gdata.trans[num]->xpack->maxspeed == 0.0)) ? "no" : tempstr3 ,
             (long)(gdata.trans[num]->bytessent-gdata.trans[num]->lastack)/1024,
             (float)(gdata.trans[num]->needsdata+(needsdatamin*(-1)))*100.0/(float)((needsdatamin*(-1)+needsdatamax))
             );
   u_respond(u,tempstr);
   
   left     = min2(359999,(gdata.trans[num]->xpack->size-gdata.trans[num]->bytessent)/((int)(max2(gdata.trans[num]->lastspeed,0.001)*1024)));
   started  = min2(359999,gdata.curtime-gdata.trans[num]->connecttime);
   lcontact = min2(359999,gdata.curtime-gdata.trans[num]->lastcontact);
   isnprintf(tempstr,maxtextlength-2,"Transfer started %i%c %i%c ago, Finish in %i%c %i%c, Last contact %i%c %i%c ago.",
             started < 3600 ? started/60 : started/60/60 ,
             started < 3600 ? 'm' : 'h',
             started < 3600 ? started%60 : (started/60)%60 ,
             started < 3600 ? 's' : 'm',
             left < 3600 ? left/60 : left/60/60 ,
             left < 3600 ? 'm' : 'h',
             left < 3600 ? left%60 : (left/60)%60 ,
             left < 3600 ? 's' : 'm',
             lcontact < 3600 ? lcontact/60 : lcontact/60/60 ,
             lcontact < 3600 ? 'm' : 'h',
             lcontact < 3600 ? lcontact%60 : (lcontact/60)%60 ,
             lcontact < 3600 ? 's' : 'm'
             );
   u_respond(u,tempstr);
   
   isnprintf(tempstr,maxtextlength-2,"Local: %ld.%ld.%ld.%ld:%d, Remote: %ld.%ld.%ld.%ld:%d",
             gdata.trans[num]->localip>>24, (gdata.trans[num]->localip>>16) & 0xFF, (gdata.trans[num]->localip>>8) & 0xFF, gdata.trans[num]->localip & 0xFF, gdata.trans[num]->listenport,
             gdata.trans[num]->remoteip>>24, (gdata.trans[num]->remoteip>>16) & 0xFF, (gdata.trans[num]->remoteip>>8) & 0xFF, gdata.trans[num]->remoteip & 0xFF, gdata.trans[num]->remoteport
             );
   u_respond(u,tempstr);
   
   isnprintf(tempstr,maxtextlength-2,"Sockets: Listen %i, Transfer %i, File %i",
             gdata.trans[num]->listensocket,
             gdata.trans[num]->clientsocket,
             gdata.trans[num]->filedescriptor
             );
   u_respond(u,tempstr);
   
   
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(tempstr3);
   }


static void u_listul(const userinput * const u) {
   int count=0;
   DIR *d;
   struct dirent *f;
   struct stat s;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!gdata.uploadallowed || !gdata.uploaddir) {
      u_respond(u,"Upload not Allowed or no Uploaddir defined.");
      return;
      }
   
   if (!(d = opendir(gdata.uploaddir))) {
      u_respond(u,"Couldn't Read Directory.");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_listul");
   
   isnprintf(tempstr,maxtextlength-2,"Contents of %s",gdata.uploaddir);
   u_respond(u,tempstr);
   
   while ((f = readdir(d))) {
      if (strcmp(".",f->d_name) && strcmp("..",f->d_name)) {
         count++;
         isnprintf(tempstr,maxtextlength-2,"%s/%s",gdata.uploaddir,f->d_name);
         stat(tempstr,&s);
         isnprintf(tempstr,maxtextlength-2,"   %s (%liK)",
                f->d_name,(long)s.st_size/1024);
         u_respond(u,tempstr);
         }
      }
   
   isnprintf(tempstr,maxtextlength-2,"%i Total Files",count);
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   
   closedir(d);
   
   }

static void u_clearrecords(const userinput * const u) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   gdata.record = 0;
   gdata.sentrecord = 0;
   gdata.totalsent = 0;
   gdata.totaluptime = 0;
   
   u_respond(u,"Cleared transfer record, bandwidth record, total sent, and total uptime");
   
   }

static void u_rmul(const userinput * const u) {
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!gdata.uploadallowed || !gdata.uploaddir) {
      u_respond(u,"Upload not Allowed or no Uploaddir defined.");
      return;
      }
   
   if (!u->arg1 || !strlen(u->arg1)) {
      u_respond(u,"Try Specifying a Filename");
      return;
      }
   
   if (u->arg2) {
      u_respond(u,"Filenames can't contain spaces");
      return;
      }
   
   if (strcmpany(u->arg1,"/")) {
      u_respond(u,"Filename contains invalid characters");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_rmul");
   isnprintf(tempstr,maxtextlength-2,"%s/%s",gdata.uploaddir,u->arg1);
   
   if (doesfileexist(tempstr)) {
      if (unlink(tempstr) < 0)
         u_respond(u,"Unable to remove the file");
      else
         u_respond(u,"Deleted");
      }
   else
      u_respond(u,"That filename doesn't exist");
   
   mydelete(tempstr);
   
   }

static void u_crash(const userinput * const u) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   *((int*)(0)) = 0;
   
}

#define USERS_PER_CHAN_LINE  6

static void u_chanl(const userinput * const u)
{
  int i,j;
  channel_member_t *p;
  char *tempstr = mycalloc(maxtextlength,"u_chanl");
  
  updatecontext(__FILE__,__FUNCTION__,__LINE__);
  
  u_respond(u,"Channel Members:");
  
  for (i=0; i<MAXCHNLS; i++)
    if (gdata.channels[i])
      {
	j = 0;
	p = gdata.channels[i]->members;
	
	if (p)
	  {
	    
	    while ( p )
	      {
		nocaps(p->nick);
		if (!(j%USERS_PER_CHAN_LINE))
		  isnprintf(tempstr,maxtextlength-1,"%s: ",gdata.channels[i]->name);
		strncat(tempstr,p->nick,maxtextlength-strlen(tempstr)-1);
		strncat(tempstr," ",maxtextlength-strlen(tempstr)-1);
		if (!((j+1)%USERS_PER_CHAN_LINE))
		  {
		    u_respond(u,tempstr);
		    tempstr[0] = '\0';
		  }
		caps(p->nick);
		
		p = p->next;
		j++;
	      }
	    
	    if (j%USERS_PER_CHAN_LINE)
	      u_respond(u,tempstr);

	  }
	
	isnprintf(tempstr,maxtextlength-1,"%s: %i user%s",gdata.channels[i]->name,j,j!=1?"s":"");
	u_respond(u,tempstr);
	
      }

  mydelete(tempstr);
  
}
/* End of File */
