/*      
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) defines.h 1.44@(#)
 * pmg@alliance.centerclick.org|src/defines.h|20011110170001|43468
 * 
 */

#if !defined _IROFFER_DEFINES
#define _IROFFER_DEFINES

#define  VERSION "1.2b13+cpitchfor7"
#define  VERSIONDATE "February 12th, 2002"
#define  VERSIONDATEUTC 1013555332 /* "date +%s" */
#define  RELEASE 1


/* options, these should be on */
/*       Send Flood Protection */
#define  SND_FPROT 1
/*       Receive Flood Protection */
#define  RCV_FPROT 1
/*       Ping The Server */
#define  PING_SRVR 1
/*       User Can't Request The Same File Twice */
#define  USER_MAXS 1
/*       Timeout Transfers */
#define  XFR_TMOUT 1
/*       Use Escape Seq to make status/input line */
#define  USESCREEN 1
/*       Use Escape Seq to make color */
#define  USECOLOR  1
/*       XDCC SAVE on Shutdown */
#define  SAVEQUIT  1
/*       Do Safe Mem Checking */
#define  MEMINFOCHECK 1
/*       adminpass is encrypted */
#define  ENCRYPTPASS 1
/*       allow background mode */
#define  ALLOWBACKGROUND 1
/*       dont allow running as root */
#define  BLOCKROOT 1


/* debugging helpers, these should normally be off */
/*       Print Socket Info */
#define  PRINTSOCK 0
/*       Print channel rehash Info */
#define  PRINTCHAN 0
/*       Print Efficiency Info */
#define  SHOWEFF   0
/*       Print loop Debug Info */
#define  LOOPDEBUG 0
/*       Print channel member info */
#define  MEMBERDEBUG 0


/* size, length, etc.. */
/*       How long to sleep in ms in main loop */
#define  WAITTIME  25
/*       Max Servers */
#define  MAXSRVS   50
/*       Max Channels */
#define  MAXCHNLS  50
/*       Max Server Send Queue Lines */
#define  MAXSENDQ  300
/*       Max Queue Size */
#define  MAXQUEUE  100
/*       Max Number of Transfers */
#define  MAXTRANS  100
/*       Max Number of Uploads */
#define  MAXUPLDS  10
/*       Max number of adminhosts */
#define  MAXAHOST  10
/*       Max XDCC's Offered */
#define  MAXXDCCS  100
/*       max size for xdcc list queue */
#define  MAXXLQUE  5
/*       max config files */
#define  MAXCONFIG  10
/*       Max meminfo */
#define  MAXMEMINFO 4000
/*       Max meminfo */
#define  HIGHMEMINFOSTART 2000
/*       Max context log */
#define  MAXCONTEXTS 100
/*       Server Connection Timeout In Seconds */
#define  CTIMEOUT  10
/*       How Long to Wait Until We Giveup On A Non-responding Server */
#define  SRVRTOUT  240

/*       max number of people to keep track of in ignore list */
#define  MAXIGNL  500
/*       tollerance for ignore, seconds/request to decrement bucket */
#define  IGN_TL    10
/*       threshhold for ignore, number of requests in bucket */
#define  IGN_ON    8
/*       threshhold for un-ignore, number of requests in bucket */
#define  IGN_OFF   0

/*       weight for speed calcualtion in dcl initial */
#define  DCL_SPDW_I  0.5
/*       weight for speed calcualtion in dcl ongoing */
#define  DCL_SPDW_O  0.9
/*       time until minspeed checking becomes active */
#define  MIN_TL    60

/*       buffer size */
#define  BUFFERSIZE 4096
/*       max BUFFERSIZE blocks to write per cycle */
#define  tbufsize  30

/*       notify level for server queue */
#define  srvqnotify  60

/*       max/min for needsdata member of transfer struct */
#define  needsdatamax 100
#define  needsdatamin -100

/*       excess flood protection */
#define  EXCESS_LEVEL_0  15
#define  EXCESS_LEVEL_1   6
#define  EXCESS_LEVEL_2   4
#define  EXCESS_LEVEL_3   2

/* free'ing just leads to trouble if we dont check first and then make NULL */
#define mydelete(x) {mydeletepart(x); x=NULL;}

#define  maxtextlengthshort 60
#define  maxtextlength 512

/* type definitions for igninfo flags */
#define IGN_MANUAL      1
#define IGN_IGNORING    2
#define IGN_FIRSTIGNORE 4
#define IGN_RANGE       8

/* type definitions for channel_t flags */
#define CHAN_ONCHAN     1
#define CHAN_MINIMAL    2
#define CHAN_SUMMARY    4
#define CHAN_CUSTOM     8

/* Maximum number of advert lines */
#define MAXADVERTS      20

/* type definistions: Screen, Log, DCC CHAT */
#define OUT_S    1
#define OUT_L    2
#define OUT_D    4

/* some os's (cygwin, cough, cough, ... ) require extra flags to open() */
#define ADDED_OPEN_FLAGS 0

/* where would we be without these? */
#define max2(a,b) ( (a > b) ? a : b )
#define min2(a,b) ( (a < b) ? a : b )
#define max3(a,b,c) ( max2(a,max2(b,c)) )
#define min3(a,b,c) ( min2(a,min2(b,c)) )
#define between(min,a,max) ( max2(min2(a,max),min) )

#if 0
/* less confusion if we use these */
typedef char                     int8;
typedef short int                int16;
typedef long int                 int32;
typedef long long int            int64;

typedef unsigned char            uint8;
typedef unsigned short int       uint16;
typedef unsigned long int        uint32;
typedef unsigned long long int   uint64;
#endif

/* set os specific values */
/* linux */
#if defined(_OS_Linux)
#define _GNU_SOURCE

/* bsd */
#elif defined(_OS_FreeBSD)   || \
    defined(_OS_OpenBSD)     || \
    defined(_OS_NetBSD)      || \
    defined(_OS_BSDI)        || \
    defined(_OS_BSD_OS)      || \
    defined(_OS_Darwin)
#define _OS_BSD_ANY

/* sunos */
#elif defined(_OS_SunOS)

/* HP-UX */
#elif defined(_OS_HPUX)

/* IRIX */
#elif defined(_OS_IRIX)

/* IRIX64 */
#elif defined(_OS_IRIX64)

/* Digital UNIX */
#elif defined(_OS_OSF1)

/* MacOS X Server */
#elif defined(_OS_Rhapsody)

/* MacOS X */
#elif defined(_OS_Darwin)

/* CYGWIN */
#elif defined(_OS_CYGWIN)
#undef USESCREEN
#define USESCREEN 0
#undef ALLOWBACKGROUND
#define ALLOWBACKGROUND 0
#undef ADDED_OPEN_FLAGS
#define ADDED_OPEN_FLAGS O_BINARY

/* AIX */
#elif defined(_OS_AIX)

/* other */
#else
#error "*** ERROR: This OS Is Not Supported Or You Didn't Run Configure ***"
#endif

#endif

/* End of File */
