/*      
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) upload.c 1.15@(#)
 * pmg@alliance.centerclick.org|src/upload.c|20011110151512|26731
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"


void l_initvalues (upload * const l) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

      l->status = 'U';
      l->clientsocket=1000;
      l->filedescriptor=1000;
      l->lastcontact = gdata.curtime;
   }

void l_establishcon (upload * const l) {
   struct sockaddr_in remoteaddr;
   struct sockaddr_in localaddr;
   struct hostent *localhost;
   SIGNEDSOCK int addrlen;
   int retval;
   char fullfile[maxtextlength];
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   /* local file already exists? */
   isnprintf(fullfile,maxtextlength-1,"%s/%s",gdata.uploaddir,l->file);
   
   l->filedescriptor=open(fullfile, O_WRONLY | O_CREAT | O_EXCL | ADDED_OPEN_FLAGS, S_IRUSR | S_IWUSR );
   if (l->filedescriptor < 0 && errno == EEXIST) {
      l_closeconn(l,"File Error, That filename already exists");
      return;
      }
   if (l->filedescriptor < 0) {
      l_closeconn(l,"File Error, File couldn't be opened for writing");
      return;
      }
   
   bzero ((char *) &remoteaddr, sizeof (remoteaddr));
   
   l->clientsocket = socket( AF_INET, SOCK_STREAM, 0);
   if (l->clientsocket < 0) {
      l_closeconn(l,"Socket Error");
      return;
      }
   
   remoteaddr.sin_family = AF_INET;
   remoteaddr.sin_port = htons(l->remoteport);
   remoteaddr.sin_addr.s_addr = htonl(l->remoteip);
   
   if (gdata.virthost) {
      if (!gdata.vhost_ip) outerror(0,"virthost = yes, but no vhost_ip set");
      bzero((char*)&localaddr, sizeof(struct sockaddr_in));
      localaddr.sin_family = AF_INET;
      localaddr.sin_port = 0;
      if (( localhost = gethostbyname(gdata.vhost_ip)) == NULL) {
         l_closeconn(l,"Can't Resolve Virtual Host, Sorry");
         return;
         }
      memcpy(&localaddr.sin_addr, *((struct in_addr **)localhost->h_addr_list), sizeof(struct in_addr));
      if (bind(l->clientsocket, (struct sockaddr *) &localaddr, sizeof(localaddr)) < 0) {
         l_closeconn(l,"Couldn't Bind Virtual Host, Sorry");
         return;
         }
      }
   
   if (set_socket_nonblocking(l->clientsocket,1) < 0 )
      outerror(2,"Couldn't Set Non-Blocking");
   
   alarm(CTIMEOUT);
   retval = connect(l->clientsocket, (struct sockaddr *) &remoteaddr, sizeof(remoteaddr));
   if ( (retval < 0) && !((errno == EINPROGRESS) || (errno == EAGAIN)) ) {
      l_closeconn(l,"Couldn't Connect");
      alarm(0);
      return;
      }
   alarm(0);
   
   addrlen = sizeof (remoteaddr);
   if (getsockname(l->clientsocket,(struct sockaddr *) &remoteaddr, &addrlen) < 0) {
      l_closeconn(l,"Couldn't get sock name");
      return;
      }
   
   highestsock();
   
   l->status = 'T';
   notice(l->nick,"DCC Send Accepted, Connecting...");
   
   }


void l_transfersome (upload * const l) {
   int i, howmuch, howmuch2;
   unsigned long g;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (l->status == 'E') return;
   
   howmuch = BUFFERSIZE;
   howmuch2 = 1;
   for (i=0; i<tbufsize; i++) {
      if (howmuch == BUFFERSIZE && howmuch2 > 0) {
         
         howmuch  = read(l->clientsocket, gdata.sendbuff, BUFFERSIZE);
         if (howmuch < 0) { l->status = 'E'; return;}
         
         howmuch2 = write(l->filedescriptor, gdata.sendbuff, howmuch);
         if (howmuch2 != howmuch) { l->status = 'E'; return;}
         
         if (howmuch > 0) l->lastcontact = gdata.curtime;
         
         l->bytesgot += howmuch2;
         gdata.xdccsent[gdata.curtime%120] += howmuch2;
         
         if (gdata.debug2) {
            ioutput(0,OUT_S,"0;34","Read %d File %d",howmuch,howmuch2);
            }
         
         }
      
      }
   
   g = htonl(l->bytesgot);
   write(l->clientsocket,(unsigned char*)&g,4);
   
   if (l->bytesgot >= l->totalsize) {
      long timetook;
      l->status = 'W';
      
         timetook = gdata.curtime - l->connecttime - 1;
         if (timetook < 1)
            timetook = 1;
         
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;35",
              "DCC Upload: Transfer Completed (%li kbytes, %li %s %li %s, %0.1f kbytes/sec)",
              (long)((l->totalsize)/1024),
              (timetook < 3600) ? (long)(timetook/60) : (long)(timetook/60/60),
              (timetook < 3600) ? "min" : "hr",
              (timetook < 3600) ? timetook%60 : (timetook/60)%60,
              (timetook < 3600) ? "sec" : "min",
              ((float)l->totalsize)/1024.0/((float)timetook)
              );

         notice(l->nick,"*** Upload Completed (%li kbytes, %li %s %li %s, %0.1f kbytes/sec)",
              (long)((l->totalsize)/1024),
              (timetook < 3600) ? timetook/60 : timetook/60/60,
              (timetook < 3600) ? "min" : "hr",
              (timetook < 3600) ? timetook%60 : (timetook/60)%60,
              (timetook < 3600) ? "sec" : "min",
              ((float)l->totalsize)/1024.0/((float)timetook)
              );
         
         if (gdata.debug) {
            ioutput(1,OUT_S,"0;33","clientsock = %d",l->clientsocket);
            }
         FD_CLR(l->clientsocket, &gdata.readset);
         close(l->clientsocket);
         close(l->filedescriptor);
         l->status='D';
         highestsock();
      
      }
   
   }


void l_istimeout (upload * const l) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if ( XFR_TMOUT && (gdata.curtime - l->lastcontact > 180)) {
      if (!gdata.attop) gototop();
      l_closeconn(l,"DCC Timeout (180 Sec Timeout)");
      }
   }


void l_closeconn(upload * const l, const char *msg) {
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","Upload: Connection closed: %s",msg);
   
   if (gdata.debug) printf("\x1b[0;33mclientsock = %i\x1b[0m\n",l->clientsocket);
   if (l->clientsocket != 1000 && l->clientsocket > 3) {
      FD_CLR(l->clientsocket, &gdata.writeset);
      FD_CLR(l->clientsocket, &gdata.readset);
      close(l->clientsocket);
      }
   if (l->filedescriptor != 1000 && l->filedescriptor > 3)
      close(l->filedescriptor);
   l->status='D';
   highestsock();
   
   notice(l->nick,"*** Closing Upload Connection: %s",msg);
   }



/* End of File */
