/*      
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) utilities.c 1.53@(#)
 * pmg@alliance.centerclick.org|src/utilities.c|20011110162745|06754
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"


void msleep (int msec) {
   usleep((long)(msec*1000));
   }

int strcmppart (const char *str, const char *match) {
   int temp, i;
   
   if (!str || !match) return 0;
   
   if ( strlen(str) < strlen(match) ) return 0;

   temp=0;
   
   for (i=0; i<sstrlen(match); i++)
      if ( str[i] != match[i] )
         temp++;
   
   if (temp == 0)
      return 1;
   else
      return 0;
   
   }

int strcmpany (const char *str1, const char *match1) {
   int temp, i, j, found;
   char *str, *match;
   
   if (!str1 || !match1) return 0;
   if ( strlen(str1) < strlen(match1) ) return 0;
   
   str   = mycalloc(strlen(str1)+1,"strcmpany");
   match = mycalloc(strlen(match1)+1,"strcmpany");
   
   strncpy(str,str1,strlen(str1)+1);
   caps(str);
   strncpy(match,match1,strlen(match1)+1);
   caps(match);
   
   found=0;
   for (j=0; j<sstrlen(str)-sstrlen(match)+1; j++) {
      temp=0;
      for (i=0; i<sstrlen(match); i++)
         if ( str[i+j] != match[i] )
            temp++;
      if (temp == 0) found = 1;
      }
   
   mydelete(str);
   mydelete(match);
   
   return found;
   }

int strcmpend (const char *str, const char *match) {
   int temp, i,j;
   
   if (!str || !match) return 0;
   
   if ( strlen(str) < strlen(match) ) return 0;

   temp=0;
   
   for (i=strlen(str)-1, j=strlen(match)-1; i>=0 && j>=0; i--,j--)
      if ( str[i] != match[j] )
         temp++;
   
   if (temp == 0)
      return 1;
   else
      return 0;
   
   }

char* getpart(const char *line, int howmany, const char *src) {
   char *part;
   int i,j,k;
   i=0; j=0;
   
   for (k=1; k<howmany; k++) {
      while (line[i] != ' ')
         if (line[i] == '\0') {
            return NULL;
            }
         else
            i++;
      i++;
      }
   
   if (line[i] == '\0')
     return NULL;
   
   part = mycalloc(maxtextlength,src);
   
   while (line[i] != ' ' && line[i] != '\0') {
      part[j] = line[i];
      i++; j++;
      }
   part[j]='\0';

   
   return part;
   }

char capchar(const char c)
{
  return (c>='a' && c<='z')?(c-32):c;
}

char* caps(char *text) {
   int i;
   if (text)
      for (i=0; i<sstrlen(text); i++)
          if ( text[i] >= 'a' && text[i] <= 'z' )
             text[i] = text[i]-32;
   return text;
   }

char* nocaps(char *text) {
   int i;
   if (text)
      for (i=0; i<sstrlen(text); i++)
          if ( text[i] >= 'A' && text[i] <= 'Z' )
             text[i] = text[i]+32;
   return text;
   }


char* sizestr(int spaces, char* str, unsigned long num) {
   
   if      (num >= 1024*1024*1000)
      /* >1000MB */
      isnprintf(str,5,"%2.1fG",(((float)num)/(1024.0*1024.0*1024.0)));
   else if (num >= 1024*1024*10)
      /* >10MB */
      isnprintf(str,5,spaces?"%3.0fM":"%.0fM",(((float)num)/(1024.0*1024.0)));
   else if (num >= 1024*1000)
      /* >1000k */
      isnprintf(str,5,"%2.1fM",(((float)num)/(1024.0*1024.0)));
   else if (num >= 1024)
      /* >1k */
      isnprintf(str,5,spaces?"%3.0fK":"%.0fK",(((float)num)/1024.0));
   else if (num >= 1)
      /* <1k */
      isnprintf(str,5,spaces?" <1K":"<1K");
   else {
      outerror(2,"File size unknown");
      isnprintf(str,5,"???K");
      }
   
   return str;
   }

int highestsock (void) {
   int i,highest;
   highest = 0;
   
   highest = gdata.ircserver;
   
   if (gdata.dccchat != 1000 && gdata.dccchat > highest)
      highest = gdata.dccchat;
   if (gdata.dccchatlisten != 1000 && gdata.dccchatlisten > highest)
      highest = gdata.dccchatlisten;
   
   for (i=0; i<MAXTRANS; i++)
      if (gdata.trans[i] != NULL) {
         if (gdata.trans[i]->listensocket > highest && gdata.trans[i]->listensocket != 1000)
            highest = gdata.trans[i]->listensocket;
         if (gdata.trans[i]->clientsocket > highest && gdata.trans[i]->clientsocket != 1000)
            highest = gdata.trans[i]->clientsocket;
         }
   for (i=0; i<MAXUPLDS; i++)
      if (gdata.uploads[i] != NULL) {
         if (gdata.uploads[i]->clientsocket > highest && gdata.uploads[i]->clientsocket != 1000)
            highest = gdata.uploads[i]->clientsocket;
         }
   gdata.highests = highest;
   if (gdata.debug) {
      ioutput(0,OUT_S,"0;33","highest socket = %d",gdata.highests);
      }
   return highest;
   }

float getEngineerval(const float value, const char *engfix, char *res)
{
  float fval=value;
  int x,y;
  if ((engfix==NULL) || (y=strlen(engfix)<1) || (res==NULL))
    return 0;
  y--;
  for (x=0;x<y && fval>1024;x++, fval/=1024.0);
  *res=engfix[x];
  return fval;
}



void getos (void) {

   struct utsname u1;

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   gdata.highmeminfo = 1;
   
   if ( uname(&u1) < 0)
      outerror(0,"Couldn't Get Your OS Type");
   
   printf("*** You Are Running %s %s on a %s",u1.sysname,u1.release,u1.machine);
/*        << "*** You Are Running " */
/*        << u1.sysname << " " */
/*//        << u.nodename << " " */
/*        << u1.release << " on a " */
/*//        << u.version << " " */
/*        << u1.machine; */
   
   gdata.osstring = mycalloc(maxtextlengthshort,"getos_osstring");
   
   isnprintf(gdata.osstring,maxtextlengthshort-2,"%s %s",u1.sysname,u1.release);
   
   /* verify we are who we were configured for, and set config */
#if defined(_OS_Linux)
   if (strcmp(u1.sysname,"Linux"))
      outerror(1,"Configured for Linux but not running Linux?!?");
   printf(", Good\n");
   
#elif defined(_OS_FreeBSD)   || \
    defined(_OS_OpenBSD)     || \
    defined(_OS_NetBSD)      || \
    defined(_OS_BSDI)        || \
    defined(_OS_BSD_OS)
   if (strcmp(u1.sysname,"FreeBSD") && strcmp(u1.sysname,"OpenBSD") && strcmp(u1.sysname,"BSD/OS") && strcmp(u1.sysname,"NetBSD"))
      outerror(1,"Configured for *BSD but not running *BSD?!?");
   printf(", Good\n");

#elif defined(_OS_SunOS)
   if (strcmp(u1.sysname,"SunOS"))
      outerror(1,"Configured for Solaris but not running Solaris?!?");
   printf(", Good\n");

#elif defined(_OS_HPUX)
   if (strcmp(u1.sysname,"HP-UX"))
      outerror(1,"Configured for HP-UX but not running HP-UX?!?");
   printf(", Good\n");
   
#elif defined(_OS_IRIX)
   if (strcmp(u1.sysname,"IRIX"))
      outerror(1,"Configured for IRIX but not running IRIX?!?");
   printf(", Good\n");

#elif defined(_OS_IRIX64)
   if (strcmp(u1.sysname,"IRIX64"))
      outerror(1,"Configured for IRIX64 but not running IRIX64?!?");
   printf(", Good\n");

#elif defined(_OS_OSF1)
   if (strcmp(u1.sysname,"OSF1"))
      outerror(1,"Configured for OSF1 but not running OSF1?!?");
   printf(", Good\n");

#elif defined(_OS_Rhapsody)
   if (strcmp(u1.sysname,"Rhapsody"))
      outerror(1,"Configured for Rhapsody but not running Rhapsody?!?");
   printf(", Good\n");

#elif defined(_OS_Darwin)
   if (strcmp(u1.sysname,"Darwin"))
      outerror(1,"Configured for Darwin but not running Darwin?!?");
   printf(", Good\n");

#elif defined(_OS_AIX)
   if (strcmp(u1.sysname,"AIX"))
      outerror(1,"Configured for AIX but not running AIX?!?");
   printf(", Good\n");

#elif defined(_OS_CYGWIN)
   if (!strcmppart(u1.sysname,"CYGWIN"))
     {
       outerror(1,"Configured for CYGWIN but not running CYGWIN?!?");
     }
   {
     int count,v1=0,v2=0,v3=0;
     count = sscanf(u1.release,"%d.%d.%d",&v1,&v2,&v3);
     if (
	 (v1 < 1) ||
	 ((v1 == 1) && (v2 < 1)) ||
	 ((v1 == 1) && (v2 == 1) && (v3 < 7))
	 )
       {
	 printf(", Too Old\n");
	 outerror(0,"CYGWIN too old (1.1.7 or greater required)");
       }
   }
   printf(", Good\n");

#else
   printf(", I don't know of that!\n");

#endif

   
   gdata.highmeminfo = 0;
   }

int getend(int amt, int num) {
   
   if (num < 0)
      return num+amt;
   else
      return num;
   
   }

int getbeg(int amt, int num) {
   
   if (num > amt-1)
      return num-amt;
   else
      return num;
   
   }

int getsrv(int amt, int num) {
   
   if (num < 1)
      return num+amt;
   else
      return num;
   
   }


void floodchk(void) {
   int i,count,last;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   count = 0;
   last = gdata.ignore;
   
   for (i=0; i<10; i++) {
      count += gdata.inamnt[i];
      }

   if (count > 6 && RCV_FPROT)
      gdata.ignore = 1;
   else
      gdata.ignore = 0;
   
   if (last - gdata.ignore == -1) {
      if (!gdata.attop) gototop();
      outerror(2,"Flood Protection Activated");
      }
   if (last - gdata.ignore == 1) {
      if (!gdata.attop) gototop();
      outerror(2,"Flood Protection Deactivated");
      }
   
   }

void outerror (int type, const char *format, ...) {
   char tempstr[maxtextlength];
   va_list args;
   int ioutput_options = OUT_S|OUT_L|OUT_D;

   /* can't log an error if the error was due to logging */
   if (type & 0x80)
     {
       ioutput_options &= ~0x80;
     }
   type &= ~0x80;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   va_start(args, format);
   ivsnprintf(tempstr,maxtextlength-2,format,args);
   va_end(args);
   
   if (!gdata.background && !gdata.attop) gototop();
   
   if ( type == 0 ) {
      
      ioutput(0,ioutput_options,"1;31","ERROR: %s",tempstr);
      
      if (!gdata.background)
         printf("\x1b[r\x1b[%i;1H\n",gdata.termlines);
      else
         printf("*** ERROR: %s\n\n",tempstr);
         
      mylog(0,"iroffer exited (Error)\n\n");
      if (gdata.pidfile) unlink(gdata.pidfile);

      exit(1);
      }
   else if (type == 1 ) {
      ioutput(0,ioutput_options,"1;31","WARNING: %s",tempstr);
      if (gdata.background)
         printf("*** WARNING: %s\n",tempstr);
      }
   else if (type == 2 ) {
      ioutput(0,ioutput_options,"0;31","WARNING: %s",tempstr);
      if (gdata.background)
         printf("*** WARNING: %s\n",tempstr);
      }
   
   }

char* getdatestr(char* str, time_t Tp) {
   struct tm *localt = NULL;

   if (Tp == 0) Tp = gdata.curtime;
   localt = localtime(&Tp);
   strftime (str, 50, "%Y-%m-%d-%H:%M:%S", localt);
   
  /* mydelete(localt); */
   return str;
   }

void mylog(int beg, const char *format, ...) {
   int filedescriptor;
   char tempstr[maxtextlength];
   va_list args;
   
   /* beg = 0, normal */
   /* beg = 1, first part of multiple part line */
   /* beg = 2, middle part of multiple part line */
   /* beg = 3, end of multiple part line */
   
   
   if (gdata.logfile == NULL)
      return;
   
   filedescriptor=open(gdata.logfile, O_WRONLY | O_CREAT | ADDED_OPEN_FLAGS, S_IRUSR | S_IWUSR );
   if (filedescriptor < 0) {
      outerror(1 | 0x80,"Couldn't open/create Log File");
      return;
      }
   
   lseek(filedescriptor, 0, SEEK_END);
   
   if (beg < 2) {
      write(filedescriptor,"** ",3);
      getdatestr(tempstr,0);
      write(filedescriptor,tempstr,strlen(tempstr));
      write(filedescriptor,": ",2);
      }
   
   va_start(args, format);
   ivsnprintf(tempstr,maxtextlength-2,format,args);
   va_end(args);
   
   write(filedescriptor,tempstr,strlen(tempstr));
   
   if (beg == 0 || beg == 3)
      write(filedescriptor,"\n",1);
   
   close(filedescriptor);
   
   }


void logstat(void) {
   int filedescriptor;
   char *tempstr, *tempstr2;
   
   if (gdata.logfile == NULL)
      return;
   
   tempstr = mycalloc(maxtextlength,"logstat");
   tempstr2 = mycalloc(maxtextlengthshort,"logstat");
   
   filedescriptor=open(gdata.logfile, O_WRONLY | O_CREAT | ADDED_OPEN_FLAGS, S_IRUSR | S_IWUSR );
   if (filedescriptor < 0) {
      outerror(1 | 0x80,"Couldn't open/create Log File");
      return;
      }
   
   lseek(filedescriptor, 0, SEEK_END);
   
   write(filedescriptor,"** ",3);
   getdatestr(tempstr,0);
   write(filedescriptor,tempstr,strlen(tempstr));
   write(filedescriptor,": ",2);
   
   
   getstatusline(tempstr);
      
   write(filedescriptor,tempstr,strlen(tempstr));

   write(filedescriptor,"\n",1);
   
   close(filedescriptor);
   
   mydelete(tempstr);
   mydelete(tempstr2);
   
   }

unsigned long atoul (const char *str) {
   unsigned long num,temp;
   int i,j;
   if (str == NULL) return 0;
   
   num = 0;
   
   for (i=strlen(str)-1; i>=0; i--) {
      temp = (str[i]-'0');
      for (j=strlen(str)-1; j>i; j--)
         temp *= 10;
      num += temp;
      }
   return num;
   }

unsigned long long atoull (const char *str) {
   unsigned long long num,temp;
   int i,j;
   if (str == NULL) return 0;
   
   num = 0;
   
   for (i=strlen(str)-1; i>=0; i--) {
      temp = (str[i]-'0');
      for (j=strlen(str)-1; j>i; j--)
         temp *= 10;
      num += temp;
      }
   return num;
   }

void ioutput(int beg, int dest, const char *color, const char *format, ...) {
   char tempstr[maxtextlength];
   va_list args;
   
   va_start(args, format);
   ivsnprintf(tempstr,maxtextlength-2,format,args);
   va_end(args);
   
   /* beg = 0, normal */
   /* beg = 1, first part of multiple part line */
   /* beg = 2, middle part of multiple part line */
   /* beg = 3, end of multiple part line */
   
   /* screen */
   if (!gdata.background && (dest & OUT_S)) {
      
      if (!gdata.attop) gototop();
      
      if (beg == 0 || beg == 1) {
         if (USECOLOR && color)
            printf("\x1b[%sm",color);
         printf("*** ");
         }
      
      printf("%s",tempstr);
      
      if (beg == 0 || beg == 3) {
         if (USECOLOR && color)
            printf("\x1b[0m\n");
         else
            printf("\n");
         }
      }
   
   /* log */
   if (dest & OUT_L)
      mylog(beg,"%s",tempstr);
   
   /* dcc chat */
   if (gdata.dccchat != 1000 && gdata.dccchatin && (dest & OUT_D)) {
      
      
      if (beg == 0 || beg == 1)
         write(gdata.dccchat,"--> ",4);
      write(gdata.dccchat,tempstr,strlen(tempstr));
      
      if (beg == 0 || beg == 3) write(gdata.dccchat,"\n",1);
      
      if (!gdata.background && gdata.debug) {
         if (!gdata.attop) gototop();
         if (beg == 0 || beg == 1)
            printf("\x1b[0;36m<DCC<: ");
         printf(tempstr);
         if (beg == 0 || beg == 3)
            printf("\x1b[0m");
         }

      }
   
   }

void allchanmsg(const char *message)
{
  int i;
  char temp[maxtextlength];
  temp[0]=0;
  for (i=0; gdata.channels[i] && i<MAXCHNLS; i++)
    {
      if (temp[0]!=0)
	strncat(temp,",",maxtextlength-strlen(temp)-1);
      strncat(temp,gdata.channels[i]->name,maxtextlength-strlen(temp)-1);
    }
  privmsg (temp, "%s", message);
}

void privmsg(const char *nick, const char *format, ...) {
   char tempstr[maxtextlength];
   char tempstr2[maxtextlength];
   va_list args;
   
   if (!nick) return;
   
   va_start(args, format);
   ivsnprintf(tempstr,maxtextlength-2,format,args);
   va_end(args);
   
   isnprintf(tempstr2,maxtextlength-1,"PRIVMSG %s :%s",nick,tempstr);
   
   writeserver(tempstr2);
   
   }

void notice(const char *nick, const char *format, ...) {
   char tempstr[maxtextlength];
   char tempstr2[maxtextlength];
   va_list args;
   
   if (!nick) return;
   
   va_start(args, format);
   ivsnprintf(tempstr,maxtextlength-2,format,args);
   va_end(args);
   
   isnprintf(tempstr2,maxtextlength-1,"NOTICE %s :%s",nick,tempstr);
   
   writeserver(tempstr2);
   
   }

char* hostmasktoregex(char *str) {
   char *tempstr;
   int i,j;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (!str) return NULL;
   
   tempstr = mycalloc(maxtextlength,"hostmasktoregex");
   
   strncpy(tempstr,"^",maxtextlength-1);
   
   for (i=0,j=1; i<sstrlen(str); i++,j++) {
      if ( (str[i] >= 'a' && str[i] <= 'z')
        || (str[i] >= 'A' && str[i] <= 'Z')
        || (str[i] >= '0' && str[i] <= '9') )
         tempstr[j] = str[i];
      else if (str[i] == '?')
         tempstr[j] = '.';
      else if (str[i] == '*') {
         tempstr[j] = '.'; j++;
         tempstr[j] = '*';
         }
      else if (str[i] == '#') {
         tempstr[j] = '['; j++;
         tempstr[j] = '0'; j++;
         tempstr[j] = '-'; j++;
         tempstr[j] = '9'; j++;
         tempstr[j] = ']'; j++;
         tempstr[j] = '['; j++;
         tempstr[j] = '0'; j++;
         tempstr[j] = '-'; j++;
         tempstr[j] = '9'; j++;
         tempstr[j] = ']'; j++;
         tempstr[j] = '*';
         }
      else {
         tempstr[j] = '\\'; j++;
         tempstr[j] = str[i];
         }
      }
   
   tempstr[j] = '$';
   tempstr[j+1] = '\0';
   
   strncpy(str,tempstr,maxtextlength-1);
   mydelete(tempstr);
   
   return str;
   
   }

int verifyadmin(const char *hmask) {
   int i,found = 0;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   for (i=0; i<MAXAHOST; i++)
      if (gdata.adminhost[i] != NULL && !regexec(gdata.adminhost[i],hmask,0,NULL,0))
         found=1;

   return found;
   }

int verifypass(const char *testpass) {
   
#if ENCRYPTPASS
   char *pwout;

   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if ( !gdata.adminpass || !testpass )
     return 0;
   
   if (
     strlen(gdata.adminpass) != 13
     || strlen(testpass) < 5
     || strlen(testpass) > 8
     )
     return 0;
   
   pwout = crypt(testpass,gdata.adminpass);
   
   if (strcmp(pwout,gdata.adminpass)) return 0;
#else
   if ( !gdata.adminpass || !testpass )
     return 0;
   
   if (strcmp(testpass,gdata.adminpass)) return 0;
#endif
   
   return 1;
   
   }

int packnumtonum(char *a) {
   
   if (!a) return 0;
   
   if (a[0] == '#') a++;
   
   return atoi(a);
   
   }


int sstrlen (const char *p) {
   if (!p) return -1;
   return ((int)(strlen(p)));
   }

char dayofweektomask(const char a) {
   switch (a) {
      case 'U':
         return 0x01;
      case 'M':
         return 0x02;
      case 'T':
         return 0x04;
      case 'W':
         return 0x08;
      case 'R':
         return 0x10;
      case 'F':
         return 0x20;
      case 'S':
         return 0x40;
      default:
         return 0x00;
      }
   return 0;
   }


void msglog_add(char* hostmask, char* line) {
   int filedescriptor, i, j;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (gdata.messagefile == NULL)
      return;
   
   filedescriptor=open(gdata.messagefile, O_WRONLY | O_CREAT | ADDED_OPEN_FLAGS, S_IRUSR | S_IWUSR );
   if (filedescriptor < 0) {
      outerror(1,"Couldn't open/create Message File");
      return;
      }
   
   lseek(filedescriptor, 0, SEEK_END);
   
   for (i=0, j=0; i<sstrlen(line) && j<3; i++)
      if (line[i] == ' ') j++;
   i++;
   
   for (j=i; j<sstrlen(line)+1; j++)
      line[j-i] = line[j];
   
   tempstr = mycalloc(maxtextlength,"msglog_add");
   isnprintf(tempstr,maxtextlength-2,"%010lu %s %s\n",gdata.curtime,nocaps(hostmask),line);
   write(filedescriptor,tempstr,strlen(tempstr));
   mydelete(tempstr);
   
   close(filedescriptor);
   
   }

char* msglog_howmany(char *str) {
   int fd,count=0;
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   fd=open(gdata.messagefile, O_RDONLY | ADDED_OPEN_FLAGS);
   if (fd < 0) {
      isnprintf(str,maxtextlengthshort-2,"msglog: messagefile couldn't be opened");
      return str;
      }
   
   tempstr = mycalloc(maxtextlength,"msglog_howmany_tempstr");
   while (( getfline(tempstr,fd,0)) != NULL) {
      count++;
      }
   mydelete(tempstr);
   close(fd);
   
   isnprintf(str,maxtextlength-2,
   "*** You have %i message%s in the message log%s",count,count!=1?"s":"",count?", use MSGREAD to read them":"");
   
   return str;
   }

/* reverse a string */
char *strrev(char *str) {
   int i,len;
   char c;
   
   len = sstrlen(str);
   for (i=0; i<len/2; i++) {
      c = str[i];
      str[i] = str[len-i];
      str[len-i] = c;
      }
   
   return str;
   }

int isprintable(char a) {
   if ( a >= 0x20 && a <= 0x7E )
      return 1;
   else
      return 0; 
   }

char onlyprintable(char a) {
   if ( a >= 0x20 && a <= 0x7E )
      return a;
   else
      return '.'; 
   }

void* mycalloc(int a, const char *r) {
   void *t = NULL;
   int i,start=0;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   for (i=0; (i<100 && t == NULL); i++)
      t = calloc(a,1);
   
   if (t == NULL)
      outerror(0,"Couldn't Allocate Memory After 100 Attempts!!");
   
#if MEMINFOCHECK
   
   if (gdata.highmeminfo) start=HIGHMEMINFOSTART;
   
   for (i=start; (i<MAXMEMINFO && gdata.meminfo[i].ptr); i++) ;
   
   if (i == MAXMEMINFO) { i--; outerror(2,"Out of meminfo slots!"); }
   
   gdata.meminfo[i].ptr       = t;
   gdata.meminfo[i].src       = r;
   gdata.meminfo[i].alloctime = gdata.curtime;
   gdata.meminfo[i].size      = a;
   
#endif   
   
   return t;
   }

void mydeletepart(void *t) {
   unsigned char *ut = (unsigned char *)t;
   int i;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (t == NULL) return;
   
#if MEMINFOCHECK
   
   for (i=0; (i<MAXMEMINFO && (gdata.meminfo[i].ptr != t)); i++) ;
   
   if (i == MAXMEMINFO) {
      outerror(1,"Pointer 0x%8.8lX not found in meminfo database while trying to free!!",(long)t);
      outerror(1,"Please report this error to PMG");
      for(i=0; i<(12*12); i+=12) {
         outerror(1," : %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X = \"%c%c%c%c%c%c%c%c%c%c%c%c\"",
               ut[i+0], ut[i+1], ut[i+2], ut[i+3], ut[i+4], ut[i+5], ut[i+6], ut[i+7], ut[i+8], ut[i+9], ut[i+10], ut[i+11],
               onlyprintable(ut[i+0]), onlyprintable(ut[i+1]),
               onlyprintable(ut[i+2]), onlyprintable(ut[i+3]),
               onlyprintable(ut[i+4]), onlyprintable(ut[i+5]),
               onlyprintable(ut[i+6]), onlyprintable(ut[i+7]),
               onlyprintable(ut[i+8]), onlyprintable(ut[i+9]),
               onlyprintable(ut[i+10]), onlyprintable(ut[i+11]));
         }
      outerror(1,"Aborting Program! (core file should be generated)");
      abort(); /* getting a core file will help greatly */
      }
   else {
      free(t);
      
      gdata.meminfo[i].ptr       = NULL;
      gdata.meminfo[i].src       = NULL;
      gdata.meminfo[i].alloctime = 0;
      gdata.meminfo[i].size      = 0;
      
      }
      
#else
   free(t);
#endif   
   
   return;
   }

char* removenonprintable(char *str1) {
   int i;
   unsigned char *str = (unsigned char*)str1;
   
   if (!str) return NULL;
   
   for (i=0; i<strlen(str); i++) {
      if (!((str[i] >= 0x20 && str[i] <= 0x7E) ||
            (str[i] >= 0xA1 && str[i] <= 0xFF) ||
            str[i] == 0x01 ||  /* ctcp */
            str[i] == 0x02 ||  /* bold */
            str[i] == 0x03 ||  /* color */
            str[i] == 0x09 ||  /* tab */
            str[i] == 0x0A ||  /* return */
            str[i] == 0x0D ||  /* return */
            str[i] == 0x0F ||  /* end formatting */
            str[i] == 0x16 ||  /* inverse */
            str[i] == 0x1F ))   /* underline */
      str[i] = '.';
      
      }
   return str;
   }

char* removenonprintablefile(char *str) {
   int i;
   char last='.';
   
   if (!str) return NULL;
   
   for (i=0; i<strlen(str); i++) {
      if (str[i] >= 0x7B) str[i] = '_';
      if (str[i] <  0x2D) str[i] = '_';
      switch (str[i]) {
         case 0x2F:
         case 0x3A:
         case 0x3B:
         case 0x3C:
         case 0x3D:
         case 0x3E:
         case 0x3F:
         case 0x40:
         case 0x5B:
         case 0x5C:
         case 0x5D:
         case 0x5E:
         case 0x5F:
         case 0x60:
            str[i] = '_';
         }
      if (last == '.' && str[i] == '.') str[i] = '_';
      
      last = str[i];
      }
      
   return str;
   }


int doesfileexist(const char *f) {
   int fd;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (!f) return 0;
   
   if ((fd = open(f,O_RDONLY | O_CREAT | O_EXCL | ADDED_OPEN_FLAGS)) < 0 && errno == EEXIST)
      return 1;
   else if (fd < 0)
      return 0;
   
   close(fd);
   unlink(f);
   return 0;
   
   
   }

void joinchannel(channel_t *c) {
   char *tempstr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (!c) return;
   
   tempstr = mycalloc(maxtextlength,"joinchannel");
   
   if (strlen(c->key))
      isnprintf(tempstr,maxtextlength-2,"JOIN %s %s",c->name,c->key);
   else
      isnprintf(tempstr,maxtextlength-2,"JOIN %s",c->name);
   writeserver(tempstr);
   
   mydelete(tempstr);
   
   clearmemberlist(c);
   
   }

void checkadminpass(void) {
#if ENCRYPTPASS
   int err=0,i;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (!gdata.adminpass || strlen(gdata.adminpass) != 13) err++;
   
   for (i=0; !err && i<13; i++) {
      if (!((gdata.adminpass[i] >= 'a' && gdata.adminpass[i] <= 'z') ||
            (gdata.adminpass[i] >= 'A' && gdata.adminpass[i] <= 'Z') ||
            (gdata.adminpass[i] >= '0' && gdata.adminpass[i] <= '9') ||
            (gdata.adminpass[i] == '.') ||
            (gdata.adminpass[i] == '/')))
         err++;
      }
   
   if (err) outerror(1,"adminpass does not appear to be encrypted!");

#else
   outerror(2,"adminpass encryption disabled via defines.h");
#endif   
   }

void updatecontext(const char *file, const char *func, int line)
{
  gdata.context_cur_ptr++;
  if (gdata.context_cur_ptr > (2*MAXCONTEXTS))
    gdata.context_cur_ptr = gdata.context_cur_ptr % MAXCONTEXTS;

  gdata.context_log[gdata.context_cur_ptr % MAXCONTEXTS].file = file;
  gdata.context_log[gdata.context_cur_ptr % MAXCONTEXTS].func = func;
  gdata.context_log[gdata.context_cur_ptr % MAXCONTEXTS].line = line;
  
}


void clearmemberlist(channel_t *c)
{
  channel_member_t *cur, *next;
  
  /* clear members list */
  if (MEMBERDEBUG) printf("clearing %s\n",c->name);
  cur = c->members;
  while ( cur )
    {
      next = cur->next;
      mydelete(cur);
      cur = next;
    }
  
  c->members = NULL;
  
}


int isinmemberlist(const char *nick)
{
  channel_member_t *p;
  int i,found;
  char nick1[maxtextlengthshort];
  
  updatecontext(__FILE__,__FUNCTION__,__LINE__);

  if (MEMBERDEBUG) printf("checking for %s\n",nick);
  
  strncpy(nick1,nick,maxtextlengthshort-1);
  caps(nick1);

  for (found=i=0; i<MAXCHNLS; i++)
    if (gdata.channels[i])
      {
	p = gdata.channels[i]->members;
	while ( p )
	  {
	    if ( !strcmp(caps(p->nick),nick1) )
	      found++;
	    p = p->next;
	  }
      }
  
  return found;
}


void addtomemberlist(channel_t *c, const char *nick)
{
  channel_member_t *p;
  char nick1[maxtextlengthshort];
  
  updatecontext(__FILE__,__FUNCTION__,__LINE__);

  if (MEMBERDEBUG) printf("adding %s to %s\n",nick,c->name);
  
  strncpy(nick1,nick,maxtextlengthshort-1);
  caps(nick1);
  
  p = c->members;
  
  while ( p )
    {
      if ( !strcmp(p->nick,nick1) )
	break; /* found, p will be non-null */
      p = p->next;
    }
  
  if ( p == NULL)
    {
      /* not found, add at beginning */
      p = c->members;
      c->members = mycalloc(sizeof(channel_member_t)+strlen(nick1),"addtomemberlist");
      strcpy(c->members->nick,nick);
      c->members->next = p;
    }
  
}

void removefrommemberlist(channel_t *c, char *nick)
{
  channel_member_t *p, *p2;
  
  updatecontext(__FILE__,__FUNCTION__,__LINE__);
  
  if (MEMBERDEBUG) printf("removing %s from %s\n",nick,c->name);
  
  caps(nick);
  
  p = c->members;
  
  if ( p && !strcmp(p->nick,nick) )
    {
      /* first */
      p2 = p->next;
      mydelete(p);
      c->members = p2;
      return;
    }
  
  
  while ( p && p->next )
    {
      if ( !strcmp(p->next->nick,nick) )
	break; /* found, p will be non-null */
      p = p->next;
    }
  
  if ( p && p->next)
    {
      /* found */
      p2 = p->next->next;
      mydelete(p->next);
      p->next = p2;
    }
  
}

void changeinmemberlist(channel_t *c, char *oldnick, char *newnick)
{
  channel_member_t *p, *p2;
  
  updatecontext(__FILE__,__FUNCTION__,__LINE__);
  
  if (MEMBERDEBUG) printf("changing %s to %s in %s\n",oldnick,newnick,c->name);
  
  caps(oldnick);
  caps(newnick);
  
  p = c->members;
  
  if ( p && !strcmp(p->nick,oldnick) )
    {
      /* first */
      p2 = p->next;
      mydelete(p);
      c->members = mycalloc(sizeof(channel_member_t)+strlen(newnick),"changeinmemberlist");
      strcpy(c->members->nick,newnick);
      c->members->next = p2;
      return;
    }
  
  while ( p && p->next )
    {
      if ( !strcmp(p->next->nick,oldnick) )
	break; /* found, p will be non-null */
      p = p->next;
    }
  
  if ( p && p->next)
    {
      /* found */
      p2 = p->next->next;
      mydelete(p->next);
      p->next = mycalloc(sizeof(channel_member_t)+strlen(newnick),"changeinmemberlist");
      strcpy(p->next->nick,newnick);
      p->next->next = p2;
    }
  
}

int set_socket_nonblocking (int s, int nonblock)
{
  
#if defined(_OS_CYGWIN)
  /*
   * cygwin doesn't support (as of 1.1.4) non-blocking via a
   * fcntl call, need to use ioctl instead
   */
  return ioctl(s, FIONBIO, &nonblock);
  
#else
  
  if (nonblock)
    return fcntl(s, F_SETFL, O_NONBLOCK);
  else
    return fcntl(s, F_SETFL, 0);
  
#endif
  
}

void set_loginname(void)
{
  struct passwd *p;
  
  gdata.loginname = mycalloc(maxtextlengthshort,"set_loginname");
  p = getpwuid(geteuid());
  if (p == NULL || p->pw_name == NULL)
    {
      outerror(1,"Couldn't Get username, specify loginname in config file");
      strncpy(gdata.loginname,"UNKNOWN",maxtextlengthshort-1);
    }
  else
    {
      strncpy(gdata.loginname,p->pw_name,maxtextlengthshort-1);
    }
  
}


#ifdef NO_SNPRINTF

/* WARNING: THIS FUNCTION IS NOT REENTRANT !!!! */
int mysnprintf(char *str, size_t n, const char *format, ... ) {
   va_list args;
   int actlen;
   
   va_start(args, format);
   actlen = vsprintf(gdata.mysnprintf_buff,format,args);
   va_end(args);
   
   strncpy(str,gdata.mysnprintf_buff,min2(n-1,actlen));
   str[min2(n-1,actlen)] = '\0';
   
   return min2(n-1,actlen);
   }

/* WARNING: THIS FUNCTION IS NOT REENTRANT !!!! */
int myvsnprintf(char *str, size_t n, const char *format, va_list ap ) {
   int actlen;
   
   actlen = vsprintf(gdata.mysnprintf_buff,format,ap);
   
   strncpy(str,gdata.mysnprintf_buff,min2(n-1,actlen));
   str[min2(n-1,actlen)] = '\0';
   
   return min2(n-1,actlen);
   }

#endif

/* End of File */






