/*      
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) dccchat.c 1.37@(#)
 * pmg@alliance.centerclick.org|src/dccchat.c|20011019215807|08064
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"


int setupdccchatout(const char *nick) {
   SIGNEDSOCK int addrlen;
   int listenport;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   addrlen = sizeof (struct sockaddr_in);
   
   if (gdata.dccchat != 1000) {
      writedccchat("Another DCC Chat Request Received");
      writedccchat("Bye.");
      ioutput(0,OUT_S,NULL,"DCC CHAT Switch");
      FD_CLR(gdata.dccchat, &gdata.readset);
      msleep(100);
      close(gdata.dccchat);
      gdata.dccchat = 1000;
      highestsock();
      }
   
   if ((gdata.dccchatlisten = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
      outerror(1,"Could Not Create Socket, Aborting");
      gdata.dccchatlisten = 1000;
      return 1;
      }

   bzero ((char *) &gdata.dccchatlistenaddr, sizeof (struct sockaddr_in));
      
   gdata.dccchatlistenaddr.sin_family = AF_INET;
   gdata.dccchatlistenaddr.sin_addr.s_addr = INADDR_ANY;
  
   gdata.dccchatlistenaddr.sin_port = htons(0);
   
   if ((bind(gdata.dccchatlisten, (struct sockaddr *)&gdata.dccchatlistenaddr, sizeof(struct sockaddr_in))) < 0) {
      outerror(1,"Couldn't Bind to Socket, Aborting");
      gdata.dccchatlisten = 1000;
      return 1;
      }
      

   if ((getsockname (gdata.dccchatlisten, (struct sockaddr *)&gdata.dccchatlistenaddr, &addrlen)) < 0) {
      outerror(1,"Couldn't get Port Number, Aborting");
      gdata.dccchatlisten = 1000;
      return 1;
      }
      
   listenport = ntohs (gdata.dccchatlistenaddr.sin_port);
 
   if (listen (gdata.dccchatlisten, 1) < 0) {
      outerror(1,"Couldn't Listen, Aborting");
      gdata.dccchatlisten = 1000;
      return 1;
      }
  
   highestsock();
   
   privmsg(nick,"\1DCC CHAT CHAT %lu %d\1",gdata.ourip,listenport);
   
   return 0;
   }

void setupdccchataccept(void) {
   SIGNEDSOCK int addrlen;
   char *tempstr, *tempstr2;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (gdata.dccchat != 1000) {
      writedccchat("Another DCC Chat Request Received");
      writedccchat("Bye.");
      ioutput(0,OUT_S,NULL,"DCC CHAT Switch");
      FD_CLR(gdata.dccchat, &gdata.readset);
      msleep(100);
      close(gdata.dccchat);
      gdata.dccchat = 1000;
      highestsock();
      }
   
   addrlen = sizeof (struct sockaddr_in);
   if ((gdata.dccchat = accept(gdata.dccchatlisten, (struct sockaddr *) &gdata.dccchatlistenaddr, &addrlen)) < 0) {
      outerror(2,"Accept Error, Aborting");
      FD_CLR(gdata.dccchatlisten, &gdata.readset);
      close(gdata.dccchatlisten);
      gdata.dccchatlisten = 1000;
      gdata.dccchat = 1000;
      highestsock();
      return;
      }
   
   FD_CLR(gdata.dccchatlisten, &gdata.readset);
   close(gdata.dccchatlisten);
   gdata.dccchatlisten = 1000;
   
   tempstr = mycalloc(maxtextlength,"setupdccchataccept_tempstr");
   tempstr2 = mycalloc(maxtextlength,"setupdccchataccept_tempstr2");
   getuptime(tempstr2,0,gdata.startuptime);
   isnprintf(tempstr,maxtextlength-2,"Welcome to %s\niroffer v%s [%s] By PMG - %s\n"
                                    "    running %s\n"
                                    " \nEnter Your Password:\n",
	     gdata.user_nick,VERSION,VERSIONDATE,gdata.osstring,tempstr2);
   write(gdata.dccchat,tempstr,strlen(tempstr));
   mydelete(tempstr);
   mydelete(tempstr2);
   
   gdata.dccchatin = 0;

   highestsock();
   }

int setupdccchat(const char *line) {
   struct sockaddr_in remoteip;
   struct sockaddr_in localaddr;
   struct hostent *localhost;
   char *ip, *port;
   SIGNEDSOCK int addrlen;
   char *tempstr, *tempstr2;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (gdata.dccchat != 1000) {
      writedccchat("Another DCC Chat Request Received");
      writedccchat("Bye.");
      ioutput(0,OUT_S,NULL,"DCC CHAT Switch");
      FD_CLR(gdata.dccchat, &gdata.readset);
      msleep(100);
      close(gdata.dccchat);
      gdata.dccchat = 1000;
      highestsock();
      }
   
   ip = getpart(line,7,"setupdccchat_ip");
   port = getpart(line,8,"setupdccchat_port");
   
   if ( !ip || !port ) {
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   
   ioutput(0,OUT_S|OUT_L,"0;35","DCC Chat Requested");
   
   bzero ((char *) &remoteip, sizeof (remoteip));
   
   gdata.dccchat = socket( AF_INET, SOCK_STREAM, 0);
   if (gdata.dccchat < 0) {
      outerror(1,"Socket Error");
      gdata.dccchat = 1000;
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   
   port[strlen(port)-1] = '\0';
   
   remoteip.sin_family = AF_INET;
   remoteip.sin_port = htons(atoi(port));
   
/*   if (( remotehost = gethostbyname(hostname)) == NULL) { */
/*      outerror(1,"Can't Resolve Server Host"); */
/*      return 1; */
/*      } */
   
   remoteip.sin_addr.s_addr = htonl(atoul(ip));

/*   memcpy(&remoteip.sin_addr, *((struct in_addr **)remotehost->h_addr_list), sizeof(struct in_addr)); */
   
   if (gdata.virthost) {
      if (!gdata.vhost_ip) outerror(0,"virthost = yes, but no vhost_ip set");
      bzero((char*)&localaddr, sizeof(struct sockaddr_in));
      localaddr.sin_family = AF_INET;
      localaddr.sin_port = 0;
      if (( localhost = gethostbyname(gdata.vhost_ip)) == NULL) {
         outerror(1,"Can't Resolve Virtual Host");
         gdata.dccchat = 1000;
         mydelete(ip);
         mydelete(port);
         return 1;
         }
      memcpy(&localaddr.sin_addr, *((struct in_addr **)localhost->h_addr_list), sizeof(struct in_addr));
      if (bind(gdata.dccchat, (struct sockaddr *) &localaddr, sizeof(localaddr)) < 0) {
         outerror(1,"Couldn't Bind To Virtual Host");
         gdata.dccchat = 1000;
         mydelete(ip);
         mydelete(port);
         return 1;
         }
      }

   alarm(CTIMEOUT);
   if (connect(gdata.dccchat, (struct sockaddr *) &remoteip, sizeof(remoteip)) < 0) {
      outerror(1,"Connection to DCC Chat Failed");
      gdata.dccchat = 1000;
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   alarm(0);
   
   addrlen = sizeof (remoteip);
   if (getsockname(gdata.dccchat,(struct sockaddr *) &remoteip, &addrlen) < 0) {
      outerror(1,"Couldn't get sock name");
      gdata.dccchat = 1000;
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   
   if (gdata.debug) {
      ioutput(0,OUT_S,"0;33","dccchat socket = %d",gdata.dccchat);
      }

   highestsock();
   
   tempstr = mycalloc(maxtextlength,"setupdccchat_tempstr");
   tempstr2 = mycalloc(maxtextlength,"setupdccchat_tempstr2");
   getuptime(tempstr2,0,gdata.startuptime);
   isnprintf(tempstr,maxtextlength-2,"Welcome to %s\niroffer v%s [%s] By PMG - %s\n"
                                    "    running %s\n"
                                    " \nEnter Your Password:\n",
      gdata.user_nick,VERSION,VERSIONDATE,gdata.osstring,tempstr2);
   write(gdata.dccchat,tempstr,strlen(tempstr));
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(ip);
   mydelete(port);
   gdata.dccchatin = 0;
   
   return 0;
   }

void parsedccchat(char* line) {
   char *linec = mycalloc(maxtextlength,"parsedccchat_linec");
   userinput ui;
   char *tempstr;

   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   strncpy(linec,line,maxtextlength-1);
   caps(linec);
   
   if (!gdata.dccchatin) {
      if ( verifypass(line) ) {
         gdata.dccchatin = 1;
         writedccchat(" \n*** Entering DCC Chat Admin Interface\n"
                      "*** For Help type \"help\"\n");
         if (gdata.messagefile) {
            tempstr = mycalloc(maxtextlength,"parsedccchat_tempstr");
            msglog_howmany(tempstr);
            writedccchat(tempstr);
            mydelete(tempstr);
            }
         writedccchat(" \n");

         }
      else {
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","DCC CHAT: Incorrect password");
         FD_CLR(gdata.dccchat, &gdata.readset);
         msleep(100);
         close(gdata.dccchat);
         gdata.dccchat = 1000;
         highestsock();
         }
      }
   else if (!strcmp(linec,"QUIT")) {
      ioutput(0,OUT_S|OUT_L,"0;35","DCC CHAT: QUIT");
      writedccchat("Bye.");
      FD_CLR(gdata.dccchat, &gdata.readset);
      msleep(100);
      close(gdata.dccchat);
      gdata.dccchat = 1000;
      highestsock();
      }
   else {
      if (!gdata.attop) gototop();
      if (gdata.debug)
         ioutput(0,OUT_S,"0;36",">DCC>: %s",line);
      /*remoteadmin(NULL,msg3,msg4,line); */
      u_fillwith_dcc(&ui,line);
      u_parseit(&ui);

      }
   
   mydelete(linec);
   }

void writedccchat(const char *str) {
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (!str) return;
   
   write(gdata.dccchat,str,strlen(str));
   
   if ( str[strlen(str)-1] != '\n')
      write (gdata.dccchat,"\n",1);
   
   if (gdata.debug)
      ioutput(0,OUT_S,"0;36","<DCC<: %s",str);

   }

void writestatus(void) {
   char *tempstr,*tempstr2;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   tempstr = mycalloc(maxtextlength,"writestatus_tempstr");
   tempstr2 = mycalloc(maxtextlengthshort,"writestatus_tempstr2");
   
   getstatusline(tempstr);
   writedccchat(tempstr);
   
   mydelete(tempstr);
   mydelete(tempstr2);
   
   }

/* End of File */
