/*      
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) display.c 1.26@(#)
 * pmg@alliance.centerclick.org|src/display.c|20011110151512|57342
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"


void initscreen(void) {
   struct winsize win;
   char *tempstr,*tempstr2;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (gdata.background == 2) return;
   
   /* clear */
   gdata.attop = 0;

   if ( ! USESCREEN )
      return;
   
   printf("\x1b[H\x1b[J\x1b[r");

   gdata.termlines = 80;
   gdata.termcols = 24;
   
   if ((ioctl(0, TIOCGWINSZ, &win) == 0) && win.ws_col && win.ws_row) {
      gdata.termcols = win.ws_col;
      gdata.termlines = win.ws_row;
      }
   
   
   /* last 2 lines */
   tempstr = mycalloc(maxtextlength,"initscreen");
   tempstr2 = mycalloc(maxtextlengthshort,"initscreen");
   getstatusline(tempstr);
   tempstr[between(0,gdata.termcols-4,maxtextlength-2)] = '\0';
   isnprintf(tempstr2,maxtextlengthshort-2,"\x1b[%d;1H[ %%-%ds ]",gdata.termlines-1,gdata.termcols-4);
   printf(tempstr2,tempstr);
   mydelete(tempstr);
   mydelete(tempstr2);

   printf("\x1b[%d;1H[ iroffer (%s) >",gdata.termlines,(gdata.user_nick ? gdata.user_nick : ""));
   printf("\x1b[%d;%dH]",gdata.termlines,gdata.termcols);
   
   /* scrolling */
   printf("\x1b[1;%dr",gdata.termlines-2);
   
   /* set bottom */
   printf("\x1b[%d;%dH",gdata.termlines,(int)(gdata.user_nick ? 16+strlen(gdata.user_nick) : 16));
   
   fflush(stdout);
   }

void checktermsize(void) {
   int notok;
   struct winsize win;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   notok = 0;
   if (gdata.background == 2) return;
   
   if ((ioctl(0, TIOCGWINSZ, &win) == 0) && win.ws_col && win.ws_row) {
      if (gdata.termcols != win.ws_col) notok++;
      if (gdata.termlines != win.ws_row) notok++;
      if (notok) {
         gdata.termcols = win.ws_col;
         gdata.termlines = win.ws_row;
         initscreen();
         if (!gdata.attop) gototop();
         printf("*** Window Size Changed To: %dx%d\n",gdata.termcols,gdata.termlines);
         gotobot();
         }
      }
   }

void gototop (void) {
   if (gdata.background == 2) return;
   gdata.attop = 1;
   if ( ! USESCREEN )
      return;
   
   printf("\x1b[s\x1b[%d;1H",gdata.termlines-2);
   }

void clearbot (void) {
   int i;
   if (gdata.background == 2) return;
   if ( ! USESCREEN )
      return;

   /* last line */
   printf("\x1b[%d;%dH",gdata.termlines,(int)(gdata.user_nick ? 16+strlen(gdata.user_nick) : 16));
   
   for (i=0; i<gdata.needsclear; i++)
      printf(" ");
   printf("\x1b[%d;%dH\x1b[s",gdata.termlines,(int)(gdata.user_nick ? 16+strlen(gdata.user_nick) : 16));
   
   printf("\x1b[%d;1H[ iroffer (%s) > ",gdata.termlines,(gdata.user_nick ? gdata.user_nick : ""));
   printf("\x1b[%d;%dH]",gdata.termlines,gdata.termcols);  
   }

void gotobot (void) {
   if (gdata.background == 2) return;
   gdata.attop = 0;
   if ( ! USESCREEN )
      return;
   
   printf("\x1b[u");
   fflush(stdout);
   }

/* End of File */

