/*
 * iroffer by PMG
 * Copyright (C) 1998-2001 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) iroffer.c 1.62@(#)
 * pmg@alliance.centerclick.org|src/iroffer.c|20011110162745|46834
 * 
 */

/* include the headers */
#define GEX 
#include "defines.h"
#include "headers.h"
#include "globals.h"

/* local functions */
static void mainloop(void);
static void parseline(char *line);
static void privmsgparse(const char* type, char* line);
static void autosendf(char* line);
static void addtoqueue(char* srvmsg, char* nick, const char* hostname, int pack);
static void prunequeues(pqueue **, int *);

static printfdata* pdnolistban=NULL;
static printfdata* pdinvalidpackban=NULL;

/* main */
int main(int argc, char *argv[]) {
   int i;
   
   if      ( argc == 2 && !strcmp(argv[1],"-v") ) {
      printf("iroffer v" VERSION " [" VERSIONDATE "] by PMG, see http://iroffer.org/\n"
	     "Featuring cpitchfor patch. Visit http://iroffer.itmakesmemad.com/\n");
      exit(0);
      }
   else if ( argc == 2 && !strcmp(argv[1],"-c") ) {
      createpassword();
      exit(0);
      }
#if ALLOWBACKGROUND
   else if ( argc >= 3 && (!strcmp(argv[1],"-b") || !strcmp(argv[1],"-m")) )
      gdata.background = 1;
#endif
   else if ( argc >= 2 && (strcmp(argv[1],"-b") && strcmp(argv[1],"-m")) )
      gdata.background = 0;
   else {
      printf ("\nUsage: %s -v                     (Display Version)"
              "\n       %s -c                     (Generate Encrypted Password)"
              "\n       %s <ConfigFile> [...]     (Normal Operation)"
#if ALLOWBACKGROUND
              "\n       %s -b <ConfigFile> [...]  (Background Operation)"
#endif
              "\nDetailed documentation can be found at http://iroffer.org/\n\n",
              argv[0],argv[0],argv[0]
#if ALLOWBACKGROUND
	      ,argv[0]
#endif
	      );
      exit(1);
      }
   
   initvars();
   
   for (i=0; i<MAXCONFIG && i<(argc-1-gdata.background); i++)
      gdata.configfile[i] = argv[i+1+gdata.background];
   
   startupiroffer();
   
   while ( 1 )
     {
       mainloop();
     }
   
   return(0);
   }


static void mainloop (void) {
   /* data is persistant across calls */
   static char tempbuffa[maxtextlength*4];
   static char server_input_line[maxtextlength*4];
   static char dcc_input_line[maxtextlength*4];
   static char tempstr[maxtextlength];
   static char tempstr2[maxtextlengthshort];
   static struct timeval timestruct;
   static int i,j,length,changesec,changemin,changehour,linecut,linecutd,count,efficency;
   static long lasttime, lastmin, lasthour, last4sec, last5sec, last20sec;
   static long lastxminautosave, lastqupdate,last3min, last2min, lastignoredec, lastperiodicmsg;
   static userinput *urehash;
   static int first_loop = 1;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   if (first_loop)
     {
       /* init if first time called */
       timestruct.tv_sec = 0;
       timestruct.tv_usec = 50000;
       FD_ZERO(&gdata.readset);
       FD_ZERO(&gdata.writeset);
       changehour=changemin=changesec=0;
       linecut=linecutd=0;
       lasttime=gdata.curtime;
       lastmin=(lasttime/60)-1;
       lasthour=(lasttime/60/60)-1;
       lastperiodicmsg = last4sec = last5sec = lastxminautosave = lastqupdate
	 = last3min = last20sec = last2min = lastignoredec = lasttime;
       efficency=0;
       
       gdata.highmeminfo = 0;
       gdata.cursendptr = 0;
       
       first_loop = 0;
     }
   
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
      if (LOOPDEBUG) {
         if (!gdata.attop) gototop();
         printf("TOP "); fflush(stdout);
         }
      
      FD_ZERO(&gdata.readset);
      FD_ZERO(&gdata.writeset);
      
      FD_SET(gdata.ircserver, &gdata.readset);
      
      if (gdata.serverstatus == 'T')
         FD_SET(gdata.ircserver, &gdata.writeset);
      
      if (!gdata.background)
         FD_SET(0, &gdata.readset);
      
      if (gdata.dccchat != 1000)
         FD_SET(gdata.dccchat, &gdata.readset);

      if (gdata.dccchatlisten != 1000)
         FD_SET(gdata.dccchatlisten, &gdata.readset);
      
      for (i=0; i<MAXTRANS; i++)
         if (gdata.trans[i] != NULL) {
            if (gdata.trans[i]->status == 'L')
               FD_SET(gdata.trans[i]->listensocket, &gdata.readset);
            if (gdata.trans[i]->status == 'S' || gdata.trans[i]->status == 'E') {
               FD_SET(gdata.trans[i]->clientsocket, &gdata.writeset);
               FD_SET(gdata.trans[i]->clientsocket, &gdata.readset);
               }
            if (gdata.trans[i]->status == 'W')
               FD_SET(gdata.trans[i]->clientsocket, &gdata.readset);
            }
      
      for (i=0; i<MAXUPLDS; i++)
         if (gdata.uploads[i] != NULL) {
            if (gdata.uploads[i]->status == 'T')
               FD_SET(gdata.uploads[i]->clientsocket, &gdata.writeset);
            if (gdata.uploads[i]->status == 'G')
               FD_SET(gdata.uploads[i]->clientsocket, &gdata.readset);
            }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
      if (select(gdata.highests+1, &gdata.readset, &gdata.writeset, NULL, &timestruct) < 0)
         ;
/*         outerror(2,"Select returned an error"); */
      
      /*----- one second check ----- */
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("A"); fflush(stdout); }
      
      gdata.curtime = time(NULL);
      if (gdata.curtime != lasttime) {
         
         if (gdata.curtime < lasttime-3) {
            if (!gdata.attop) gototop();
            outerror(2,"System Time Changed Backwards %lim %lis!!\n",
               (lasttime-gdata.curtime)/60,(lasttime-gdata.curtime)%60);
            }
         
         if (gdata.curtime > lasttime+10) {
            if (!gdata.attop) gototop();
            outerror(2,"System Time Changed Forward or Mainloop Skipped %lim %lis!!\n",
               (gdata.curtime-lasttime)/60,(gdata.curtime-lasttime)%60);
            }
         
         lasttime = gdata.curtime;
         changesec = 1;
         
         if (SHOWEFF && !(gdata.curtime%10)) {
            if (!gdata.attop) gototop();
               printf("*** Checks/10sec: %i/%i\n",efficency,10000/WAITTIME);
            efficency = 0;
            }
         }
      
      if (changesec && lasttime/60/60 != lasthour) {
         lasthour = lasttime/60/60;
         changehour = 1;
         }
      
      if (changesec && lasttime/60 != lastmin) {
         lastmin = lasttime/60;
         changemin = 1;
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("B"); fflush(stdout); }
      efficency++;
      
      if (changesec) {
         gdata.totaluptime++;
         j = 0;
         for (i=0; i<120; i++)
            j += gdata.xdccsent[i];
         if (((flpt)j)/120.0/1024.0 > gdata.sentrecord)
            gdata.sentrecord = ((flpt)j)/120.0/1024.0;
         gdata.xdccsent[getbeg(120,gdata.curtime%120+1)] = 0;
         for (i=0; i<MAXTRANS; i++)
            if (gdata.trans[i] != NULL)
               gdata.trans[i]->xdccsent[gdata.curtime%4] = 0;
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("C"); fflush(stdout); }
      
      /*----- see if anything waiting on stdin ----- */
      gdata.needsclear = 0;
      if (!gdata.background && FD_ISSET(0, &gdata.readset))
         parsestdin();
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("D"); fflush(stdout); }
      /*----- see if gdata.ircserver is sending anything to us ----- */
      if (gdata.serverstatus == 'C' && FD_ISSET(gdata.ircserver, &gdata.readset)) {
         gdata.lastservercontact = gdata.curtime;
         gdata.servertime = 0;
         for (i=0; i<maxtextlength*4; i++) tempbuffa[i] = '\0';
         length = read (gdata.ircserver, &tempbuffa, maxtextlength*4);
         
         if (length < 0) {
            ioutput(0,OUT_S|OUT_L|OUT_D,"0;31","Closing Server Connection: Connection Lost.");
            if (gdata.exiting)
               gdata.recentsent = 0;
            else {
               FD_CLR(gdata.ircserver, &gdata.readset);
               close(gdata.ircserver);
               gdata.serverstatus = 'N';
               }
            }
         else {
            i=0; j=linecut;
            while (i<maxtextlength*4 && tempbuffa[i] != '\0') {
               while (i<maxtextlength*4 && tempbuffa[i] != '\n' && tempbuffa[i] != '\0') {
                  server_input_line[j]=tempbuffa[i];
                  i++; j++;
                  }
               server_input_line[j]='\0';
               if (tempbuffa[i] != '\n')
                  linecut=j;
               else {
                  if ( server_input_line[ strlen(server_input_line) -1 ] == 0x0D )
                     /* chop ^M off end of line if there */
                     server_input_line[ strlen(server_input_line) -1 ] = '\0';
                  parseline(removenonprintable(server_input_line));
                  linecut=0;
                  }
               j=0; i++;
               }
            }
         }
      
      if (gdata.serverstatus == 'T' && FD_ISSET(gdata.ircserver, &gdata.writeset)) {
         if ( write (gdata.ircserver, "\n", 1) < 0 ) {
            ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Server Connection Failed");
            FD_CLR(gdata.ircserver, &gdata.writeset);
            close(gdata.ircserver);
            gdata.serverstatus = 'N';
            }
         else {
	    SIGNEDSOCK int addrlen; 
	    struct sockaddr_in localaddr;
          
	    ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Server Connection Established, Logging In");
            gdata.serverstatus = 'C';
            /* clear server message queue */
            bzero((char *) gdata.serverq, MAXSENDQ * sizeof(char*) );
            FD_CLR(gdata.ircserver, &gdata.writeset);
	    if (set_socket_nonblocking(gdata.ircserver, 0) < 0 )
	      outerror(2,"Couldn't Set Blocking");
	    
            if (!gdata.usenatip)
              {
                addrlen = sizeof (localaddr);
                bzero ((char *) &localaddr, sizeof (localaddr));
                if (getsockname(gdata.ircserver,(struct sockaddr *) &localaddr, &addrlen) >= 0)
                  {
                    gdata.ourip = ntohl(localaddr.sin_addr.s_addr);
                    if (gdata.debug)
                      {
                        ioutput(0,OUT_S,"0;33","ourip = %d.%d.%d.%d",
                                (gdata.ourip >> 24) & 0xFF,
                                (gdata.ourip >> 16) & 0xFF,
                                (gdata.ourip >>  8) & 0xFF,
                                (gdata.ourip      ) & 0xFF
                                );
                      }
                  }
                else
                  outerror(2,"couldn't get ourip");
              }
	    
	    initirc();
            }
         }
      
      if (changesec && gdata.serverstatus == 'T' && gdata.lastservercontact + CTIMEOUT < gdata.curtime) {
         ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Server Connection Timed Out");
         FD_CLR(gdata.ircserver, &gdata.readset);
         close(gdata.ircserver);
         gdata.serverstatus = 'N';
         }
      
      if (gdata.serverstatus == 'S') {
         
         char *tempstr233 = mycalloc(maxtextlengthshort,"mainloop_tempstr233");
         strncpy(tempstr233, "QUIT :Changing Servers",maxtextlengthshort-1);
         writeserver2(tempstr233,1);
         mydelete(tempstr233);
         
         FD_CLR(gdata.ircserver, &gdata.readset);
         close(gdata.ircserver);
         gdata.serverstatus = 'N';
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("D1"); fflush(stdout); }
      for (i=0; i<MAXUPLDS; i++)
         if (gdata.uploads[i] != NULL) {
            /*----- see if uploads are sending anything to us ----- */
            if (gdata.uploads[i]->status == 'G' && FD_ISSET(gdata.uploads[i]->clientsocket, &gdata.readset))
               l_transfersome(gdata.uploads[i]);
            
            if (gdata.uploads[i]->status == 'T' && FD_ISSET(gdata.uploads[i]->clientsocket, &gdata.writeset)) {
               if ( write (gdata.uploads[i]->clientsocket, "", 0) < 0 ) {
                  FD_CLR(gdata.uploads[i]->clientsocket, &gdata.writeset);
                  l_closeconn(gdata.uploads[i],"Upload Connection Failed");
                  }
               else {
                  ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","Upload Connection Established");
                  gdata.uploads[i]->status = 'G';
                  FD_CLR(gdata.uploads[i]->clientsocket, &gdata.writeset);
                  notice(gdata.uploads[i]->nick,"DCC Connection Established");
                  gdata.uploads[i]->connecttime = gdata.curtime;
                  if (set_socket_nonblocking(gdata.uploads[i]->clientsocket,1) < 0 ) outerror(2,"Couldn't Set Non-Blocking");
                  }
               }
            
            if (changesec && gdata.uploads[i]->status == 'T' && gdata.uploads[i]->lastcontact + CTIMEOUT < gdata.curtime) {
               FD_CLR(gdata.uploads[i]->clientsocket, &gdata.readset);
               l_closeconn(gdata.uploads[i],"Upload Connection Timed Out");
               }
            
            if (changesec)
               l_istimeout(gdata.uploads[i]);
            
            if (changesec && gdata.uploads[i]->status == 'E')
               l_closeconn(gdata.uploads[i],"Connection Lost");
            
            if (changesec && gdata.uploads[i]->status == 'D')
               mydelete(gdata.uploads[i]);
            
            }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("E"); fflush(stdout); }
      /*----- see if dccchat is sending anything to us ----- */
      if (FD_ISSET(gdata.dccchat, &gdata.readset)) {
         for (i=0; i<maxtextlength*4; i++) tempbuffa[i] = '\0';
         length = read (gdata.dccchat, &tempbuffa, maxtextlength*4);
         
         if (length < 0) {
            ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"DCC Chat Lost");
            FD_CLR(gdata.dccchat, &gdata.readset);
            close(gdata.dccchat);
            gdata.dccchat = 1000;
            highestsock();
            }
         
         i=0; j=linecutd;
         while (i<maxtextlength*4 && tempbuffa[i] != '\0') {
            while (i<maxtextlength*4 && tempbuffa[i] != '\n' && tempbuffa[i] != '\0') {
               dcc_input_line[j]=tempbuffa[i];
               i++; j++;
               }
            dcc_input_line[j]='\0';
            if (tempbuffa[i] != '\n')
               linecutd=j;
            else {
               parsedccchat(dcc_input_line);
               linecutd=0;
               }
            j=0; i++;
            }
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("F"); fflush(stdout); }
      /*----- see if dccchatlisten has a connection ----- */
      if (FD_ISSET(gdata.dccchatlisten, &gdata.readset)) {
         setupdccchataccept();
         }

      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("G"); fflush(stdout); }
      
      for (i=0,j=gdata.cursendptr; i<MAXTRANS; i++)
         if (gdata.trans[(i+j+MAXTRANS)%MAXTRANS] != NULL && gdata.trans[(i+j+MAXTRANS)%MAXTRANS]->status == 'S') {
            if (FD_ISSET(gdata.trans[(i+j+MAXTRANS)%MAXTRANS]->clientsocket, &gdata.writeset))
               gdata.trans[(i+j+MAXTRANS)%MAXTRANS]->needsdata++;
            else
               gdata.trans[(i+j+MAXTRANS)%MAXTRANS]->needsdata--;
            gdata.trans[(i+j+MAXTRANS)%MAXTRANS]->needsdata = between(needsdatamin,gdata.trans[(i+j+MAXTRANS)%MAXTRANS]->needsdata,needsdatamax);
            
            /*----- look for transfer some -----  send at least once a second, or more if necessary */
            if (changesec || FD_ISSET(gdata.trans[(i+j+MAXTRANS)%MAXTRANS]->clientsocket, &gdata.writeset))
               t_transfersome(gdata.trans[(i+j+MAXTRANS)%MAXTRANS]);
            
            }
      
      for (i=0; i<MAXTRANS; i++)
         if (gdata.trans[i] != NULL) {
         
      /*----- look for listen reminders ----- */
         if (changesec && gdata.trans[i]->status == 'L' && (gdata.curtime - gdata.trans[i]->lastcontact) >= 30 && gdata.trans[i]->reminded == 0)
            t_remind(gdata.trans[i]);
         if (changesec && gdata.trans[i]->status == 'L' && (gdata.curtime - gdata.trans[i]->lastcontact) >= 90 && gdata.trans[i]->reminded == 1)
            t_remind(gdata.trans[i]);
         if (changesec && gdata.trans[i]->status == 'L' && (gdata.curtime - gdata.trans[i]->lastcontact) >= 150 && gdata.trans[i]->reminded == 2)
            t_remind(gdata.trans[i]);
         
      /*----- look for listen->connected ----- */
         if (gdata.trans[i]->status == 'L' && FD_ISSET(gdata.trans[i]->listensocket, &gdata.readset))
            t_establishcon(gdata.trans[i]);
         
      /*----- look for junk to read ----- */
         if (changesec && (gdata.trans[i]->status == 'S'
                        || gdata.trans[i]->status == 'W'
                        || gdata.trans[i]->status == 'E') && FD_ISSET(gdata.trans[i]->clientsocket, &gdata.readset))
            t_readjunk(gdata.trans[i]);
         
      /*----- look for done flushed status ----- */
         if (changesec && gdata.trans[i]->status == 'W')
            t_flushed(gdata.trans[i]);
         
      /*----- look for lost transfers ----- */
         if (changesec)
            t_istimeout(gdata.trans[i]);
         
      /*----- look for finished transfers ----- */
         if (changesec && gdata.trans[i]->status == 'D') {
            mydelete(gdata.trans[i]);
            highestsock();
            gdata.slotsfull--;
            if (!gdata.exiting && (gdata.inqueue || gdata.inslotsmaxqueue) && (gdata.slotsfull < gdata.slotsmax)) sendaqueue(0);
            }
         }
      
      /*----- time for a delayed shutdown? ----- */
      if (changesec && gdata.delayedshutdown) {
         for (count=i=0; i<MAXTRANS; i++)
            if (gdata.trans[i] != NULL) count++;
         
         if (!count) {
            ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Delayed Shutdown Activated, No Transfers Remaining");
            shutdowniroffer(0);
            }
         
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("H"); fflush(stdout); }
      /*----- send server stuff ----- */
      if (changesec) {
         sendserver();
         if (gdata.curtime%10 == 9)
            gdata.inamnt[0] = 0;
         else
            gdata.inamnt[gdata.curtime%10+1] = 0;
         }
      
      /*----- see if we can send out some xdcc lists */
      if (changesec && gdata.serverstatus == 'C') {
         if (gdata.serverq[0] == NULL)
            sendxdlqueue();
         }
      
      /*----- see if its time to change maxb */
      if (changehour) {
         gdata.maxb = gdata.overallmaxspeed;
         if (gdata.overallmaxspeeddayspeed != gdata.overallmaxspeed) {
            struct tm *localt;
            localt = localtime(&gdata.curtime);

            if (localt->tm_hour >= gdata.overallmaxspeeddaytimestart
                && localt->tm_hour < gdata.overallmaxspeeddaytimeend
                && ( gdata.overallmaxspeeddaydays & (1 << localt->tm_wday)) )
               gdata.maxb = gdata.overallmaxspeeddayspeed;
            }
         }

      /* time to rotate log ? */
      if (changehour && gdata.logrotate && gdata.logfile)
         isrotatelog();
      if (changesec)
	badpackrotate(0);
      

      /*----- IGN_TL seconds ----- */
      if (changesec && (gdata.curtime - lastignoredec > IGN_TL)) {
         lastignoredec += IGN_TL;
         for (i=0; i<MAXIGNL && gdata.ignorelist[i]; i++) {
            if (!gdata.attop) gototop();
            gdata.ignorelist[i]->bucket--;
            if ((gdata.ignorelist[i]->flags & IGN_IGNORING) && gdata.ignorelist[i]->bucket < IGN_OFF) {
               gdata.ignorelist[i]->flags &= ~IGN_IGNORING & ~IGN_FIRSTIGNORE;
               ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Ignore removed for *!*@%s",gdata.ignorelist[i]->hostname);
               write_ignorefile();
               }
            if (gdata.ignorelist[i]->bucket < 0) {
               mydelete(gdata.ignorelist[i]);
               for (; i<MAXIGNL; i++) gdata.ignorelist[i] = gdata.ignorelist[i+1];
               gdata.ignorelist[MAXIGNL-1] = NULL;
               
               }
            }
         }
      
      /*----- periodicmsg_time seconds ----- */
      if (changesec && (gdata.curtime - lastperiodicmsg > gdata.periodicmsg_time*60)) {
         lastperiodicmsg += gdata.periodicmsg_time*60;
         
         if (gdata.periodicmsg_nick && gdata.periodicmsg_msg
	     && (gdata.serverstatus == 'C') )
            privmsg(gdata.periodicmsg_nick,"%s",gdata.periodicmsg_msg);
         
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("I"); fflush(stdout); }
      
      /*----- 5 seconds ----- */
      if (changesec && (gdata.curtime - last5sec > 4)) {
         last5sec = gdata.curtime;
         
	 updatecontext(__FILE__,__FUNCTION__,__LINE__);
         if (LOOPDEBUG) { printf("J"); fflush(stdout); }
         /*----- server timeout ----- */
         if (gdata.curtime - gdata.lastservercontact > SRVRTOUT) {
            if (gdata.servertime < 3) {
               char *tempstr3 = mycalloc(maxtextlength,"mainloop_tempstr3");
               isnprintf(tempstr3,maxtextlength-2,"PING %s\n",gdata.curserverip);
               write(gdata.ircserver, tempstr3, strlen(tempstr3));
               if (gdata.debug) ioutput(0,OUT_S,"0;35","<NORES<: %s",tempstr3);
               mydelete(tempstr3);
               gdata.servertime++;
               }
            else if (gdata.servertime == 3) {
               ioutput(0,OUT_S|OUT_L|OUT_D,"0;31","Closing Server Connection: No Response for %d minutes.",SRVRTOUT/60);
               FD_CLR(gdata.ircserver, &gdata.readset);
               close(gdata.ircserver);
               gdata.serverstatus = 'N';
               gdata.servertime = 0;
               }
            }
         
         
         /*----- ping server ----- */
         if (gdata.recentsent) {
            pingserver();
            gdata.recentsent--;
            }
         
         }
      
      /*----- 4 seconds ----- */
      if (changesec && (gdata.curtime - last4sec > 3)) {
         
         /*----- update lastspeed, check minspeed ----- */
         for (i=0; i<MAXTRANS; i++)
            if (gdata.trans[i] != NULL) {
               if ( gdata.trans[i]->connecttime+(MIN_TL/2) > gdata.curtime ) /* initial */
                  gdata.trans[i]->lastspeed = 
                     (gdata.trans[i]->lastspeed)*DCL_SPDW_I + 
                     ((flpt)((gdata.trans[i]->bytessent-gdata.trans[i]->lastspeedamt)/1024))*(1.0-DCL_SPDW_I)/((flpt)(gdata.curtime-last4sec)*1.0);
               else                                              /* ongoing */
                  gdata.trans[i]->lastspeed = 
                     (gdata.trans[i]->lastspeed)*DCL_SPDW_O + 
                     ((flpt)((gdata.trans[i]->bytessent-gdata.trans[i]->lastspeedamt)/1024))*(1.0-DCL_SPDW_O)/((flpt)(gdata.curtime-last4sec)*1.0);
               
               gdata.trans[i]->lastspeedamt = gdata.trans[i]->bytessent;
               
               t_checkminspeed(gdata.trans[i]);
               
               }
         for (i=0; i<MAXUPLDS; i++)
            if (gdata.uploads[i] != NULL) {
               if ( gdata.uploads[i]->connecttime+(MIN_TL/2) > gdata.curtime ) /* initial */
                  gdata.uploads[i]->lastspeed = 
                     (gdata.uploads[i]->lastspeed)*DCL_SPDW_I + 
                     ((flpt)((gdata.uploads[i]->bytesgot-gdata.uploads[i]->lastspeedamt)/1024))*(1.0-DCL_SPDW_I)/((flpt)(gdata.curtime-last4sec)*1.0);
               else                                                /* ongoing */
                  gdata.uploads[i]->lastspeed = 
                     (gdata.uploads[i]->lastspeed)*DCL_SPDW_O + 
                     ((flpt)((gdata.uploads[i]->bytesgot-gdata.uploads[i]->lastspeedamt)/1024))*(1.0-DCL_SPDW_O)/((flpt)(gdata.curtime-last4sec)*1.0);
               
               gdata.uploads[i]->lastspeedamt = gdata.uploads[i]->bytesgot;
               
               }
         
         last4sec = gdata.curtime;
         }

      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("K"); fflush(stdout); }
      /*----- check for size change ----- */
      if (changesec)
         checktermsize();
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("L"); fflush(stdout); }
      
      /*----- plist stuff ----- */
      if (gdata.serverstatus == 'C' && changemin && gdata.numpacks) {
         if (!gdata.queuesize || gdata.inqueue < gdata.queuesize) {
            /* can we send w/o breaking xfer limit?  no plist if not */
            if (data_limit_can_send()) {
               sendAdvert(NULL,0);
            } else {
               ioutput(0, OUT_S | OUT_D, NULL,
                       "Plist skipped, we have reached transfer maximum.");
                        }
            /* done */
         } else
            ioutput(0,OUT_S|OUT_D,NULL,"Plist skipped, we seem to be rather busy");
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("M"); fflush(stdout); }
      /*----- xdcc autosave stuff ----- */
      if (changesec && (gdata.curtime - lastxminautosave > gdata.xdccautosavetime*60)) {
         lastxminautosave = gdata.curtime;
         xdccsave(1);
         write_ignorefile();
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("N"); fflush(stdout); }
      /*----- low bandwidth send / queue notify ----- */
      if (changemin) {
         
         count = 0;
         for (i=0; i<60; i++)
            count += gdata.xdccsent[getend(120, (gdata.curtime%60)-i)];
         count = count/60/1024;
         
       /*  if ( (gdata.inqueue || gdata.inslotsmaxqueue) && (count < gdata.lowbdwth) ) */
         if (count < gdata.lowbdwth)
            sendaqueue(1);
      }
      if (changesec)
	{
	  if (gdata.curtime - last3min > 180) {
	    last3min = gdata.curtime;
         
	 if (gdata.serverstatus == 'C')
	   {
	     notifybandwidth();
	     notifybandwidthtrans();
	   }
	  }
	  if (gdata.queueupdate && (gdata.serverstatus == 'C') && 
	      (gdata.curtime - lastqupdate > gdata.queueupdate))
	    {
	      lastqupdate=gdata.curtime;
	      notifyqueued();
	    }
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("O"); fflush(stdout); }
      /*----- log stats / remote admin stats ----- */
      if ( gdata.logstats && changesec && gdata.logfile && (gdata.curtime - last2min > 119)) {
         last2min += 120;
         logstat();
         
         if ( gdata.dccchat != 1000 && gdata.dccchatin )
            writestatus();
         
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("P"); fflush(stdout); }
      
      /*----- plugin ----- */
      plugin_everyloop();
      if (changesec)
         plugin_every1sec();
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("Q"); fflush(stdout); }
      /*----- 20 seconds ----- */
      if (changesec && (gdata.curtime - last20sec > 19)) {
         
         /*
          * data_limit:  check if it's time to rotate
          *
          * if we accept anything w/in 20s, we could repeatedly
          * rotate early, allowing, over time, significantly early
          * rotation - this could break our limit!
          * only rotate if rotation time has gone by!  this will never
          * be more than 20 seconds late, of course.  we'll try to account
          * for the leak, but it will still build up (very slowly, though).
          * since we lose <1sec per rotation, and have 1 rotation per day,
          *  we're losing strictly less than 1 minute per 2 months...
          * but it's late, not early, so we'll never break the limit.  rather,
          *  after 2 months we could rotate a minute earlier, and thus,
          *  potentially, allow a transfer a minute sooner...
          */
         size_t now;
         int diff;

         now = time(NULL);
         diff = gdata.data_limit.next_rotate - now;
         if (diff < 1) {
            /* we should rotate */
            data_limit_rotate();
            /* set new rotation time */
            /* - diff accounts for anything > 1sec we've lost between checks */
            gdata.data_limit.next_rotate = now + data_limit_increment - diff;
         }
         /* done */


         plugin_every20sec();
         
         /* try rejoining channels not on */
         for (i=0; i<MAXCHNLS; i++)
         if (gdata.serverstatus == 'C' && gdata.channels[i] && !(gdata.channels[i]->flags & CHAN_ONCHAN))
            joinchannel(gdata.channels[i]);
         
         last20sec = gdata.curtime;
         
         if (!gdata.background && USESCREEN) {
            if (gdata.attop) gotobot();
            
            printf("\x1b[s");
            
            getstatusline(tempstr);
            tempstr[min2(maxtextlength-2,gdata.termcols-4)] = '\0';
            isnprintf(tempstr2,maxtextlengthshort-2,"\x1b[%d;1H[ %%-%ds ]",gdata.termlines-1,gdata.termcols-4);
            printf(tempstr2,tempstr);
            
            printf("\x1b[%d;%dH]\x1b[u",gdata.termlines,gdata.termcols);
            
            fflush(stdout);
            }

         }
      
      if (gdata.exiting && gdata.serverstatus != 'C') {
         
         mylog(0,"iroffer exited\n\n");

         if (!gdata.background) printf("\x1b[r\x1b[%i;1H\n",gdata.termlines);
         if (gdata.pidfile) unlink(gdata.pidfile);
         exit(0);
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (gdata.serverstatus == 'N') switchserver(-1);
      
      if (gdata.needsrehash) {
         gdata.needsrehash = 0;
         urehash = mycalloc(sizeof(userinput),"mainloop_urehash");
         u_fillwith_msg(urehash,NULL,"A A A A A rehash");
         urehash->method = method_out_all;  /* just OUT_S|OUT_L|OUT_D it */
         u_parseit(urehash);
         mydelete(urehash);
         }
      
      updatecontext(__FILE__,__FUNCTION__,__LINE__);
      if (LOOPDEBUG) { printf("R"); fflush(stdout); }
      if (gdata.needsclear) clearbot();
      if (gdata.attop) gotobot();
      
      /*----- sleep WAITTIME ms so we don't use excessive cpu time ----- */
      msleep( WAITTIME );

      changehour=changemin=changesec=0;
      
   }

static void parseline(char *line) {
   char *tempstr = mycalloc(maxtextlength,"parseline");
   char *tempstr2 = mycalloc(maxtextlength,"parseline");
   char *part2, *part3, *part4, *part5;
   char *t, *t2;
   int i;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);
   
   /* we only support lines upto maxtextlength, truncate line */
   line[maxtextlength-1] = '\0';
   
   if (gdata.debug)
      ioutput(0,OUT_S,"0;36",">IRC>: %s",line);
   
   part2 = getpart(line,2,"parseline");
   part3 = getpart(line,3,"parseline");
   part4 = getpart(line,4,"parseline");
   part5 = getpart(line,5,"parseline");
   
   if (part2 == NULL) {
      mydelete(tempstr);
      mydelete(tempstr2);
      mydelete(part2);
      mydelete(part3);
      mydelete(part4);
      mydelete(part5);
      return;
      }
   
 /* misc server msgs */
 /*  isnprintf(tempstr,maxtextlength-2, ":%s",gdata.curserverip); */
 /*  if (strcmppart(line, tempstr)) */
 /*     ; */
   
 /* NOTICE AUTH */
 /*  if (strcmppart(line, "NOTICE AUTH")) */
 /*     ; */

 /* NOTICE nick */
   if (part3 && !strcmp(caps(part2),"NOTICE") && !strcmp(caps(part3),gdata.caps_nick))
      privmsgparse("NOTICE",line);
 
 /* :server 451  xxxx :Register first. */
   if ( !strcmp(part2,"451") ) {
      if (gdata.debug)
         ioutput(0,OUT_S,NULL,"Register first: %s",line);
         
         isnprintf(tempstr,maxtextlength-2,"NICK %s",gdata.user_nick);
         writeserver2(tempstr,1);
         isnprintf(tempstr,maxtextlength-2,"USER %s 32 . :%s",gdata.loginname,gdata.user_realname);
         writeserver2(tempstr,1);
         if (gdata.user_modes && strlen(gdata.user_modes)) {
            isnprintf(tempstr,maxtextlength-2,"MODE %s %s",gdata.user_nick,gdata.user_modes);
            writeserver2(tempstr,1);
            }

      }

   /* names list for a channel */
   /* :server 353 our_nick = #channel :nick @nick +nick nick */
   if ( !strcmp(part2,"353") && part3 && part4 && part5 )
     {
       int chan;
       
       caps(part5);
       
       for (chan=0; chan<MAXCHNLS; chan++)
	 if (gdata.channels[chan] && !strcmp(part5,gdata.channels[chan]->name))
	   break;
       
       if (chan == MAXCHNLS)
	 ioutput(0,OUT_S|OUT_L|OUT_D,NULL,
		 "Got name data for %s which is not a known channel!",part5);
       else
	 {
	   
	   for (i=0; (t2 = t = getpart(line,6+i,"parseline_names_list")); i++)
	     {
	       
	       if (t[0] == ':') t++;
	       if (t[0] == '@') t++;
	       if (t[0] == '+') t++;
	       if (t[0] == '@') t++; /* not sure what order */
	       
	       addtomemberlist(gdata.channels[chan],t);
	       
	       mydelete(t2);
	     }
	   
	 }
       
     }
   
 /* ERROR :Closing Link */
   if (strcmppart(line, "ERROR :Closing Link")) {
      if (gdata.exiting)
         gdata.recentsent = 0;
      else {
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;31","Server Closed Connection: %s",line);
         
          FD_CLR(gdata.ircserver, &gdata.readset);
          close(gdata.ircserver);
          gdata.serverstatus = 'N';
         
         }
      }
   
 /* server ping */
   if (PING_SRVR && strcmppart(line, "PING :")) {
      if (gdata.debug)
         ioutput(0,OUT_S,NULL,"Server Ping: %s",line);
      isnprintf(tempstr,maxtextlength-2,"%s",line);
      tempstr[1] = 'O';
      writeserver2(tempstr,1);
        /* ping for austnet verification */
     /* isnprintf(tempstr,maxtextlength-2,"MODE %s %s",gdata.user_nick,gdata.user_modes); */
     /* writeserver2(tempstr,1); */
      }

 /* JOIN */
   if (!strcmp(part2,"JOIN") && part3) {
      char* nick;
      int j,found;
      nick = mycalloc(maxtextlengthshort,"parseline");
      j=1;
      gdata.nocon = 0;
      found = 0;
      while(line[j] != '!' && j<sstrlen(line) && j<maxtextlengthshort-1) {
         nick[j-1] = line[j];
         j++;
         }
      nick[j-1]='\0';
      if (!strcmp(caps(nick),gdata.caps_nick)) {
	/* we joined */
         for (j=1; j<=sstrlen(part3); j++) {
            part3[j-1]=part3[j];
            }
         ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Joined %s",caps(part3));
         for (j=0; j<MAXCHNLS; j++)
            if (gdata.channels[j] && !strcmp(part3,gdata.channels[j]->name)) {
               gdata.channels[j]->flags |= CHAN_ONCHAN;
               found=1;
	       
#if 0
	       isnprintf(tempstr,maxtextlength-2,"NAMES %s",
			 gdata.channels[j]->name);
	       writeserver(tempstr);
#endif
	       
               }
         if (!found)
            ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"%s is not a known channel!",part3);
         }
      else
	{
	  /* someone else joined */
	  caps(part3+1);
	  for (j=0; j<MAXCHNLS; j++)
	    if (gdata.channels[j] && !strcmp(part3+1,gdata.channels[j]->name))
	      break;
	  
	  if (j == MAXCHNLS)
	    ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"%s is not a known channel!",part3+1);
	  else
	    addtomemberlist(gdata.channels[j],nick);
	  
	}
	
      mydelete(nick);
      }

 /* PART */
   if (!strcmp(part2,"PART") && part3)
     {
       char* nick;
       int j;
       nick = mycalloc(maxtextlengthshort,"parseline");
       j=1;
       while(line[j] != '!' && j<sstrlen(line) && j<maxtextlengthshort-1)
	 {
	   nick[j-1] = line[j];
	   j++;
	 }
       nick[j-1]='\0';
       
       if (!strcmp(caps(nick),gdata.caps_nick))
	 {
	   /* we left? */
	   ;
	 }
       else
	 {
	   /* someone else left */
	   caps(part3);
	   for (j=0; j<MAXCHNLS; j++)
	     if (gdata.channels[j] && !strcmp(part3,gdata.channels[j]->name))
	       break;
	   
	   if (j == MAXCHNLS)
	     ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"%s is not a known channel!",part3);
	   else
	     removefrommemberlist(gdata.channels[j],nick);
	   
	 }
       
       mydelete(nick);
     }
   
 /* QUIT */
   if (!strcmp(part2,"QUIT"))
     {
       char* nick;
       int j;
       nick = mycalloc(maxtextlengthshort,"parseline");
       j=1;
       while(line[j] != '!' && j<sstrlen(line) && j<maxtextlengthshort-1)
	 {
	   nick[j-1] = line[j];
	   j++;
	 }
       nick[j-1]='\0';
       
       if (!strcmp(caps(nick),gdata.caps_nick))
	 {
	   /* we quit? */
	   ;
	 }
       else
	 {
	   /* someone else quit */
	   for (j=0; j<MAXCHNLS; j++)
	     if (gdata.channels[j])
	       {
		 removefrommemberlist(gdata.channels[j],nick);
	       }
	 }
       
       mydelete(nick);
     }
   
 /* NICK */
   if (!strcmp(part2,"NICK") && part3)
     {
       char *oldnick, *newnick;
       int j;
       oldnick = mycalloc(maxtextlengthshort,"parseline");
       j=1;
       while(line[j] != '!' && j<sstrlen(line) && j<maxtextlengthshort-1)
	 {
	   oldnick[j-1] = line[j];
	   j++;
	 }
       oldnick[j-1]='\0';

       newnick = part3;
       if (newnick[0] == ':') newnick++; 
       
       if (!strcmp(caps(oldnick),gdata.caps_nick))
	 {
	   /* we changed nicks? */
	   ;
	 }
       else
	 {
	   /* someone else changed nicks */
	   for (j=0; j<MAXCHNLS; j++)
	     if (gdata.channels[j])
		 changeinmemberlist(gdata.channels[j],oldnick,newnick);
	 }
       
       mydelete(oldnick);
     }
   
 /* KICK */
   if (!strcmp(part2,"KICK") && part3 && part4)
     {
       for (i=0; i<MAXCHNLS; i++)
	 if (gdata.channels[i] && !strcmp(caps(part3),gdata.channels[i]->name) )
	   {
	     if(!strcmp(caps(part4),gdata.caps_nick))
	       {
		 /* we were kicked */
		 ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Kicked, Rejoining: %s",line);
		 joinchannel(gdata.channels[i]);
		 gdata.channels[i]->flags &= ~CHAN_ONCHAN;
	       }
	     else
	       {
		 /* someone else was kicked */
		 removefrommemberlist(gdata.channels[i],part4);
	       }
	   }
     }
   
 /* plugin */
   plugin_ircinput(line,part2,part3,part4);
   
 /* PRIVMSG */
   if (!strcmp(part2,"PRIVMSG")) {
      tempstr[0] = '\0';
      if (gdata.autosend)
         isnprintf(tempstr,maxtextlength-2,":%s",caps(gdata.autoword));
      
      if (gdata.autosend && part4 && !strcmp(caps(part4),tempstr))
         autosendf(line);
      else
         privmsgparse("PRIVMSG",line);

      }
   
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(part2);
   mydelete(part3);
   mydelete(part4);
   mydelete(part5);
   }


static void privmsgparse(const char* type, char* line) {
   char *nick, *hostname, *hostmask, *msg1, *msg2, *msg3, *msg4, *msg5, *msg6, *dest;
   char *tempstr = mycalloc(maxtextlength,"privmsgparse");
   char *tempstr2 = mycalloc(maxtextlength,"privmsgparse");
   int i,j,k;
   userinput ui;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   floodchk();
   
   hostmask = caps(getpart(line,1,"privmsgparse"));
   for (i=1; i<=sstrlen(hostmask); i++)
      hostmask[i-1] = hostmask[i];
   
   dest = caps(getpart(line,3,"privmsgparse"));
   msg1 = getpart(line,4,"privmsgparse");
   msg2 = getpart(line,5,"privmsgparse");
   msg3 = getpart(line,6,"privmsgparse");
   msg4 = getpart(line,7,"privmsgparse");
   msg5 = getpart(line,8,"privmsgparse");
   msg6 = getpart(line,9,"privmsgparse");
   
   if (msg1)
     msg1++;  /* point past the ":" */
   
   nick = mycalloc(maxtextlengthshort,"privmsgparse");
   hostname = mycalloc(maxtextlength,"privmsgparse");
   
   
   i=1; j=0;
   while(line[i] != '!' && i<sstrlen(line) && i<maxtextlengthshort-1) {
      nick[i-1] = line[i];
      i++;
      }
   nick[i-1]='\0';
   
   
   /* see if it came from a user or server, ignore if from server */
   if (i == sstrlen(line) || i == (maxtextlengthshort-1))
     goto privmsgparse_cleanup; /* it's useful damnit! */
   
   while(line[i] != '@' && i<sstrlen(line)) { i++; }
   i++;
   
   while(line[i] != ' ' && i<sstrlen(line) && j<maxtextlength-1) {
      hostname[j] = line[i];
      i++;
      j++;
      }
   hostname[j]='\0';
   
   if (isthisforme(dest, msg1)) {
      /* add/increment ignore list */
      j=0;
      for (i=0; i<MAXIGNL && gdata.ignorelist[i]; i++)
         if (isbanned(i,hostname)) {
            /* already in list */
            j=1;
            gdata.ignorelist[i]->bucket++;
            gdata.ignorelist[i]->lastcontact = gdata.curtime;
            if ( !(gdata.ignorelist[i]->flags & IGN_IGNORING) && gdata.ignorelist[i]->bucket >= IGN_ON ) {
               gdata.ignorelist[i]->flags |= IGN_IGNORING | IGN_FIRSTIGNORE;
               ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"Auto-ignore activated for %s *!*@%s",nick,hostname);
               }
            }
      if (!j) { /* not in list */
         j = gdata.curtime+10;
         k=0;
         for (i=0; i<MAXIGNL && gdata.ignorelist[i]; i++)
            if (gdata.ignorelist[i]->lastcontact < j)
               k = i;
         if ( i == MAXIGNL ) {
            mydelete(gdata.ignorelist[k]);
            for (i=k; i<MAXIGNL; i++) gdata.ignorelist[i] = gdata.ignorelist[i+1];
            gdata.ignorelist[MAXIGNL-1] = NULL;
            }
      
         for (i=0; i<MAXIGNL && gdata.ignorelist[i]; i++);
         if ( i == MAXIGNL ) outerror(1,"Out of ignore slots!, This shouldn't happen");
            gdata.ignorelist[i] = mycalloc(sizeof(igninfo),"privmsgparse_gdata.ignorelist[i]");
         strncpy(gdata.ignorelist[i]->hostname,hostname,maxtextlength-1);
         gdata.ignorelist[i]->bucket = 1;
         gdata.ignorelist[i]->flags &= ~IGN_RANGE & ~IGN_MANUAL & ~IGN_IGNORING & ~IGN_FIRSTIGNORE;
         gdata.ignorelist[i]->lastcontact = gdata.curtime;
         
         }
   
      /* see if we are ignoreing this person */
      for (i=0; i<MAXIGNL && gdata.ignorelist[i]; i++)
         if (isbanned(i,hostname) && (gdata.ignorelist[i]->flags & IGN_IGNORING)) {
            if (gdata.ignorelist[i]->flags & IGN_FIRSTIGNORE) {
                privmsg(nick,"Auto-ignore activated, ignoring *!*@%s until you calm down",hostname);
                gdata.ignorelist[i]->flags &= ~IGN_FIRSTIGNORE;
                write_ignorefile();
                }
            gdata.ignorelist[i]->lastcontact = gdata.curtime;
	    
	    goto privmsgparse_cleanup; /* it's useful damnit! */
            }
      }
   if (!gdata.publictriggers && !addressedtome(dest))
     goto privmsgparse_cleanup;
   
   
   /*----- CLIENTINFO ----- */
   if ( !gdata.ignore && (!strcmp(msg1,"\1CLIENTINFO")
          || !strcmp(msg1,"\1CLIENTINFO\1") )) {
      gdata.inamnt[gdata.curtime%10]++;
      if (!msg2) {
         notice(nick,"CLIENTINFO DCC PING VERSION XDCC UPTIME "
         "Use CTCP CLIENTINFO <command> to get information about specific command");
         }
      else if (strcmppart(caps(msg2),"PING"))
         notice(nick,"CLIENTINFO PING shows if user is still online");
      else if (strcmppart(caps(msg2),"DCC"))
         notice(nick,"CLIENTINFO DCC requests a direct client connection for chatting or filetransfer");      
      else if (strcmppart(caps(msg2),"VERSION"))
         notice(nick,"CLIENTINFO VERSION shows information about client version");
      else if (strcmppart(caps(msg2),"XDCC"))
         notice(nick,"CLIENTINFO XDCC LIST|SEND list and DCC file(s) to you");
      else if (strcmppart(caps(msg2),"UPTIME"))
         notice(nick,"CLIENTINFO UPTIME shows how long user has been running");
      
      ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"%s CLIENTINFO'ed Us.",nick);
      }
   
   /*----- PING ----- */
   else if ( !gdata.ignore && (!strcmp(msg1,"\1PING")
          || !strcmp(msg1,"\1PING\1") )) {
      gdata.inamnt[gdata.curtime%10]++;
/*      msg2 = getpart(line,5,""); */
      tempstr[0] = '\0';
      isnprintf(tempstr,maxtextlength-2,"NOTICE %s :%s%s%s",nick,msg1,msg2?" ":"",msg2?msg2:"");
      writeserver(tempstr);
      ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"%s Pinged Us.",nick);
      }
   
   /*----- VERSION ----- */
   else if ( !gdata.ignore && (!strcmp(msg1,"\1VERSION")
          || !strcmp(msg1,"\1VERSION\1") )) {
      gdata.inamnt[gdata.curtime%10]++;
      notice(nick,"\1VERSION iroffer v%s [%s] By PMG (patched by cpitchfor), http://iroffer.org/ http://iroffer.itmakesmemad.com/ - %s\1"
              ,VERSION,VERSIONDATE,gdata.osstring);
      ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"%s Version'ed Us.",nick);
      }
   
   /*----- UPTIME ----- */
   else if ( !gdata.ignore && (!strcmp(msg1,"\1UPTIME")
          || !strcmp(msg1,"\1UPTIME\1") )) {
      gdata.inamnt[gdata.curtime%10]++;
      tempstr2 = getuptime(tempstr2,0,gdata.startuptime);
      notice(nick,"\1iroffer has been running for %s\1",tempstr2);
      ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"%s Uptime'ed Us.",nick);
      }
   
   /*----- STATUS ----- */
   else if ( !gdata.ignore && (!strcmp(msg1,"\1STATUS")
          || !strcmp(msg1,"\1STATUS\1") )) {
      gdata.inamnt[gdata.curtime%10]++;
      tempstr2 = getstatuslinenums(tempstr2);
      notice(nick,"\1%s\1",tempstr2);
      ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"%s Status'ed Us.",nick);
      }
   
   /*----- DCC SEND/CHAT/RESUME ----- */
   else if ( !gdata.ignore && !strcmp(gdata.caps_nick,dest) && !strcmp(caps(msg1),"\1DCC") && msg2) {
   	int found;
      if (!gdata.attop) gototop();
      if (!strcmp(caps(msg2),"RESUME") && msg3 && msg4 && msg5) {
         gdata.inamnt[gdata.curtime%10]++;
         
	 caps(nick);
	 
	 if (msg5[strlen(msg5)-1] == '\1') msg5[strlen(msg5)-1] = '\0';
	 
         for (found=i=0; (i<MAXTRANS && !found); i++)
	   {
	     
	   if (gdata.trans[i] != NULL && gdata.trans[i]->status == 'L' && 
	       !strcmp(gdata.trans[i]->caps_nick,nick) &&
	       ( strcmpany(gdata.trans[i]->xpack->file,msg3) || gdata.trans[i]->listenport == atoi(msg4) )
	       ) {
	     if (atoul(msg5) >= gdata.trans[i]->xpack->size) {
	       notice(nick,"You can't resume the transfer at a point greater than the size of the file");
	       ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC [%02i:%s]: Resume attempted beyond end of file ( %lu >= %lu )",
		       gdata.trans[i]->id,gdata.trans[i]->nick,atoul(msg5),gdata.trans[i]->xpack->size);
	     }
	     else {
	       t_setresume(gdata.trans[i],msg5);
	       privmsg(nick,"\1DCC ACCEPT %s %s %s\1",msg3,msg4,msg5);
	       ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC [%02i:%s]: Resumed at %liK",
		       gdata.trans[i]->id,gdata.trans[i]->nick,(long)(gdata.trans[i]->startresume/1024));
	     }
	     found=1;
	   }
	   }
         i--;
         
         if (!found)
	   {
	     outerror(2,"Couldn't find transfer that %s tried to resume!",nick);
	     for (i=0; i<MAXTRANS; i++)
	       if (gdata.trans[i])
		 ioutput(0,OUT_S|OUT_L|OUT_D,NULL,
			 "resume trying %i,%c: %s == %s, %s == %s, %i == %i\n",
			 i,gdata.trans[i]->status,
			 gdata.trans[i]->caps_nick,nick,
			 gdata.trans[i]->xpack->file,msg3,
			 gdata.trans[i]->listenport,atoi(msg4));
	   }
	 
	 
         }
      if (!strcmp(caps(msg2),"CHAT")) {
         if ( verifyadmin(hostmask) )
            setupdccchat(line);
         else {
            notice(nick,"DCC Chat Denied (%s is not allowed to DCC Chat)",hostmask);
            ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","Incorrect DCC CHAT Hostmask (%s)",hostmask);
            }
         }
      
      if (!strcmp(caps(msg2),"SEND") && msg3 && msg4 && msg5 && msg6) {
         
         for (i=0; i<MAXUPLDS && gdata.uploads[i]; i++);
         if (msg6[strlen(msg6)-1] == '\1') msg6[strlen(msg6)-1] = '\0';
         
         if (!gdata.uploadallowed) {
         	privmsg(nick,"DCC Send Denied, I don't accept transfers");
            ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","DCC Send Denied from %s",hostmask);            
            }
         
         else if ( gdata.uploadmaxsize && atoul(msg6) > gdata.uploadmaxsize) {
         	privmsg(nick,"DCC Send Denied, I don't accept transfers that big");
            ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","DCC Send Denied (Too Big) from %s",hostmask);            
            }
         
         else if (i == MAXUPLDS) {
         	privmsg(nick,"DCC Send Denied, I'm already getting too many files");
            ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","DCC Send Denied (too many uploads) from %s",hostmask);            
            }
         
         
         else {
            gdata.uploads[i] = mycalloc(sizeof(upload),"privmsgparse_upload");
            l_initvalues(gdata.uploads[i]);
            strncpy(gdata.uploads[i]->file,removenonprintablefile(msg3),maxtextlength-1);
            gdata.uploads[i]->remoteip = atoul(msg4);
            gdata.uploads[i]->remoteport = atoi(msg5);
            gdata.uploads[i]->totalsize = atol(msg6);
            strncpy(gdata.uploads[i]->nick,nick,maxtextlengthshort-1);
            strncpy(gdata.uploads[i]->hostname,hostname,maxtextlength-1);
            ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","DCC Send Accepted from %s file: %s",hostmask,gdata.uploads[i]->file);
            l_establishcon(gdata.uploads[i]);
            }
         
         }
      }
   
   /*----- ADMIN ----- */
   else if ( !gdata.ignore && !strcmp(gdata.caps_nick,dest) && !strcmp(caps(msg1),"ADMIN") ) {
/*      msg2 = getpart(line,5,""); */
      if (!gdata.attop) gototop();
      
      if ( verifyadmin(hostmask) ) {
         if ( verifypass(msg2) ) {
            if (line[strlen(line)-1] == '\n') line[strlen(line)-1] = '\0';
            u_fillwith_msg(&ui,nick,line);
            u_parseit(&ui);

            }
         else {
            notice(nick,"ADMIN: Incorrect Password");
            ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","Incorrect ADMIN Password (%s)",hostmask);
            }
         }
      else {
         notice(nick,"ADMIN: %s is not allowed to issue admin commands",hostmask);
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;35","Incorrect ADMIN Hostname (%s)",hostmask);
         }
      }
   
   /*----- XDCC ----- */
   else if ( !gdata.ignore && (!strcmp(caps(msg1),"XDCC") || !strcmp(msg1,"\1XDCC") || !strcmp(caps(msg1),"CDCC") || !strcmp(msg1,"\1CDCC") )) {
      
	 gdata.inamnt[gdata.curtime%10]++;
      caps(msg2);
      
      if (msg3 && msg3[strlen(msg3)-1] == '\1')
         msg3[strlen(msg3)-1] = '\0';
      
	 if ( msg2 && ( !strcmp(msg2,"LIST") || !strcmp(msg2,"LIST\1")))
	   {
	     if ((gdata.nolisting > gdata.curtime) && (gdata.nolistbantime!=-1))
	       {
		 if (gdata.nolistbantime>0)
		   {
		     /* We have someone to ban!! hurrah! */
		     ignoreuser(hostname, gdata.nolistbantime);
		     ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC LIST banned: %s (%s)",nick,hostmask);

		     if (gdata.humiliate)
		       {
			 char tempmessage[maxtextlength];
			 if (pdnolistban==NULL)
			   {
			     pdnolistban=createprintfdata(NULL);
			     initprintfdata(pdnolistban,
				      "t*p minute",&(gdata.nolistbantime),
				      "u*s",&nick,
				      NULL);
			   }
			 else
			   pdnolistban['u'].val.ptr.s=&nick;
			 renderprintfdata(tempmessage,maxtextlength,
					  pdnolistban,gdata.humiliate);			 
			 ioutput(0,OUT_S|OUT_L|OUT_D,"0;33",
				 "XDCC BANSEND to %s: %s",
				 nick,tempmessage);		
			 allchanmsg(tempmessage);
		       } 
		   }
	       }
	     else
	       {
         if (!gdata.attop) gototop();
         
	 if (gdata.restrictlist && !isinmemberlist(nick))
	   {
	     j = 2; /* deny */
	     notice(nick,"XDCC LIST Denied. You must be on a known channel to request a list");
	   }
	 else
	   {
	     for (i=0,j=0; i<MAXXLQUE; i++) 
	       if (gdata.xlistqueue[i] && !strcmp(gdata.xlistqueue[i],nick))
		 j = 1; /* already in queue, ignore */
	     
	     if (!j) {
	       for (i=0; i<MAXXLQUE && gdata.xlistqueue[i]; i++) ;
	       
	       if (i == MAXXLQUE-1) {
		 sendxdlqueue();
               for (i=0; i<MAXXLQUE && gdata.xlistqueue[i]; i++) ;
               }
            
	       gdata.xlistqueue[i] = mycalloc(maxtextlengthshort,"privmsgparse");
	       strncpy(gdata.xlistqueue[i],nick,maxtextlengthshort-1);
            
	     }
	   }
	 
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC LIST %s: (%s)",(j==1?"ignored":(j==2?"denied":"queued")),hostmask);
         
         }
	   } else if(!strcmp(gdata.caps_nick,dest))
	{
         if ( msg2 && msg3 && (!strcmp(msg2,"SEND") || !strcmp(msg2,"GET"))) {
         if (!gdata.attop) gototop();
         ioutput(1,OUT_S|OUT_L|OUT_D,"0;33","XDCC SEND %s",msg3);
         sendxdccfile(nick, hostname, packnumtonum(msg3), NULL);
         }
	 else if ( msg2 && !strcmp(msg2,"REMOVE")) {
         if (!gdata.attop) gototop();
         k=0;
         for (i=0; i<MAXQUEUE && gdata.mainqueue[i]; i++)
            if (!strcmp(gdata.mainqueue[i]->nick,nick)) {
               privmsg(nick,
                  "Removed you from the queue for \"%s\", you waited %li minute%s.",
                  gdata.mainqueue[i]->xpack->desc,(gdata.curtime-gdata.mainqueue[i]->queuedtime)/60,((gdata.curtime-gdata.mainqueue[i]->queuedtime)/60)!=1?"s":"");
               mydelete(gdata.mainqueue[i]);
               for (j=i+1; j<gdata.inqueue; j++)
                  gdata.mainqueue[j-1] = gdata.mainqueue[j];
               gdata.mainqueue[j-1] = NULL;
               gdata.inqueue--;
               k=1;
	       i--;
               }
         for (i=0; i<MAXQUEUE && gdata.packqueue[i]; i++)
            if (!strcmp(gdata.packqueue[i]->nick,nick)) {
               privmsg(nick,
                  "Removed you from the queue for \"%s\", you waited %li minute%s.",
                  gdata.packqueue[i]->xpack->desc,(gdata.curtime-gdata.packqueue[i]->queuedtime)/60,((gdata.curtime-gdata.packqueue[i]->queuedtime)/60)!=1?"s":"");
               mydelete(gdata.packqueue[i]);
               for (j=i+1; j<gdata.inslotsmaxqueue; j++)
                  gdata.packqueue[j-1] = gdata.packqueue[j];
               gdata.packqueue[j-1] = NULL;
               gdata.inslotsmaxqueue--;
               k=1;
	       i--;
               }
         if (!k) privmsg(nick,"You Don't Appear To Be In A Queue");
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC REMOVE (%s) ",hostmask);
         
         }
      else if ( msg2 && !strcmp(msg2,"SEARCH") && msg3) {
         if (!gdata.attop) gototop();
         
         privmsg(nick,"Searching for \"%s\"...",msg3);
         
         for (i=k=0; i<MAXXDCCS; i++)
            if (gdata.xdccs[i])
               if (strcmpany(gdata.xdccs[i]->file,msg3)
                || strcmpany(gdata.xdccs[i]->desc,msg3)
                || strcmpany(gdata.xdccs[i]->note,msg3)) {
                  k++;
                  privmsg(nick," - Pack #%i matches, \"%s\"",i+1,gdata.xdccs[i]->desc);
                  }
         
         if (!k) privmsg(nick,"Sorry, nothing was found, try a XDCC LIST");
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC SEARCH %s (%s)",msg3,hostmask);
         
         }
      }
   }
   
   else if (!strcmp(type,"PRIVMSG")) {
      if (dest && !strcmp(dest,gdata.caps_nick)) {
         plugin_ircprivmsg(line,nick,hostname,dest,msg1,msg2,msg3,msg4,msg5);
         if (gdata.messagefile) {
            ioutput(0,OUT_S|OUT_D,NULL,"MSG from %s logged, use MSGREAD to display it.",nick);
            msglog_add(hostmask,line);
            }
         else
            ioutput(0,OUT_S|OUT_L|OUT_D,NULL,"*** MSG: %s",line);
         
/*         notice(nick,"Unknown Command, Did you mistype?"); */
         }
      }
   
 privmsgparse_cleanup:
   
   msg1--;
   mydelete(dest);
   mydelete(nick);
   mydelete(hostname);
   mydelete(hostmask);
   mydelete(msg1);
   mydelete(msg2);
   mydelete(msg3);
   mydelete(msg4);
   mydelete(msg5);
   mydelete(msg6);
   mydelete(tempstr);
   mydelete(tempstr2);
   
   return;
   }

static void autosendf(char* line) {
   char *nick, *hostname;
   char *tempstr = mycalloc(maxtextlength,"autosendf");
   int i,j;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   floodchk();
   
   nick = mycalloc(maxtextlengthshort,"autosendf");
   hostname = mycalloc(maxtextlength,"autosendf");
      
   i=1; j=0;
   while(line[i] != '!' && i<sstrlen(line) && i<maxtextlengthshort-1) {
      nick[i-1] = line[i];
      i++;
      }
   nick[i-1]='\0';
   
   while(line[i] != '@' && i<sstrlen(line)) { i++; }
   i++;
   
   while(line[i] != ' ' && i<sstrlen(line) && j<maxtextlength-1) {
      hostname[j] = line[i];
      i++;
      j++;
      }
   hostname[j]='\0';
   
   if ( !gdata.ignore ) {
      gdata.inamnt[gdata.curtime%10]++;
      
      if (!gdata.attop) gototop();
      
      ioutput(1,OUT_S|OUT_L|OUT_D,"0;33","AutoSend ");

      isnprintf(tempstr,maxtextlength-2," :*** Sending You %s by DCC",gdata.automsg);
   
      sendxdccfile(nick, hostname, gdata.autopack, tempstr);
      }
   
   mydelete(nick);
   mydelete(hostname);
   mydelete(tempstr);

   }

void sendxdccfile(char* nick, const char* hostname, int pack, char* msg) {
   char *tempstr = mycalloc(maxtextlength,"sendxdccfile");
   char *tempstr2 = mycalloc(maxtextlength,"sendxdccfile");
   int i, temp1, usertrans, userpackok, p, man;
   xdcc *userxfr;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   usertrans = 0;
   userpackok = 1;
   man = 0;
   
   if (!strcmp(hostname,"man"))
      man = 1;
   
   if (!man && (pack > gdata.numpacks || pack < 1))
   {
      int c=0;
      ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," (Bad Pack Number): ");
      if (badpackadd(hostname,&c))
      { /* We need to ban this person */
         ignoreuser(hostname, gdata.badpack.bantime);
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC BADPACK banned: %s (%s)",nick,hostname);
         if (gdata.badpack.humiliate)
         {
            char tempmessage[maxtextlength];
            if (pdinvalidpackban==NULL)
		initprintfdata(pdinvalidpackban=createprintfdata(NULL),
			       "t*p minute",&(gdata.badpack.bantime),
			       "u*s",&(nick),
			       "p*p invalid pack",&(gdata.badpack.maxattempts),
			       "m*p minute",&(gdata.badpack.interval),
			       NULL);
	      else
		pdinvalidpackban['u'].val.ptr.s=&nick;
	      renderprintfdata(tempmessage,maxtextlength,
			       pdinvalidpackban,gdata.badpack.humiliate);
	    ioutput(0,OUT_S|OUT_L|OUT_D,"0;33",
		    "XDCC BANSEND to %s: %s",
		    nick,tempmessage);		
	    allchanmsg(tempmessage);
	 }
	 return;
      }
      else
      {
         if (c==0)
            notice(nick,"*** Invalid Pack Number, Try Again");
	 else
	 {
	    char cbuf[maxtextlength];
	    char *cptr=cbuf;
	    isnprintf(cptr,maxtextlength,"*** Invalid Pack Number, be more accurate or you may be banned %i/%i",c,gdata.badpack.maxattempts);
	    notice (nick,cptr);
	 }
	 return;
      }
   }

   for (i=0, p=0; i<pack && i<MAXXDCCS; i++, p++)
      while ( p<(MAXXDCCS-1) && (gdata.xdccs[p] == NULL))
         p++;
   userxfr = gdata.xdccs[p-1];
   
   for (i=0; i<MAXTRANS; i++)
      if (!man && gdata.trans[i] != NULL && !strcmp(gdata.trans[i]->hostname,hostname)) {
         usertrans++;
         if (userxfr == gdata.trans[i]->xpack)
            userpackok = 0;
         }
   
   if (!man && gdata.restrictsend && !isinmemberlist(nick))
     {
      ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (restricted): ");
      notice(nick,"*** XDCC SEND denied, you must be on a known channel to request a pack");
     }
   else if (USER_MAXS && !man && usertrans && !userpackok) {
      ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (dup): ");
      notice(nick,"*** You already requested that pack");
      }
   else if ( !man && usertrans >= gdata.maxtransfersperperson && userxfr->size > gdata.instasend) {
      ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (user): ");
      notice(nick,"*** You can only have %d transfer%s at a time",gdata.maxtransfersperperson,gdata.maxtransfersperperson!=1?"s":"");
      }
   else if (!man && gdata.nonewcons > gdata.curtime ) {
      ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," (No New Cons): ");
      if (fullignore(nick,hostname))
      notice(nick,"*** The Owner Has Requested That No New Connections Are Made In The Next %li Minute%s",(gdata.nonewcons-gdata.curtime+1)/60,((gdata.nonewcons-gdata.curtime+1)/60)!=1?"s":"");
      }   
   else if (!man && pack == gdata.slotsmaxpack && gdata.slotsmaxslots-gdata.slotsfull <= 0) {
      isnprintf(tempstr,maxtextlength-2,"NOTICE %s :*** Sorry Pack %i Has a Slot Limitation, ",nick,pack);
      addtoqueue(tempstr, nick, hostname, pack);
      writeserver(tempstr);
      }
   else if (!man && gdata.slotsmax-gdata.slotsfull <= 0 && userxfr->size > gdata.instasend) {
      isnprintf(tempstr,maxtextlength-2,"NOTICE %s :*** All Slots Full, ",nick);
      addtoqueue(tempstr, nick, hostname, pack);
      writeserver(tempstr);
      }

   /* check if sending the pack will break our transfer limit
    * if so, refuse and notice the user
    */
   else if (!data_limit_can_send_pack(pack)) {
      /* will exceed limit */
      notice(nick,
             "Sending pack %d will exceed our transfer limit.  Not sending.",
             pack);
      ioutput(1, OUT_S | OUT_L | OUT_D, "0;33", 
              "sendxdccfile: refusing to send - would exceed transfer limit ");
   }
   /* done */

   else {
      /* find a transfer slot */
      temp1=-1;
      for (i=0; (temp1<0 && i<MAXTRANS); i++)
         if (gdata.trans[i] == NULL)
            temp1=i;
      if ( temp1 == -1 ) {
         outerror(1,"Out of Transfer IDs! (This Shouldn't Happen, There Are 100 Of Them)");
         mydelete(tempstr);
         mydelete(tempstr2);
         return;
         }
      
      gdata.trans[temp1] = mycalloc(sizeof(transfer),"sendxdccfile");
      t_initvalues(gdata.trans[temp1]);
      gdata.trans[temp1]->id = temp1;
      strncpy(gdata.trans[temp1]->nick,nick,maxtextlengthshort-1);
      strncpy(gdata.trans[temp1]->caps_nick,nick,maxtextlengthshort-1);
      caps(gdata.trans[temp1]->caps_nick);
      strncpy(gdata.trans[temp1]->hostname,hostname,maxtextlength-1);
      
      gdata.trans[temp1]->xpack = userxfr;
      
      if (!man)
         ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," requested: ");
      gdata.slotsfull++;
      if (!msg)
         notice(nick,"*** Sending You Pack #%i Which Is %sB. (Resume Supported)",
            pack,sizestr(0,tempstr2,gdata.trans[temp1]->xpack->size));
      else {
         isnprintf(tempstr,maxtextlength-2,"NOTICE %s%s Which Is %sB. (Resume Supported)",
            nick,msg,sizestr(0,tempstr2,gdata.trans[temp1]->xpack->size));
         writeserver(tempstr);
         }

      t_setuplisten(gdata.trans[temp1]);

      privmsg(nick,"\1DCC SEND %s %lu %i %lu\1",
         getfilename(gdata.trans[temp1]->xpack->file),
         gdata.ourip,
         gdata.trans[temp1]->listenport,
         (unsigned long)gdata.trans[temp1]->xpack->size);
      }
   if (!man)
      ioutput(3,OUT_S|OUT_L|OUT_D,"0;33","%s (%s)",nick,hostname);

   mydelete(tempstr);
   mydelete(tempstr2);

   }
   
static void addtoqueue(char* srvmsg, char* nick, const char* hostname, int pack) {
   char *tempstr = mycalloc(maxtextlength,"addtoqueue");
   pqueue *tempq;
   xdcc *tempx;
   int i,p,inq,alreadytrans;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   for (i=0, p=0; i<pack; i++, p++)
      while ( p<(MAXXDCCS-1) && (gdata.xdccs[p] == NULL))
         p++;
   tempx = gdata.xdccs[p-1];
   
   for (alreadytrans=inq=i=0; i<MAXQUEUE; i++) {
     if (gdata.mainqueue[i] != NULL && !strcmp(gdata.mainqueue[i]->hostname,hostname)) {
       inq++;
       if (gdata.mainqueue[i]->xpack == tempx)
	 alreadytrans++;
     }
     if (gdata.packqueue[i] != NULL && !strcmp(gdata.packqueue[i]->hostname,hostname)) {
       inq++;
       if (gdata.packqueue[i]->xpack == tempx)
	 alreadytrans++;
     }
   }
   
   /* transfer limit - don't queue if the pack is too big to send. */
   if (!data_limit_can_send_pack(pack)) {
      isnprintf(tempstr, maxtextlength - 2,
                "%sTransfering pack %d will exceed limit.  Not sending.",
                srvmsg, pack);
      strncpy(srvmsg, tempstr, maxtextlength - 1);
      ioutput(3,OUT_S|OUT_L|OUT_D,"0;33",
              "Refused to queue pack %d for %s - would exceed transfer limit.",
              pack, nick);
      mydelete(tempstr);
      return;
   }
   /* done */
   
   if (alreadytrans) {
      ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (queue/dup): ");
      isnprintf(tempstr,maxtextlength-2,
         "%sDenied, You already have that item queued.",
         srvmsg);
      strncpy(srvmsg,tempstr,maxtextlength-1);
      mydelete(tempstr);
      return;
      }
   
   if (inq >= gdata.maxqueueditemsperperson) {
      ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (user/queue): ");
      isnprintf(tempstr,maxtextlength-2,
         "%sDenied, You already have %i items queued, Try Again Later",
         srvmsg,inq);
      strncpy(srvmsg,tempstr,maxtextlength-1);
      mydelete(tempstr);
      return;
      }
   
   
   if (pack == gdata.slotsmaxpack) {
      if (gdata.inslotsmaxqueue >= gdata.slotsmaxqueue) {
         ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (pack/queue): ");
         isnprintf(tempstr,maxtextlength-2,
            "%sQueue for pack %d of size %d is Full, Try Again Later",
            srvmsg,pack,gdata.slotsmaxqueue);
         strncpy(srvmsg,tempstr,maxtextlength-1);
	 if (fullignore(nick,hostname)==0)
	   srvmsg[0]=0;
         }
      else {
         ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," Queued (pack): ");
         tempq = mycalloc(sizeof(pqueue),"addtoqueue");
         tempq->queuedtime = gdata.curtime;
         strncpy(tempq->nick,nick,maxtextlengthshort-1);
         strncpy(tempq->hostname,hostname,maxtextlength-1);
         tempq->xpack = tempx;
         gdata.packqueue[gdata.inslotsmaxqueue] = tempq;
         isnprintf(tempstr,maxtextlength-2,
            "%sAdded you to pack %d queue in position %d. To Remove youself at "
            "a later time type \"/msg %s xdcc remove\".",
            srvmsg,pack,gdata.inslotsmaxqueue+1,gdata.user_nick);
         strncpy(srvmsg,tempstr,maxtextlength-1);
         gdata.inslotsmaxqueue++;
         }
      }
   else {
      if (gdata.inqueue >= gdata.queuesize) {
         ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (slot/queue): ");
         isnprintf(tempstr,maxtextlength-2,
            "%sMain queue of size %d is Full, Try Again Later",
            srvmsg,gdata.queuesize);
         strncpy(srvmsg,tempstr,maxtextlength-1);
	 if (fullignore(nick,hostname)==0)
	   srvmsg[0]=0;
         }
      else {
         ioutput(2,OUT_S|OUT_L|OUT_D,"0;33"," Queued (slot): ");
         tempq = mycalloc(sizeof(pqueue),"addtoqueue");
         tempq->queuedtime = gdata.curtime;
         strncpy(tempq->nick,nick,maxtextlengthshort-1);
         strncpy(tempq->hostname,hostname,maxtextlength-1);
         tempq->xpack = tempx;
         gdata.mainqueue[gdata.inqueue] = tempq;

         isnprintf(tempstr,maxtextlength-2,
            "%sAdded you to the main queue in position %d. To Remove youself at "
            "a later time type \"/msg %s xdcc remove\".",
            srvmsg,gdata.inqueue+1,gdata.user_nick);
         strncpy(srvmsg,tempstr,maxtextlength-1);
         gdata.inqueue++;
         }
      }
   mydelete(tempstr);
   }

/*
 * void static prunequeues(pqueue **, int *)
 * remove top entry in queue until we find one small enough we can send it
 * or until queue is empty
 */
void static prunequeues(pqueue **the_queue, int *queue_size) {

   int i, pack = -1;

   while (*queue_size > 0) {

      /* find pack by size (if same size as some other, don't care) */
      for (i = 0; i < gdata.numpacks; i++)
         if (gdata.xdccs[i]->size == the_queue[0]->xpack->size) {
            pack = i + 1; /* packs indexed from 1 not 0 */
            break;
         }

      if ((pack != -1) && (data_limit_can_send_pack(pack))) return;
      else {
         if (pack == -1) {
            /* this should never happen */
            outerror(1, "Pack of size %u queued, but no such pack!",
                     the_queue[0]->xpack->size);
         }
         /* we can't send it, so notice user and remove from the queue */
         notice(the_queue[0]->nick,
                "Cannot send your queue - would exceed transfer limit.");
         ioutput(0, OUT_S | OUT_L | OUT_D, "0;33", 
                 "Removed %s from the queue - transfer too large for limit.",
                 the_queue[0]->nick);
         /* remove from the queue */
         mydelete(the_queue[0]);
         *queue_size -= 1;
         for (i = 1; i <= *queue_size; i++)
            the_queue[i - 1] = the_queue[i];
      }
   }
}

void sendaqueue(int type) {
   char *tempstr2;
   int i, temp1;
   
   updatecontext(__FILE__,__FUNCTION__,__LINE__);

   if (!gdata.attop) gototop();
   
   /*
    * make sure we can send w/o exceeding xfer limit
    */

   if ((gdata.data_limit.max_kbytes != 0) &&
       (gdata.data_limit.records != NULL)) {
      /* limit enabled */
      if (gdata.inqueue) {

         /* strip top looking for something we can send */
         prunequeues(gdata.mainqueue, &(gdata.inqueue));

         if ((gdata.inqueue == 0) && (gdata.inslotsmaxqueue > 0)) {
            /* nothing left so move to pack queue and repeat */
            prunequeues(gdata.packqueue, &(gdata.inslotsmaxqueue));
         }
      }
   }
   /* done */
   
   tempstr2 = mycalloc(maxtextlength,"sendaqueue");
   
   if (gdata.inqueue) {
      
      if (type == 1)
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","QUEUED SEND (low bandwidth): %s (%s)",gdata.mainqueue[0]->nick,gdata.mainqueue[0]->hostname);
      else if (type == 2)
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","QUEUED SEND (manual): %s (%s)",gdata.mainqueue[0]->nick,gdata.mainqueue[0]->hostname);
      else
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","QUEUED SEND: %s (%s)",gdata.mainqueue[0]->nick,gdata.mainqueue[0]->hostname);
      
      /* find a transfer slot */
      temp1=-1;
      for (i=0; (temp1<0 && i<MAXTRANS); i++)
         if (gdata.trans[i] == NULL)
            temp1=i;
      if ( temp1 == -1 ) {
         outerror(1,"Out of Transfer IDs! (This Shouldn't Happen)");
         mydelete(tempstr2);
         return;
         }
      
      gdata.trans[temp1] = mycalloc(sizeof(transfer),"sendaqueue");
      t_initvalues(gdata.trans[temp1]);
      gdata.trans[temp1]->id = temp1;
      strncpy(gdata.trans[temp1]->nick,gdata.mainqueue[0]->nick,maxtextlengthshort-1);
      strncpy(gdata.trans[temp1]->caps_nick,gdata.mainqueue[0]->nick,maxtextlengthshort-1);
      caps(gdata.trans[temp1]->caps_nick);
      strncpy(gdata.trans[temp1]->hostname,gdata.mainqueue[0]->hostname,maxtextlength-1);
      
      gdata.trans[temp1]->xpack = gdata.mainqueue[0]->xpack;
      
      gdata.slotsfull++;
      notice(gdata.mainqueue[0]->nick,"*** Sending You Your Queued Pack Which Is %sB. (Resume Supported)",
         sizestr(0,tempstr2,gdata.trans[temp1]->xpack->size));
      
      t_setuplisten(gdata.trans[temp1]);
      
      privmsg(gdata.mainqueue[0]->nick,"\1DCC SEND %s %lu %i %lu\1",
         getfilename(gdata.trans[temp1]->xpack->file),
         gdata.ourip,
         gdata.trans[temp1]->listenport,
         (unsigned long)gdata.trans[temp1]->xpack->size);

      mydelete(gdata.mainqueue[0]);
      for (i=1; i<gdata.inqueue; i++)
         gdata.mainqueue[i-1] = gdata.mainqueue[i];
      gdata.mainqueue[i-1] = NULL;
      gdata.inqueue--;
      }
   
   else if (gdata.inslotsmaxqueue && (gdata.slotsmaxslots-gdata.slotsfull > 0 || type == 2)) {
      if (type == 1)
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","QUEUED SEND (PACK) (low bandwidth): %s (%s)",gdata.packqueue[0]->nick,gdata.packqueue[0]->hostname);
      else if (type == 2)
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","QUEUED SEND (PACK) (manual): %s (%s)",gdata.packqueue[0]->nick,gdata.packqueue[0]->hostname);
      else
         ioutput(0,OUT_S|OUT_L|OUT_D,"0;33","QUEUED SEND (PACK): %s (%s)",gdata.packqueue[0]->nick,gdata.packqueue[0]->hostname);
      
      /* find a transfer slot */
      temp1=-1;
      for (i=0; (temp1<0 && i<MAXTRANS); i++)
         if (gdata.trans[i] == NULL)
            temp1=i;
      if ( temp1 == -1 ) {
         outerror(1,"Out of Transfer IDs! (This Shouldn't Happen)");
         mydelete(tempstr2);
         return;
         }
      
      gdata.trans[temp1] = mycalloc(sizeof(transfer),"sendaqueue");
      t_initvalues(gdata.trans[temp1]);
      gdata.trans[temp1]->id = temp1;
      strncpy(gdata.trans[temp1]->nick,gdata.packqueue[0]->nick,maxtextlengthshort-1);
      strncpy(gdata.trans[temp1]->caps_nick,gdata.packqueue[0]->nick,maxtextlengthshort-1);
      caps(gdata.trans[temp1]->caps_nick);
      strncpy(gdata.trans[temp1]->hostname,gdata.packqueue[0]->hostname,maxtextlength-1);
      
      gdata.trans[temp1]->xpack = gdata.packqueue[0]->xpack;
      
      gdata.slotsfull++;
      notice(gdata.packqueue[0]->nick,"*** Sending You Your Queued Pack Which Is %sB. (Resume Supported)",
         sizestr(0,tempstr2,gdata.trans[temp1]->xpack->size));
      
      t_setuplisten(gdata.trans[temp1]);
      
      privmsg(gdata.packqueue[0]->nick,"\1DCC SEND %s %lu %i %lu\1",
         getfilename(gdata.trans[temp1]->xpack->file),
         gdata.ourip,
         gdata.trans[temp1]->listenport,
         (unsigned long)gdata.trans[temp1]->xpack->size);

      mydelete(gdata.packqueue[0]);
      for (i=1; i<gdata.inslotsmaxqueue; i++)
         gdata.packqueue[i-1] = gdata.packqueue[i];
      gdata.packqueue[i-1] = NULL;
      gdata.inslotsmaxqueue--;
      }
   
   mydelete(tempstr2);
   
   }

/* End of File */
